/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.version;

import java.net.JarURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.pentaho.di.core.xml.XMLHandler;

public class BuildVersion {
    public static final String REFERENCE_FILE = "/kettle-steps.xml";
    private static final String JAR_BUILD_DATE_FORMAT = "yyyy-MM-dd HH.mm.ss";
    private static BuildVersion buildVersion;
    private String version;
    private String revision;
    private String buildDate;
    private String buildUser;

    public static final BuildVersion getInstance() {
        if (buildVersion != null) {
            return buildVersion;
        }
        buildVersion = new BuildVersion();
        return buildVersion;
    }

    private BuildVersion() {
        try {
            URL url = this.getClass().getResource(REFERENCE_FILE);
            JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
            Manifest manifest = jarConnection.getManifest();
            this.version = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            this.revision = manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VERSION);
            this.buildDate = manifest.getMainAttributes().getValue("Compile-Timestamp");
            this.buildUser = manifest.getMainAttributes().getValue("Compile-User");
        }
        catch (Exception e) {
            this.version = "4.4.0";
            this.revision = "";
            this.buildDate = XMLHandler.date2string(new Date());
            this.buildUser = "";
        }
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public Date getBuildDateAsLocalDate() {
        SimpleDateFormat sdf = new SimpleDateFormat(JAR_BUILD_DATE_FORMAT);
        try {
            Date d = sdf.parse(this.buildDate);
            return d;
        }
        catch (ParseException e) {
            sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
            try {
                Date d = sdf.parse(this.buildDate);
                return d;
            }
            catch (ParseException parseException) {
                return null;
            }
        }
    }

    public void setBuildDate(String buildDate) {
        this.buildDate = buildDate;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getBuildUser() {
        return this.buildUser;
    }

    public void setBuildUser(String buildUser) {
        this.buildUser = buildUser;
    }
}

