/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.module.georss.geometries;

public class PositionList
implements Cloneable {
    private double[] latitude;
    private double[] longitude;
    private int size = 0;

    public Object clone() throws CloneNotSupportedException {
        PositionList positionList = (PositionList)super.clone();
        if (this.latitude != null) {
            positionList.latitude = (double[])this.latitude.clone();
        }
        if (this.longitude != null) {
            positionList.longitude = (double[])this.longitude.clone();
        }
        positionList.size = this.size;
        return positionList;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        PositionList positionList = (PositionList)object;
        if (positionList.size != this.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (positionList.latitude[i] == this.latitude[i] && positionList.longitude[i] == this.longitude[i]) continue;
            return false;
        }
        return true;
    }

    private void ensureCapacity(int n) {
        if (this.longitude != null && this.longitude.length >= n) {
            return;
        }
        n = n < 4 ? 4 : (int)Math.ceil(Math.pow(2.0, Math.ceil(Math.log(n) / Math.log(2.0))));
        double[] dArray = new double[n];
        if (this.longitude != null) {
            System.arraycopy(this.longitude, 0, dArray, 0, this.size);
        }
        this.longitude = dArray;
        dArray = new double[n];
        if (this.latitude != null) {
            System.arraycopy(this.latitude, 0, dArray, 0, this.size);
        }
        this.latitude = dArray;
    }

    public int size() {
        return this.size;
    }

    public double getLongitude(int n) {
        return this.longitude[n];
    }

    public double getLatitude(int n) {
        return this.latitude[n];
    }

    public void add(double d, double d2) {
        this.ensureCapacity(this.size + 1);
        this.longitude[this.size] = d2;
        this.latitude[this.size] = d;
        ++this.size;
    }

    public void insert(int n, double d, double d2) {
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.longitude, n, this.longitude, n + 1, this.size - n);
        System.arraycopy(this.latitude, n, this.latitude, n + 1, this.size - n);
        this.longitude[n] = d2;
        this.latitude[n] = d;
        ++this.size;
    }

    public void replace(int n, double d, double d2) {
        this.longitude[n] = d2;
        this.latitude[n] = d;
    }

    public void remove(int n) {
        System.arraycopy(this.longitude, n + 1, this.longitude, n, this.size - n - 1);
        System.arraycopy(this.latitude, n + 1, this.latitude, n, this.size - n - 1);
        --this.size;
    }
}

