/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.jdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.hive.jdbc.HadoopConfigurationUtil;
import org.apache.hadoop.hive.jdbc.JDBCDriverCallable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiveDriver
implements Driver {
    private static final String METHOD_GET_HIVE_JDBC_DRIVER = "getHiveJdbcDriver";
    private HadoopConfigurationUtil util;

    public HiveDriver() {
        this(new HadoopConfigurationUtil());
    }

    public HiveDriver(HadoopConfigurationUtil util) {
        if (util == null) {
            throw new NullPointerException();
        }
        this.util = util;
    }

    protected Driver getActiveDriver() throws SQLException {
        Driver driver = null;
        try {
            Object shim = this.util.getActiveHadoopShim();
            Method getHiveJdbcDriver = shim.getClass().getMethod(METHOD_GET_HIVE_JDBC_DRIVER, new Class[0]);
            driver = (Driver)getHiveJdbcDriver.invoke(shim, new Object[0]);
        }
        catch (Exception ex) {
            throw new SQLException("Unable to load Hive JDBC driver for the currently active Hadoop configuration", ex);
        }
        if (driver == null || driver.getClass() == this.getClass()) {
            throw new SQLException("The active Hadoop configuration does not contain a Hive JDBC driver");
        }
        return driver;
    }

    protected <T> T callWithActiveDriver(JDBCDriverCallable<T> callback) throws SQLException {
        return callback.callWithDriver(this.getActiveDriver());
    }

    @Override
    public Connection connect(final String url, final Properties info) throws SQLException {
        return this.callWithActiveDriver(new JDBCDriverCallable<Connection>(){

            @Override
            public Connection call() throws Exception {
                return this.driver.connect(url, info);
            }
        });
    }

    @Override
    public boolean acceptsURL(final String url) throws SQLException {
        return Boolean.TRUE.equals(this.callWithActiveDriver(new JDBCDriverCallable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return this.driver.acceptsURL(url);
            }
        }));
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(final String url, final Properties info) throws SQLException {
        return this.callWithActiveDriver(new JDBCDriverCallable<DriverPropertyInfo[]>(){

            @Override
            public DriverPropertyInfo[] call() throws Exception {
                return this.driver.getPropertyInfo(url, info);
            }
        });
    }

    @Override
    public int getMajorVersion() {
        try {
            return this.callWithActiveDriver(new JDBCDriverCallable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return this.driver.getMajorVersion();
                }
            });
        }
        catch (SQLException ex) {
            return -1;
        }
    }

    @Override
    public int getMinorVersion() {
        try {
            return this.callWithActiveDriver(new JDBCDriverCallable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return this.driver.getMinorVersion();
                }
            });
        }
        catch (SQLException ex) {
            return -1;
        }
    }

    @Override
    public boolean jdbcCompliant() {
        try {
            return Boolean.TRUE.equals(this.callWithActiveDriver(new JDBCDriverCallable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return this.driver.jdbcCompliant();
                }
            }));
        }
        catch (SQLException ex) {
            return false;
        }
    }

    static {
        try {
            DriverManager.registerDriver(new HiveDriver());
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to register Hive JDBC driver", ex);
        }
    }
}

