/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ExtensionVisitor;
import com.google.gdata.data.Feed;
import com.google.gdata.data.Link;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.ErrorContent;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExtensionDescription.Default(nsAlias="gd", nsUri="http://schemas.google.com/g/2005", localName="feedLink")
public class FeedLink<F extends BaseFeed<?, ?>>
extends Link {
    protected boolean readOnly = false;
    protected Integer countHint;
    protected BaseFeed<?, ?> feed;
    protected final Class<F> feedClass;

    public FeedLink() {
        this(Feed.class);
    }

    public FeedLink(Class<F> feedClass) {
        this.feedClass = feedClass;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean v) {
        this.readOnly = v;
    }

    public Integer getCountHint() {
        return this.countHint;
    }

    public void setCountHint(Integer v) {
        this.countHint = v;
    }

    public F getFeed() {
        return (F)this.feed;
    }

    public void setFeed(F v) {
        this.feed = v;
    }

    public Class<F> getFeedClass() {
        return this.feedClass;
    }

    public static ExtensionDescription getDefaultDescription() {
        return ExtensionDescription.getDefaultDescription(FeedLink.class);
    }

    public String getType() {
        return ContentType.getAtomFeed().toString();
    }

    protected void visitChildren(ExtensionVisitor ev) throws ExtensionVisitor.StoppedException {
        if (this.feed != null) {
            this.visitChild(ev, (Extension)this.feed);
        }
        super.visitChildren(ev);
    }

    public void generate(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>();
        if (this.rel != null) {
            attrs.add(new XmlWriter.Attribute("rel", this.rel));
        }
        if (this.href != null) {
            attrs.add(new XmlWriter.Attribute("href", this.href));
        }
        if (this.readOnly) {
            attrs.add(new XmlWriter.Attribute("readOnly", "true"));
        }
        if (this.countHint != null) {
            attrs.add(new XmlWriter.Attribute("countHint", this.countHint.toString()));
        }
        this.generateStartElement(w, Namespaces.gNs, "feedLink", attrs, null);
        if (this.feed != null) {
            ExtensionProfile nestedExtProfile = extProfile.getFeedLinkProfile();
            if (nestedExtProfile == null) {
                nestedExtProfile = extProfile;
            }
            this.feed.generateAtom(w, nestedExtProfile);
        }
        this.generateExtensions(w, extProfile);
        w.endElement(Namespaces.gNs, "feedLink");
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) {
        return new Handler(extProfile);
    }

    private class Handler
    extends Link.AtomHandler {
        public Handler(ExtensionProfile extProfile) {
            super((Link)FeedLink.this, extProfile, FeedLink.class);
        }

        public void processAttribute(String namespace, String localName, String value) throws ParseException {
            if (namespace.equals("")) {
                if (localName.equals("readOnly")) {
                    FeedLink.this.readOnly = value.equals("true");
                } else if (localName.equals("countHint")) {
                    try {
                        FeedLink.this.countHint = Integer.valueOf(value);
                    }
                    catch (NumberFormatException e) {
                        throw new ParseException((ErrorContent)CoreErrorDomain.ERR.invalidCountHintAttribute, (Throwable)e);
                    }
                } else {
                    super.processAttribute(namespace, localName, value);
                }
            }
        }

        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            if (namespace.equals("http://www.w3.org/2005/Atom") && localName.equals("feed")) {
                ExtensionProfile nestedExtProfile = this.extProfile.getFeedLinkProfile();
                if (nestedExtProfile == null) {
                    nestedExtProfile = this.extProfile;
                }
                try {
                    FeedLink.this.feed = (BaseFeed)FeedLink.this.feedClass.newInstance();
                }
                catch (IllegalAccessException iae) {
                    throw new ParseException((ErrorContent)CoreErrorDomain.ERR.cantCreateFeed, (Throwable)iae);
                }
                catch (InstantiationException ie) {
                    throw new ParseException((ErrorContent)CoreErrorDomain.ERR.cantCreateFeed, (Throwable)ie);
                }
                BaseFeed<?, ?> baseFeed = FeedLink.this.feed;
                baseFeed.getClass();
                return new BaseFeed.FeedHandler(baseFeed, nestedExtProfile);
            }
            return super.getChildHandler(namespace, localName, attrs);
        }
    }
}

