/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="gd", nsUri="http://schemas.google.com/g/2005", localName="when", isRepeatable=true)
public class When
extends ExtensionPoint
implements Extension {
    static final String WHEN = "when";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final String VALUE_STRING = "valueString";
    protected String rel;
    protected DateTime startTime;
    protected DateTime endTime;
    protected String valueString;

    public String getRel() {
        return this.rel;
    }

    public void setRel(String v) {
        this.rel = v;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(DateTime v) {
        this.startTime = v;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(DateTime v) {
        this.endTime = v;
    }

    public String getValueString() {
        return this.valueString;
    }

    public void setValueString(String v) {
        this.valueString = v;
    }

    public static ExtensionDescription getDefaultDescription(boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(When.class);
        desc.setRepeatable(repeatable);
        return desc;
    }

    public static ExtensionDescription getDefaultDescription() {
        return When.getDefaultDescription(true);
    }

    protected void validate() throws IllegalStateException {
        if (this.startTime == null) {
            When.throwExceptionForMissingAttribute((String)START_TIME);
        }
        if (this.endTime != null) {
            if (this.startTime.compareTo((Object)this.endTime) > 0) {
                throw new IllegalStateException("g:when/@startTime must be less than or equal to g:when/@endTime.");
            }
            if (this.startTime.isDateOnly() != this.endTime.isDateOnly()) {
                throw new IllegalStateException((this.startTime.isDateOnly() ? "Date" : "Date/time") + " value expected.");
            }
        }
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put(START_TIME, (Object)this.startTime);
        generator.put(END_TIME, (Object)this.endTime);
        generator.put((Object)VALUE_STRING, (Object)this.valueString);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.startTime = helper.consumeDateTime(START_TIME, true);
        this.endTime = helper.consumeDateTime(END_TIME, false);
        this.valueString = helper.consume(VALUE_STRING, false);
    }
}

