/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPProgressMonitorEx;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTransferOutputStream;
import com.enterprisedt.net.ftp.TransferDirection;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FTPOutputStream
extends FileTransferOutputStream {
    private static Logger log = Logger.getLogger("FTPOutputStream");
    private long monitorInterval;
    private FTPClient client;
    private BufferedOutputStream out;
    private long size = 0L;
    private boolean isASCII = false;
    private long monitorCount = 0L;
    private FTPProgressMonitor monitor;
    private FTPProgressMonitorEx monitorEx;
    private byte[] prevBuf = new byte[FTPClient.FTP_LINE_SEPARATOR.length];
    private int matchpos = 0;

    public FTPOutputStream(FTPClient client, String remoteFile) throws IOException, FTPException {
        this(client, remoteFile, false);
    }

    public FTPOutputStream(FTPClient client, String remoteFile, boolean append) throws IOException, FTPException {
        this.client = client;
        this.remoteFile = remoteFile;
        try {
            this.remoteFile = client.initPut(remoteFile, append);
            this.out = new BufferedOutputStream(new DataOutputStream(client.getOutputStream()), client.getTransferBufferSize() * 2);
        }
        catch (IOException ex) {
            client.validateTransferOnError(ex);
            throw ex;
        }
        this.monitorInterval = client.getMonitorInterval();
        this.monitor = client.getProgressMonitor();
        this.isASCII = client.getType().equals(FTPTransferType.ASCII);
    }

    public void setMonitor(FTPProgressMonitorEx monitor, long monitorInterval) {
        this.monitor = monitor;
        this.monitorEx = monitor;
        this.monitorInterval = monitorInterval;
    }

    public void write(int b) throws IOException {
        byte[] tmp = new byte[]{(byte)b};
        this.write(tmp, 0, 1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.isASCII) {
            for (int i = off; i < off + len; ++i) {
                if (b[i] == 10 && this.matchpos == 0) {
                    this.out.write(13);
                    this.out.write(10);
                    this.size += 2L;
                    this.monitorCount += 2L;
                    continue;
                }
                if (b[i] == FTPClient.FTP_LINE_SEPARATOR[this.matchpos]) {
                    this.prevBuf[this.matchpos] = b[i];
                    ++this.matchpos;
                    if (this.matchpos != FTPClient.FTP_LINE_SEPARATOR.length) continue;
                    this.out.write(13);
                    this.out.write(10);
                    this.size += 2L;
                    this.monitorCount += 2L;
                    this.matchpos = 0;
                    continue;
                }
                if (this.matchpos > 0) {
                    this.out.write(13);
                    this.out.write(10);
                    this.size += 2L;
                    this.monitorCount += 2L;
                }
                this.out.write(b[i]);
                ++this.size;
                ++this.monitorCount;
                this.matchpos = 0;
            }
        } else {
            this.out.write(b, off, len);
            this.size += (long)len;
            this.monitorCount += (long)len;
        }
        if (this.monitor != null && this.monitorCount > this.monitorInterval) {
            this.monitor.bytesTransferred(this.size);
            this.monitorCount = 0L;
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.isASCII && this.matchpos > 0) {
                this.out.write(this.prevBuf, 0, this.matchpos);
                this.size += (long)this.matchpos;
                this.monitorCount += (long)this.matchpos;
            }
            this.client.forceResumeOff();
            this.client.closeDataSocket(this.out);
            if (this.monitor != null) {
                this.monitor.bytesTransferred(this.size);
            }
            log.debug("Transferred " + this.size + " bytes from remote host");
            try {
                this.client.validateTransfer();
            }
            catch (FTPException ex) {
                throw new IOException(ex.getMessage());
            }
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.UPLOAD, this.remoteFile);
            }
        }
    }
}

