/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.DelegateFileObject;

public class VirtualFileSystem
extends AbstractFileSystem {
    private final Map junctions = new HashMap();

    public VirtualFileSystem(FileName fileName, FileSystemOptions fileSystemOptions) {
        super(fileName, null, fileSystemOptions);
    }

    protected void addCapabilities(Collection collection) {
        collection.add(Capability.ATTRIBUTES);
        collection.add(Capability.CREATE);
        collection.add(Capability.DELETE);
        collection.add(Capability.GET_TYPE);
        collection.add(Capability.JUNCTIONS);
        collection.add(Capability.GET_LAST_MODIFIED);
        collection.add(Capability.SET_LAST_MODIFIED_FILE);
        collection.add(Capability.SET_LAST_MODIFIED_FOLDER);
        collection.add(Capability.LIST_CHILDREN);
        collection.add(Capability.READ_CONTENT);
        collection.add(Capability.SIGNING);
        collection.add(Capability.WRITE_CONTENT);
        collection.add(Capability.APPEND_CONTENT);
    }

    protected FileObject createFile(FileName fileName) throws Exception {
        FileObject fileObject;
        FileName fileName2 = this.getJunctionForFile(fileName);
        if (fileName2 != null) {
            FileObject fileObject2 = (FileObject)this.junctions.get(fileName2);
            String string = fileName2.getRelativeName(fileName);
            fileObject = fileObject2.resolveFile(string, NameScope.DESCENDENT_OR_SELF);
        } else {
            fileObject = null;
        }
        return new DelegateFileObject(fileName, this, fileObject);
    }

    public void addJunction(String string, FileObject fileObject) throws FileSystemException {
        FileName fileName = this.getFileSystemManager().resolveName(this.getRootName(), string);
        if (this.getJunctionForFile(fileName) != null) {
            throw new FileSystemException("vfs.impl/nested-junction.error", fileName);
        }
        try {
            this.junctions.put(fileName, fileObject);
            DelegateFileObject delegateFileObject = (DelegateFileObject)this.getFileFromCache(fileName);
            if (delegateFileObject != null) {
                delegateFileObject.setFile(fileObject);
            }
            FileName fileName2 = fileName;
            boolean bl = false;
            for (FileName fileName3 = fileName2.getParent(); !bl && fileName3 != null; fileName3 = fileName3.getParent()) {
                DelegateFileObject delegateFileObject2 = (DelegateFileObject)this.getFileFromCache(fileName3);
                if (delegateFileObject2 == null) {
                    delegateFileObject2 = new DelegateFileObject(fileName3, this, null);
                    this.putFileToCache(delegateFileObject2);
                } else {
                    bl = delegateFileObject2.exists();
                }
                delegateFileObject2.attachChild(fileName2, FileType.FOLDER);
                fileName2 = fileName3;
            }
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.impl/create-junction.error", fileName, (Throwable)exception);
        }
    }

    public void removeJunction(String string) throws FileSystemException {
        FileName fileName = this.getFileSystemManager().resolveName(this.getRootName(), string);
        this.junctions.remove(fileName);
    }

    private FileName getJunctionForFile(FileName fileName) {
        if (this.junctions.containsKey(fileName)) {
            return fileName;
        }
        for (FileName fileName2 : this.junctions.keySet()) {
            if (!fileName2.isDescendent(fileName)) continue;
            return fileName2;
        }
        return null;
    }
}

