/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.operations;

import java.util.ArrayList;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.operations.FileOperation;
import org.apache.commons.vfs.operations.FileOperationProvider;
import org.apache.commons.vfs.operations.FileOperations;

public class DefaultFileOperations
implements FileOperations {
    private FileSystemManager fsmanager;
    private FileObject fileObject;

    public DefaultFileOperations(FileObject fileObject) {
        this.fileObject = fileObject;
        this.fsmanager = fileObject.getFileSystem().getFileSystemManager();
    }

    public Class[] getOperations() throws FileSystemException {
        String string = this.fileObject.getURL().getProtocol();
        FileOperationProvider[] fileOperationProviderArray = this.fsmanager.getOperationProviders(string);
        if (fileOperationProviderArray == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < fileOperationProviderArray.length; ++i) {
            FileOperationProvider fileOperationProvider = fileOperationProviderArray[i];
            fileOperationProvider.collectOperations(arrayList, this.fileObject);
        }
        return arrayList.toArray(new Class[0]);
    }

    public FileOperation getOperation(Class clazz) throws FileSystemException {
        FileOperationProvider fileOperationProvider;
        String string = this.fileObject.getURL().getProtocol();
        FileOperationProvider[] fileOperationProviderArray = this.fsmanager.getOperationProviders(string);
        if (fileOperationProviderArray == null) {
            throw new FileSystemException("vfs.provider/operation-not-supported.error", clazz);
        }
        FileOperation fileOperation = null;
        for (int i = 0; i < fileOperationProviderArray.length && (fileOperation = (fileOperationProvider = fileOperationProviderArray[i]).getOperation(this.fileObject, clazz)) == null; ++i) {
        }
        if (fileOperation == null) {
            throw new FileSystemException("vfs.provider/operation-not-supported.error", clazz);
        }
        return fileOperation;
    }

    public boolean hasOperation(Class clazz) throws FileSystemException {
        Class[] classArray = this.getOperations();
        if (classArray == null) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz2 = classArray[i];
            if (!clazz.isAssignableFrom(clazz2)) continue;
            return true;
        }
        return false;
    }
}

