/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.provider.UriParser;

public abstract class AbstractFileName
implements FileName {
    private final String scheme;
    private final String absPath;
    private FileType type;
    private String uri;
    private String baseName;
    private String rootUri = null;
    private String extension;
    private String decodedAbsPath;
    private boolean calculateHashCode = true;
    private int calculatedHashCode;

    public AbstractFileName(String string, String string2, FileType fileType) {
        this.scheme = string;
        this.type = fileType;
        this.absPath = string2 != null && string2.length() > 0 ? (string2.length() > 1 && string2.endsWith("/") ? string2.substring(0, string2.length() - 1) : string2) : "/";
    }

    public int hashCode() {
        if (this.calculateHashCode) {
            this.calculatedHashCode = this.getRootURI().hashCode() ^ this.getPath().hashCode();
            this.calculateHashCode = false;
        }
        return this.calculatedHashCode;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractFileName)) {
            return false;
        }
        AbstractFileName abstractFileName = (AbstractFileName)object;
        return this.getRootURI().equals(abstractFileName.getRootURI()) && this.getPath().equals(abstractFileName.getPath());
    }

    public int compareTo(Object object) {
        AbstractFileName abstractFileName = (AbstractFileName)object;
        int n = this.getRootURI().compareTo(abstractFileName.getRootURI());
        if (n != 0) {
            return n;
        }
        try {
            return this.getPathDecoded().compareTo(abstractFileName.getPathDecoded());
        }
        catch (FileSystemException fileSystemException) {
            throw new RuntimeException(fileSystemException.getMessage());
        }
    }

    public String toString() {
        return this.getURI();
    }

    public abstract FileName createName(String var1, FileType var2);

    protected abstract void appendRootUri(StringBuffer var1, boolean var2);

    public String getBaseName() {
        if (this.baseName == null) {
            int n = this.getPath().lastIndexOf(47);
            this.baseName = n == -1 ? this.getPath() : this.getPath().substring(n + 1);
        }
        return this.baseName;
    }

    public String getPath() {
        if (VFS.isUriStyle()) {
            return this.absPath + this.getUriTrailer();
        }
        return this.absPath;
    }

    protected String getUriTrailer() {
        return this.getType().hasChildren() ? "/" : "";
    }

    public String getPathDecoded() throws FileSystemException {
        if (this.decodedAbsPath == null) {
            this.decodedAbsPath = UriParser.decode(this.getPath());
        }
        return this.decodedAbsPath;
    }

    public FileName getParent() {
        int n = this.getPath().lastIndexOf(47);
        if (n == -1 || n == this.getPath().length() - 1) {
            return null;
        }
        String string = n == 0 ? "/" : this.getPath().substring(0, n);
        return this.createName(string, FileType.FOLDER);
    }

    public FileName getRoot() {
        FileName fileName = this;
        while (fileName.getParent() != null) {
            fileName = fileName.getParent();
        }
        return fileName;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getURI() {
        if (this.uri == null) {
            this.uri = this.createURI();
        }
        return this.uri;
    }

    protected String createURI() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendRootUri(stringBuffer, true);
        stringBuffer.append(this.getPath());
        return stringBuffer.toString();
    }

    public String getRelativeName(FileName fileName) throws FileSystemException {
        int n;
        String string = fileName.getPath();
        int n2 = this.getPath().length();
        int n3 = string.length();
        if (n2 == 1 && n3 == 1) {
            return ".";
        }
        if (n2 == 1) {
            return string.substring(1);
        }
        int n4 = Math.min(n2, n3);
        for (n = 0; n < n4 && this.getPath().charAt(n) == string.charAt(n); ++n) {
        }
        if (n == n2 && n == n3) {
            return ".";
        }
        if (n == n2 && n < n3 && string.charAt(n) == '/') {
            return string.substring(n + 1);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n3 > 1 && (n < n3 || this.getPath().charAt(n) != '/')) {
            n = this.getPath().lastIndexOf(47, n);
            stringBuffer.append(string.substring(n));
        }
        stringBuffer.insert(0, "..");
        n = this.getPath().indexOf(47, n + 1);
        while (n != -1) {
            stringBuffer.insert(0, "../");
            n = this.getPath().indexOf(47, n + 1);
        }
        return stringBuffer.toString();
    }

    public String getRootURI() {
        if (this.rootUri == null) {
            StringBuffer stringBuffer = new StringBuffer();
            this.appendRootUri(stringBuffer, true);
            stringBuffer.append('/');
            this.rootUri = stringBuffer.toString().intern();
        }
        return this.rootUri;
    }

    public int getDepth() {
        int n = this.getPath().length();
        if (n == 0 || n == 1 && this.getPath().charAt(0) == '/') {
            return 0;
        }
        int n2 = 1;
        int n3 = 0;
        while (n3 > -1 && n3 < n) {
            n3 = this.getPath().indexOf(47, n3 + 1);
            ++n2;
        }
        return n2;
    }

    public String getExtension() {
        if (this.extension == null) {
            this.getBaseName();
            int n = this.baseName.lastIndexOf(46);
            this.extension = n < 1 || n == this.baseName.length() - 1 ? "" : this.baseName.substring(n + 1).intern();
        }
        return this.extension;
    }

    public boolean isAncestor(FileName fileName) {
        if (!fileName.getRootURI().equals(this.getRootURI())) {
            return false;
        }
        return AbstractFileName.checkName(fileName.getPath(), this.getPath(), NameScope.DESCENDENT);
    }

    public boolean isDescendent(FileName fileName) {
        return this.isDescendent(fileName, NameScope.DESCENDENT);
    }

    public boolean isDescendent(FileName fileName, NameScope nameScope) {
        if (!fileName.getRootURI().equals(this.getRootURI())) {
            return false;
        }
        return AbstractFileName.checkName(this.getPath(), fileName.getPath(), nameScope);
    }

    public FileType getType() {
        return this.type;
    }

    void setType(FileType fileType) throws FileSystemException {
        if (fileType != FileType.FOLDER && fileType != FileType.FILE && fileType != FileType.FILE_OR_FOLDER) {
            throw new FileSystemException("vfs.provider/filename-type.error");
        }
        this.type = fileType;
    }

    public static boolean checkName(String string, String string2, NameScope nameScope) {
        if (nameScope == NameScope.FILE_SYSTEM) {
            return true;
        }
        if (!string2.startsWith(string)) {
            return false;
        }
        int n = string.length();
        if (VFS.isUriStyle()) {
            --n;
        }
        if (nameScope == NameScope.CHILD) {
            if (string2.length() == n || n > 1 && string2.charAt(n) != '/' || string2.indexOf(47, n + 1) != -1) {
                return false;
            }
        } else if (nameScope == NameScope.DESCENDENT) {
            if (string2.length() == n || n > 1 && string2.charAt(n) != '/') {
                return false;
            }
        } else if (nameScope == NameScope.DESCENDENT_OR_SELF) {
            if (n > 1 && string2.length() > n && string2.charAt(n) != '/') {
                return false;
            }
        } else if (nameScope != NameScope.FILE_SYSTEM) {
            throw new IllegalArgumentException();
        }
        return true;
    }

    public String getFriendlyURI() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendRootUri(stringBuffer, false);
        stringBuffer.append(this.getPath());
        return stringBuffer.toString();
    }
}

