/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.AbstractVfsContainer;
import org.apache.commons.vfs.provider.FileNameParser;
import org.apache.commons.vfs.provider.FileProvider;
import org.apache.commons.vfs.provider.FileSystemKey;
import org.apache.commons.vfs.provider.local.GenericFileNameParser;

public abstract class AbstractFileProvider
extends AbstractVfsContainer
implements FileProvider {
    private final Map fileSystems = new TreeMap();
    private FileNameParser parser = GenericFileNameParser.getInstance();

    protected FileNameParser getFileNameParser() {
        return this.parser;
    }

    protected void setFileNameParser(FileNameParser fileNameParser) {
        this.parser = fileNameParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AbstractFileProvider abstractFileProvider = this;
        synchronized (abstractFileProvider) {
            this.fileSystems.clear();
        }
        super.close();
    }

    public FileObject createFileSystem(String string, FileObject fileObject, FileSystemOptions fileSystemOptions) throws FileSystemException {
        throw new FileSystemException("vfs.provider/not-layered-fs.error", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileSystem(Comparable comparable, FileSystem fileSystem) throws FileSystemException {
        this.addComponent(fileSystem);
        FileSystemKey fileSystemKey = new FileSystemKey(comparable, fileSystem.getFileSystemOptions());
        ((AbstractFileSystem)fileSystem).setCacheKey(fileSystemKey);
        AbstractFileProvider abstractFileProvider = this;
        synchronized (abstractFileProvider) {
            this.fileSystems.put(fileSystemKey, fileSystem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem findFileSystem(Comparable comparable, FileSystemOptions fileSystemOptions) {
        FileSystemKey fileSystemKey = new FileSystemKey(comparable, fileSystemOptions);
        AbstractFileProvider abstractFileProvider = this;
        synchronized (abstractFileProvider) {
            return (FileSystem)this.fileSystems.get(fileSystemKey);
        }
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeUnusedResources() {
        Object[] objectArray;
        AbstractFileProvider abstractFileProvider = this;
        synchronized (abstractFileProvider) {
            objectArray = this.fileSystems.values().toArray();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            AbstractFileSystem abstractFileSystem = (AbstractFileSystem)objectArray[i];
            if (!abstractFileSystem.isReleaseable()) continue;
            abstractFileSystem.closeCommunicationLink();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFileSystem(FileSystem fileSystem) {
        AbstractFileSystem abstractFileSystem = (AbstractFileSystem)fileSystem;
        AbstractFileProvider abstractFileProvider = this;
        synchronized (abstractFileProvider) {
            if (abstractFileSystem.getCacheKey() != null) {
                this.fileSystems.remove(abstractFileSystem.getCacheKey());
            }
        }
        this.removeComponent(abstractFileSystem);
        abstractFileSystem.close();
    }

    public FileName parseUri(FileName fileName, String string) throws FileSystemException {
        if (this.getFileNameParser() != null) {
            return this.getFileNameParser().parseUri(this.getContext(), fileName, string);
        }
        throw new FileSystemException("vfs.provider/filename-parser-missing.error");
    }
}

