/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileContentInfo;
import org.apache.commons.vfs.FileContentInfoFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.FileContentThreadData;
import org.apache.commons.vfs.util.MonitorInputStream;
import org.apache.commons.vfs.util.MonitorOutputStream;
import org.apache.commons.vfs.util.MonitorRandomAccessContent;
import org.apache.commons.vfs.util.RandomAccessMode;

public final class DefaultFileContent
implements FileContent {
    static final int STATE_CLOSED = 0;
    static final int STATE_OPENED = 1;
    private final AbstractFileObject file;
    private Map attrs;
    private Map roAttrs;
    private FileContentInfo fileContentInfo;
    private final FileContentInfoFactory fileContentInfoFactory;
    private final ThreadLocal threadData = new ThreadLocal();
    private boolean resetAttributes;
    private int openStreams;

    public DefaultFileContent(AbstractFileObject abstractFileObject, FileContentInfoFactory fileContentInfoFactory) {
        this.file = abstractFileObject;
        this.fileContentInfoFactory = fileContentInfoFactory;
    }

    private FileContentThreadData getThreadData() {
        FileContentThreadData fileContentThreadData = (FileContentThreadData)this.threadData.get();
        if (fileContentThreadData == null) {
            fileContentThreadData = new FileContentThreadData();
            this.threadData.set(fileContentThreadData);
        }
        return fileContentThreadData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamOpened() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            ++this.openStreams;
        }
        ((AbstractFileSystem)this.file.getFileSystem()).streamOpened();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamClosed() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            if (this.openStreams > 0) {
                --this.openStreams;
                if (this.openStreams < 1) {
                    this.file.notifyAllStreamsClosed();
                }
            }
        }
        ((AbstractFileSystem)this.file.getFileSystem()).streamClosed();
    }

    public FileObject getFile() {
        return this.file;
    }

    public long getSize() throws FileSystemException {
        if (!this.file.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/get-size-not-file.error", this.file);
        }
        try {
            return this.file.doGetContentSize();
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/get-size.error", new Object[]{this.file}, (Throwable)exception);
        }
    }

    public long getLastModifiedTime() throws FileSystemException {
        if (!this.file.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/get-last-modified-no-exist.error", this.file);
        }
        try {
            return this.file.doGetLastModifiedTime();
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/get-last-modified.error", this.file, (Throwable)exception);
        }
    }

    public void setLastModifiedTime(long l) throws FileSystemException {
        if (!this.file.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/set-last-modified-no-exist.error", this.file);
        }
        try {
            if (!this.file.doSetLastModTime(l)) {
                throw new FileSystemException("vfs.provider/set-last-modified.error", this.file);
            }
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/set-last-modified.error", this.file, (Throwable)exception);
        }
    }

    public boolean hasAttribute(String string) throws FileSystemException {
        if (!this.file.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/exists-attributes-no-exist.error", this.file);
        }
        this.getAttributes();
        return this.attrs.containsKey(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAttributes() throws FileSystemException {
        if (!this.file.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/get-attributes-no-exist.error", this.file);
        }
        if (this.resetAttributes || this.roAttrs == null) {
            try {
                DefaultFileContent defaultFileContent = this;
                synchronized (defaultFileContent) {
                    this.attrs = this.file.doGetAttributes();
                    this.roAttrs = Collections.unmodifiableMap(this.attrs);
                    this.resetAttributes = false;
                }
            }
            catch (Exception exception) {
                throw new FileSystemException("vfs.provider/get-attributes.error", this.file, (Throwable)exception);
            }
        }
        return this.roAttrs;
    }

    public void resetAttributes() {
        this.resetAttributes = true;
    }

    public String[] getAttributeNames() throws FileSystemException {
        this.getAttributes();
        Set set = this.attrs.keySet();
        return set.toArray(new String[set.size()]);
    }

    public Object getAttribute(String string) throws FileSystemException {
        this.getAttributes();
        return this.attrs.get(string);
    }

    public void setAttribute(String string, Object object) throws FileSystemException {
        if (!this.file.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/set-attribute-no-exist.error", new Object[]{string, this.file});
        }
        try {
            this.file.doSetAttribute(string, object);
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/set-attribute.error", new Object[]{string, this.file}, (Throwable)exception);
        }
        if (this.attrs != null) {
            this.attrs.put(string, object);
        }
    }

    public void removeAttribute(String string) throws FileSystemException {
        if (!this.file.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/remove-attribute-no-exist.error", this.file);
        }
        try {
            this.file.doRemoveAttribute(string);
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/remove-attribute.error", new Object[]{string, this.file}, (Throwable)exception);
        }
        if (this.attrs != null) {
            this.attrs.remove(string);
        }
    }

    public Certificate[] getCertificates() throws FileSystemException {
        if (!this.file.exists()) {
            throw new FileSystemException("vfs.provider/get-certificates-no-exist.error", this.file);
        }
        try {
            Certificate[] certificateArray = this.file.doGetCertificates();
            if (certificateArray != null) {
                return certificateArray;
            }
            return new Certificate[0];
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/get-certificates.error", this.file, (Throwable)exception);
        }
    }

    public InputStream getInputStream() throws FileSystemException {
        InputStream inputStream = this.file.getInputStream();
        FileContentInputStream fileContentInputStream = new FileContentInputStream(this.file, inputStream);
        this.getThreadData().addInstr(fileContentInputStream);
        this.streamOpened();
        return fileContentInputStream;
    }

    public RandomAccessContent getRandomAccessContent(RandomAccessMode randomAccessMode) throws FileSystemException {
        RandomAccessContent randomAccessContent = this.file.getRandomAccessContent(randomAccessMode);
        FileRandomAccessContent fileRandomAccessContent = new FileRandomAccessContent(this.file, randomAccessContent);
        this.getThreadData().addRastr(fileRandomAccessContent);
        this.streamOpened();
        return fileRandomAccessContent;
    }

    public OutputStream getOutputStream() throws FileSystemException {
        return this.getOutputStream(false);
    }

    public OutputStream getOutputStream(boolean bl) throws FileSystemException {
        if (this.getThreadData().getOutstr() != null) {
            throw new FileSystemException("vfs.provider/write-in-use.error", this.file);
        }
        OutputStream outputStream = this.file.getOutputStream(bl);
        this.getThreadData().setOutstr(new FileContentOutputStream(this.file, outputStream));
        this.streamOpened();
        return this.getThreadData().getOutstr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws FileSystemException {
        try {
            Object object;
            while (this.getThreadData().getInstrsSize() > 0) {
                object = (FileContentInputStream)this.getThreadData().removeInstr(0);
                ((FileContentInputStream)object).close();
            }
            while (this.getThreadData().getRastrsSize() > 0) {
                object = (RandomAccessContent)this.getThreadData().removeRastr(0);
                try {
                    object.close();
                }
                catch (IOException iOException) {
                    throw new FileSystemException(iOException);
                }
            }
            if (this.getThreadData().getOutstr() != null) {
                this.getThreadData().closeOutstr();
            }
        }
        finally {
            this.threadData.set(null);
        }
    }

    private void endInput(FileContentInputStream fileContentInputStream) {
        this.getThreadData().removeInstr(fileContentInputStream);
        this.streamClosed();
    }

    private void endRandomAccess(RandomAccessContent randomAccessContent) {
        this.getThreadData().removeRastr(randomAccessContent);
        this.streamClosed();
    }

    private void endOutput() throws Exception {
        this.streamClosed();
        this.getThreadData().setOutstr(null);
        this.file.endOutput();
    }

    public boolean isOpen() {
        return this.getThreadData().hasStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpenGlobal() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            return this.openStreams > 0;
        }
    }

    public FileContentInfo getContentInfo() throws FileSystemException {
        if (this.fileContentInfo == null) {
            this.fileContentInfo = this.fileContentInfoFactory.create(this);
        }
        return this.fileContentInfo;
    }

    final class FileContentOutputStream
    extends MonitorOutputStream {
        private final FileObject file;

        FileContentOutputStream(FileObject fileObject, OutputStream outputStream) {
            super(outputStream);
            this.file = fileObject;
        }

        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException iOException) {
                throw new FileSystemException("vfs.provider/close-outstr.error", this.file, (Throwable)iOException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                try {
                    DefaultFileContent.this.endOutput();
                }
                catch (Exception exception) {
                    throw new FileSystemException("vfs.provider/close-outstr.error", this.file, (Throwable)exception);
                }
            }
        }
    }

    private final class FileRandomAccessContent
    extends MonitorRandomAccessContent {
        private final FileObject file;
        private final RandomAccessContent content;

        FileRandomAccessContent(FileObject fileObject, RandomAccessContent randomAccessContent) {
            super(randomAccessContent);
            this.file = fileObject;
            this.content = randomAccessContent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                DefaultFileContent.this.endRandomAccess(this);
            }
        }
    }

    private final class FileContentInputStream
    extends MonitorInputStream {
        private final FileObject file;

        FileContentInputStream(FileObject fileObject, InputStream inputStream) {
            super(inputStream);
            this.file = fileObject;
        }

        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException iOException) {
                throw new FileSystemException("vfs.provider/close-instr.error", this.file, (Throwable)iOException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                DefaultFileContent.this.endInput(this);
            }
        }
    }
}

