/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ftp;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticationData;
import org.apache.commons.vfs.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.ftp.FTPClientWrapper;
import org.apache.commons.vfs.provider.ftp.FtpFileNameParser;
import org.apache.commons.vfs.provider.ftp.FtpFileSystem;
import org.apache.commons.vfs.provider.ftp.FtpFileSystemConfigBuilder;

public class FtpFileProvider
extends AbstractOriginatingFileProvider {
    public static final String ATTR_FILE_ENTRY_PARSER = "FEP";
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};
    static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.GET_LAST_MODIFIED, Capability.URI, Capability.WRITE_CONTENT, Capability.APPEND_CONTENT, Capability.RANDOM_ACCESS_READ));

    public FtpFileProvider() {
        this.setFileNameParser(FtpFileNameParser.getInstance());
    }

    protected FileSystem doCreateFileSystem(FileName fileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        GenericFileName genericFileName = (GenericFileName)fileName;
        FTPClientWrapper fTPClientWrapper = new FTPClientWrapper(genericFileName, fileSystemOptions);
        return new FtpFileSystem(genericFileName, fTPClientWrapper, fileSystemOptions);
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return FtpFileSystemConfigBuilder.getInstance();
    }

    public Collection getCapabilities() {
        return capabilities;
    }
}

