/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ftp;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.VfsLog;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.ftp.FTPClientWrapper;
import org.apache.commons.vfs.provider.ftp.FtpClient;
import org.apache.commons.vfs.provider.ftp.FtpFileObject;
import org.apache.commons.vfs.provider.ftp.FtpFileProvider;

public class FtpFileSystem
extends AbstractFileSystem {
    private static final Log LOG = LogFactory.getLog(FtpFileSystem.class);
    private FtpClient idleClient;

    protected FtpFileSystem(GenericFileName genericFileName, FtpClient ftpClient, FileSystemOptions fileSystemOptions) {
        super(genericFileName, null, fileSystemOptions);
        this.idleClient = ftpClient;
    }

    protected void doCloseCommunicationLink() {
        if (this.idleClient != null) {
            this.closeConnection(this.idleClient);
            this.idleClient = null;
        }
    }

    protected void addCapabilities(Collection collection) {
        collection.addAll(FtpFileProvider.capabilities);
    }

    private void closeConnection(FtpClient ftpClient) {
        try {
            if (ftpClient.isConnected()) {
                ftpClient.disconnect();
            }
        }
        catch (IOException iOException) {
            VfsLog.warn(this.getLogger(), LOG, "vfs.provider.ftp/close-connection.error", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FtpClient getClient() throws FileSystemException {
        FtpFileSystem ftpFileSystem = this;
        synchronized (ftpFileSystem) {
            if (this.idleClient == null || !this.idleClient.isConnected()) {
                this.idleClient = null;
                return new FTPClientWrapper((GenericFileName)this.getRoot().getName(), this.getFileSystemOptions());
            }
            FtpClient ftpClient = this.idleClient;
            this.idleClient = null;
            return ftpClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putClient(FtpClient ftpClient) {
        FtpFileSystem ftpFileSystem = this;
        synchronized (ftpFileSystem) {
            if (this.idleClient == null) {
                this.idleClient = ftpClient;
            } else {
                this.closeConnection(ftpClient);
            }
        }
    }

    protected FileObject createFile(FileName fileName) throws FileSystemException {
        return new FtpFileObject(fileName, this, this.getRootName());
    }
}

