/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.local;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.local.LocalFileNameParser;
import org.apache.commons.vfs.provider.local.WindowsFileName;

public class WindowsFileNameParser
extends LocalFileNameParser {
    protected String extractRootPrefix(String string, StringBuffer stringBuffer) throws FileSystemException {
        return this.extractWindowsRootPrefix(string, stringBuffer);
    }

    protected FileName createFileName(String string, String string2, String string3, FileType fileType) {
        return new WindowsFileName(string, string2, string3, fileType);
    }

    private String extractWindowsRootPrefix(String string, StringBuffer stringBuffer) throws FileSystemException {
        int n;
        int n2 = Math.min(4, stringBuffer.length());
        for (n = 0; n < n2 && stringBuffer.charAt(n) == '/'; ++n) {
        }
        if (n == n2 && stringBuffer.length() > n && stringBuffer.charAt(n + 1) == '/') {
            throw new FileSystemException("vfs.provider.local/not-absolute-file-name.error", string);
        }
        stringBuffer.delete(0, n);
        String string2 = this.extractDrivePrefix(stringBuffer);
        if (string2 != null) {
            return string2;
        }
        if (n < 2) {
            throw new FileSystemException("vfs.provider.local/not-absolute-file-name.error", string);
        }
        return "//" + this.extractUNCPrefix(string, stringBuffer);
    }

    private String extractDrivePrefix(StringBuffer stringBuffer) {
        if (stringBuffer.length() < 3) {
            return null;
        }
        char c = stringBuffer.charAt(0);
        if (c == '/' || c == ':') {
            return null;
        }
        if (stringBuffer.charAt(1) != ':') {
            return null;
        }
        if (stringBuffer.charAt(2) != '/') {
            return null;
        }
        String string = stringBuffer.substring(0, 2);
        stringBuffer.delete(0, 2);
        return string.intern();
    }

    private String extractUNCPrefix(String string, StringBuffer stringBuffer) throws FileSystemException {
        int n;
        int n2 = stringBuffer.length();
        for (n = 0; n < n2 && stringBuffer.charAt(n) != '/'; ++n) {
        }
        if (++n >= n2) {
            throw new FileSystemException("vfs.provider.local/missing-share-name.error", string);
        }
        int n3 = n;
        while (n < n2 && stringBuffer.charAt(n) != '/') {
            ++n;
        }
        if (n == n3) {
            throw new FileSystemException("vfs.provider.local/missing-share-name.error", string);
        }
        String string2 = stringBuffer.substring(0, n);
        stringBuffer.delete(0, n);
        return string2;
    }
}

