/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ram;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;

class RamFileData
implements Serializable {
    private FileName name;
    private FileType type;
    private byte[] buffer;
    private long lastModified;
    private Collection children;

    public RamFileData(FileName fileName) {
        this.clear();
        if (fileName == null) {
            throw new IllegalArgumentException("name can not be null");
        }
        this.name = fileName;
    }

    byte[] getBuffer() {
        return this.buffer;
    }

    void setBuffer(byte[] byArray) {
        this.updateLastModified();
        this.buffer = byArray;
    }

    long getLastModified() {
        return this.lastModified;
    }

    void setLastModified(long l) {
        this.lastModified = l;
    }

    FileType getType() {
        return this.type;
    }

    void setType(FileType fileType) {
        this.type = fileType;
    }

    void clear() {
        this.buffer = new byte[0];
        this.updateLastModified();
        this.type = FileType.IMAGINARY;
        this.children = Collections.synchronizedCollection(new ArrayList());
        this.name = null;
    }

    void updateLastModified() {
        this.lastModified = System.currentTimeMillis();
    }

    FileName getName() {
        return this.name;
    }

    public String toString() {
        return this.name.toString();
    }

    void addChild(RamFileData ramFileData) throws FileSystemException {
        if (!this.getType().hasChildren()) {
            throw new FileSystemException("A child can only be added in a folder");
        }
        if (ramFileData == null) {
            throw new FileSystemException("No child can be null");
        }
        if (this.children.contains(ramFileData)) {
            throw new FileSystemException("Child already exists. " + ramFileData);
        }
        this.children.add(ramFileData);
        this.updateLastModified();
    }

    void removeChild(RamFileData ramFileData) throws FileSystemException {
        if (!this.getType().hasChildren()) {
            throw new FileSystemException("A child can only be removed from a folder");
        }
        if (!this.children.contains(ramFileData)) {
            throw new FileSystemException("Child not found. " + ramFileData);
        }
        this.children.remove(ramFileData);
        this.updateLastModified();
    }

    Collection getChildren() {
        if (this.name == null) {
            throw new IllegalStateException("Data is clear");
        }
        return this.children;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RamFileData)) {
            return false;
        }
        RamFileData ramFileData = (RamFileData)object;
        return this.getName().equals(ramFileData.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    boolean hasChildren(RamFileData ramFileData) {
        return this.children.contains(ramFileData);
    }

    int size() {
        return this.buffer.length;
    }

    void resize(int n) {
        int n2 = this.size();
        byte[] byArray = new byte[n];
        System.arraycopy(this.buffer, 0, byArray, 0, n2);
        this.buffer = byArray;
        this.updateLastModified();
    }
}

