/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.res;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileProvider;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.res.ResourceFileSystemConfigBuilder;

public class ResourceFileProvider
extends AbstractFileProvider {
    protected static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.DISPATCHER));

    public FileObject findFile(FileObject fileObject, String string, FileSystemOptions fileSystemOptions) throws FileSystemException {
        URL uRL;
        StringBuffer stringBuffer = new StringBuffer(80);
        UriParser.extractScheme(string, stringBuffer);
        String string2 = stringBuffer.toString();
        ClassLoader classLoader = ResourceFileSystemConfigBuilder.getInstance().getClassLoader(fileSystemOptions);
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if ((uRL = classLoader.getResource(string2)) == null) {
            throw new FileSystemException("vfs.provider.url/badly-formed-uri.error", string);
        }
        FileObject fileObject2 = this.getContext().getFileSystemManager().resolveFile(uRL.toExternalForm());
        return fileObject2;
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return ResourceFileSystemConfigBuilder.getInstance();
    }

    public void closeFileSystem(FileSystem fileSystem) {
    }

    public Collection getCapabilities() {
        return capabilities;
    }
}

