/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileNotFoundException;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.sftp.SftpFileSystem;
import org.apache.commons.vfs.provider.sftp.SftpRandomAccessContent;
import org.apache.commons.vfs.util.FileObjectUtils;
import org.apache.commons.vfs.util.MonitorInputStream;
import org.apache.commons.vfs.util.MonitorOutputStream;
import org.apache.commons.vfs.util.RandomAccessMode;

public class SftpFileObject
extends AbstractFileObject
implements FileObject {
    private final SftpFileSystem fileSystem;
    private SftpATTRS attrs;
    private final String relPath;
    private boolean inRefresh;

    protected SftpFileObject(FileName fileName, SftpFileSystem sftpFileSystem) throws FileSystemException {
        super(fileName, sftpFileSystem);
        this.fileSystem = sftpFileSystem;
        this.relPath = UriParser.decode(sftpFileSystem.getRootName().getRelativeName(fileName));
    }

    protected void doDetach() throws Exception {
        this.attrs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws FileSystemException {
        if (!this.inRefresh) {
            try {
                this.inRefresh = true;
                super.refresh();
                try {
                    this.attrs = null;
                    this.getType();
                }
                catch (IOException iOException) {
                    throw new FileSystemException(iOException);
                }
            }
            finally {
                this.inRefresh = false;
            }
        }
    }

    protected FileType doGetType() throws Exception {
        if (this.attrs == null) {
            this.statSelf();
        }
        if (this.attrs == null) {
            return FileType.IMAGINARY;
        }
        if ((this.attrs.getFlags() & 4) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-permissions.error");
        }
        if (this.attrs.isDir()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    protected void onChange() throws Exception {
        this.statSelf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statSelf() throws Exception {
        block8: {
            ChannelSftp channelSftp = this.fileSystem.getChannel();
            try {
                this.setStat(channelSftp.stat(this.relPath));
            }
            catch (SftpException sftpException) {
                try {
                    if (sftpException.id != 2) {
                        channelSftp.disconnect();
                        channelSftp = this.fileSystem.getChannel();
                        this.setStat(channelSftp.stat(this.relPath));
                        break block8;
                    }
                    this.attrs = null;
                }
                catch (SftpException sftpException2) {
                    this.attrs = null;
                }
            }
            finally {
                this.fileSystem.putChannel(channelSftp);
            }
        }
    }

    private void setStat(SftpATTRS sftpATTRS) {
        this.attrs = sftpATTRS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCreateFolder() throws Exception {
        ChannelSftp channelSftp = this.fileSystem.getChannel();
        try {
            channelSftp.mkdir(this.relPath);
        }
        finally {
            this.fileSystem.putChannel(channelSftp);
        }
    }

    protected long doGetLastModifiedTime() throws Exception {
        if (this.attrs == null || (this.attrs.getFlags() & 8) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-modtime.error");
        }
        return (long)this.attrs.getMTime() * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetLastModifiedTime(long l) throws Exception {
        ChannelSftp channelSftp = this.fileSystem.getChannel();
        try {
            int n = (int)(l / 1000L);
            this.attrs.setACMODTIME(this.attrs.getATime(), n);
            channelSftp.setStat(this.relPath, this.attrs);
        }
        finally {
            this.fileSystem.putChannel(channelSftp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() throws Exception {
        ChannelSftp channelSftp = this.fileSystem.getChannel();
        try {
            if (this.getType() == FileType.FILE) {
                channelSftp.rm(this.relPath);
            } else {
                channelSftp.rmdir(this.relPath);
            }
        }
        finally {
            this.fileSystem.putChannel(channelSftp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRename(FileObject fileObject) throws Exception {
        ChannelSftp channelSftp = this.fileSystem.getChannel();
        try {
            channelSftp.rename(this.relPath, ((SftpFileObject)fileObject).relPath);
        }
        finally {
            this.fileSystem.putChannel(channelSftp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject[] doListChildrenResolved() throws Exception {
        Vector vector;
        ChannelSftp channelSftp = this.fileSystem.getChannel();
        String string = null;
        try {
            try {
                if (this.relPath != null) {
                    string = channelSftp.pwd();
                    channelSftp.cd(this.relPath);
                }
            }
            catch (SftpException sftpException) {
                FileObject[] fileObjectArray = null;
                this.fileSystem.putChannel(channelSftp);
                return fileObjectArray;
            }
            try {
                vector = channelSftp.ls(".");
            }
            catch (SftpException sftpException) {
                try {
                    if (this.relPath != null) {
                        channelSftp.cd(string);
                    }
                }
                catch (SftpException sftpException2) {
                    throw sftpException;
                }
                throw sftpException;
            }
            try {
                if (this.relPath != null) {
                    channelSftp.cd(string);
                }
            }
            catch (SftpException sftpException) {
                throw new FileSystemException("vfs.provider.sftp/change-work-directory-back.error", string);
            }
        }
        finally {
            this.fileSystem.putChannel(channelSftp);
        }
        if (vector == null) {
            throw new FileSystemException("vfs.provider.sftp/list-children.error");
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (ChannelSftp.LsEntry lsEntry : vector) {
            String string2 = lsEntry.getFilename();
            if (VFS.isUriStyle() && lsEntry.getAttrs().isDir() && string2.charAt(string2.length() - 1) != '/') {
                string2 = string2 + "/";
            }
            if (string2.equals(".") || string2.equals("..") || string2.equals("./") || string2.equals("../")) continue;
            FileObject fileObject = this.getFileSystem().resolveFile(this.getFileSystem().getFileSystemManager().resolveName(this.getName(), UriParser.encode(string2), NameScope.CHILD));
            ((SftpFileObject)FileObjectUtils.getAbstractFileObject(fileObject)).setStat(lsEntry.getAttrs());
            arrayList.add(fileObject);
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    protected String[] doListChildren() throws Exception {
        return null;
    }

    protected long doGetContentSize() throws Exception {
        if (this.attrs == null || (this.attrs.getFlags() & 1) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-size.error");
        }
        return this.attrs.getSize();
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode randomAccessMode) throws Exception {
        return new SftpRandomAccessContent(this, randomAccessMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream getInputStream(long l) throws IOException {
        ChannelSftp channelSftp = this.fileSystem.getChannel();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                channelSftp.get(this.getName().getPathDecoded(), (OutputStream)byteArrayOutputStream, null, 1, l);
            }
            catch (SftpException sftpException) {
                throw new FileSystemException(sftpException);
            }
            byteArrayOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            this.fileSystem.putChannel(channelSftp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream doGetInputStream() throws Exception {
        SftpFileSystem sftpFileSystem = this.fileSystem;
        synchronized (sftpFileSystem) {
            InputStream inputStream;
            ChannelSftp channelSftp = this.fileSystem.getChannel();
            try {
                if (!this.getType().hasContent()) {
                    throw new FileSystemException("vfs.provider/read-not-file.error", this.getName());
                }
                inputStream = channelSftp.get(this.relPath);
            }
            catch (SftpException sftpException) {
                if (sftpException.id == 2) {
                    throw new FileNotFoundException(this.getName());
                }
                throw new FileSystemException(sftpException);
            }
            SftpInputStream sftpInputStream = new SftpInputStream(channelSftp, inputStream);
            return sftpInputStream;
        }
    }

    protected OutputStream doGetOutputStream(boolean bl) throws Exception {
        ChannelSftp channelSftp = this.fileSystem.getChannel();
        return new SftpOutputStream(channelSftp, channelSftp.put(this.relPath));
    }

    private class SftpOutputStream
    extends MonitorOutputStream {
        private final ChannelSftp channel;

        public SftpOutputStream(ChannelSftp channelSftp, OutputStream outputStream) {
            super(outputStream);
            this.channel = channelSftp;
        }

        protected void onClose() throws IOException {
            SftpFileObject.this.fileSystem.putChannel(this.channel);
        }
    }

    private class SftpInputStream
    extends MonitorInputStream {
        private final ChannelSftp channel;

        public SftpInputStream(ChannelSftp channelSftp, InputStream inputStream) {
            super(inputStream);
            this.channel = channelSftp;
        }

        protected void onClose() throws IOException {
            SftpFileObject.this.fileSystem.putChannel(this.channel);
        }
    }
}

