/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticationData;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.sftp.SftpClientFactory;
import org.apache.commons.vfs.provider.sftp.SftpFileObject;
import org.apache.commons.vfs.provider.sftp.SftpFileProvider;
import org.apache.commons.vfs.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs.util.UserAuthenticatorUtils;

public class SftpFileSystem
extends AbstractFileSystem
implements FileSystem {
    private Session session;
    private ChannelSftp idleChannel;

    protected SftpFileSystem(GenericFileName genericFileName, Session session, FileSystemOptions fileSystemOptions) {
        super(genericFileName, null, fileSystemOptions);
        this.session = session;
    }

    protected void doCloseCommunicationLink() {
        if (this.idleChannel != null) {
            this.idleChannel.disconnect();
            this.idleChannel = null;
        }
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    protected ChannelSftp getChannel() throws IOException {
        ChannelSftp channelSftp;
        Object object;
        Object object2;
        block11: {
            if (this.session != null && this.session.isConnected()) break block11;
            this.doCloseCommunicationLink();
            object2 = null;
            try {
                object = (GenericFileName)this.getRootName();
                object2 = UserAuthenticatorUtils.authenticate(this.getFileSystemOptions(), SftpFileProvider.AUTHENTICATOR_TYPES);
                channelSftp = SftpClientFactory.createConnection(((GenericFileName)object).getHostName(), ((GenericFileName)object).getPort(), UserAuthenticatorUtils.getData((UserAuthenticationData)object2, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(((GenericFileName)object).getUserName())), UserAuthenticatorUtils.getData((UserAuthenticationData)object2, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(((GenericFileName)object).getPassword())), this.getFileSystemOptions());
            }
            catch (Exception exception) {
                try {
                    throw new FileSystemException("vfs.provider.sftp/connect.error", this.getRootName(), (Throwable)exception);
                }
                catch (Throwable throwable) {
                    UserAuthenticatorUtils.cleanup(object2);
                    throw throwable;
                }
            }
            UserAuthenticatorUtils.cleanup((UserAuthenticationData)object2);
            this.session = channelSftp;
        }
        try {
            if (this.idleChannel != null) {
                channelSftp = this.idleChannel;
                this.idleChannel = null;
            } else {
                channelSftp = (ChannelSftp)this.session.openChannel("sftp");
                channelSftp.connect();
                object2 = SftpFileSystemConfigBuilder.getInstance().getUserDirIsRoot(this.getFileSystemOptions());
                object = this.getRootName().getPath();
                if (!(object == null || object2 != null && ((Boolean)object2).booleanValue())) {
                    try {
                        channelSftp.cd((String)object);
                    }
                    catch (SftpException sftpException) {
                        throw new FileSystemException("vfs.provider.sftp/change-work-directory.error", object);
                    }
                }
            }
            return channelSftp;
        }
        catch (JSchException jSchException) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", this.getRootName(), (Throwable)jSchException);
        }
    }

    protected void putChannel(ChannelSftp channelSftp) {
        if (this.idleChannel == null) {
            if (channelSftp.isConnected() && !channelSftp.isClosed()) {
                this.idleChannel = channelSftp;
            }
        } else {
            channelSftp.disconnect();
        }
    }

    protected void addCapabilities(Collection collection) {
        collection.addAll(SftpFileProvider.capabilities);
    }

    protected FileObject createFile(FileName fileName) throws FileSystemException {
        return new SftpFileObject(fileName, this);
    }

    public double getLastModTimeAccuracy() {
        return 1000.0;
    }
}

