/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.tar;

import java.io.InputStream;
import java.util.HashSet;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.tar.TarEntry;
import org.apache.commons.vfs.provider.tar.TarFileSystem;

public class TarFileObject
extends AbstractFileObject
implements FileObject {
    private final HashSet children = new HashSet();
    private final TarFileSystem fs;
    protected TarEntry entry;
    private FileType type;

    protected TarFileObject(FileName fileName, TarEntry tarEntry, TarFileSystem tarFileSystem, boolean bl) throws FileSystemException {
        super(fileName, tarFileSystem);
        this.fs = tarFileSystem;
        this.setTarEntry(tarEntry);
        if (!bl) {
            this.type = FileType.IMAGINARY;
        }
    }

    protected void setTarEntry(TarEntry tarEntry) {
        if (this.entry != null) {
            return;
        }
        this.type = tarEntry == null || tarEntry.isDirectory() ? FileType.FOLDER : FileType.FILE;
        this.entry = tarEntry;
    }

    protected void attachChild(FileName fileName) {
        this.children.add(fileName.getBaseName());
    }

    public boolean isWriteable() throws FileSystemException {
        return false;
    }

    protected FileType doGetType() {
        return this.type;
    }

    protected String[] doListChildren() {
        try {
            if (!this.getType().hasChildren()) {
                return null;
            }
        }
        catch (FileSystemException fileSystemException) {
            throw new RuntimeException(fileSystemException);
        }
        return this.children.toArray(new String[this.children.size()]);
    }

    protected long doGetContentSize() {
        if (this.entry == null) {
            return 0L;
        }
        return this.entry.getSize();
    }

    protected long doGetLastModifiedTime() throws Exception {
        if (this.entry == null) {
            return 0L;
        }
        return this.entry.getModTime().getTime();
    }

    protected InputStream doGetInputStream() throws Exception {
        if (!this.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/read-not-file.error", this.getName());
        }
        return this.fs.getInputStream(this.entry);
    }
}

