/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.tar;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs.provider.tar.TarBuffer;
import org.apache.commons.vfs.provider.tar.TarEntry;

class TarInputStream
extends FilterInputStream {
    private TarBuffer buffer;
    private TarEntry currEntry;
    private boolean debug;
    private int entryOffset;
    private int entrySize;
    private boolean hasHitEOF;
    private byte[] oneBuf;
    private byte[] readBuf;

    TarInputStream(InputStream inputStream) {
        this(inputStream, 10240, 512);
    }

    TarInputStream(InputStream inputStream, int n) {
        this(inputStream, n, 512);
    }

    TarInputStream(InputStream inputStream, int n, int n2) {
        super(inputStream);
        this.buffer = new TarBuffer(inputStream, n, n2);
        this.oneBuf = new byte[1];
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
        this.buffer.setDebug(bl);
    }

    public TarEntry getNextEntry() throws IOException {
        byte[] byArray;
        CharSequence charSequence;
        if (this.hasHitEOF) {
            return null;
        }
        if (this.currEntry != null) {
            int n = this.entrySize - this.entryOffset;
            if (this.debug) {
                charSequence = "TarInputStream: SKIP currENTRY '" + this.currEntry.getName() + "' SZ " + this.entrySize + " OFF " + this.entryOffset + "  skipping " + n + " bytes";
                this.debug((String)charSequence);
            }
            if (n > 0) {
                this.skip(n);
            }
            this.readBuf = null;
        }
        if ((byArray = this.buffer.readRecord()) == null) {
            if (this.debug) {
                this.debug("READ NULL RECORD");
            }
            this.hasHitEOF = true;
        } else if (this.buffer.isEOFRecord(byArray)) {
            if (this.debug) {
                this.debug("READ EOF RECORD");
            }
            this.hasHitEOF = true;
        }
        if (this.hasHitEOF) {
            this.currEntry = null;
        } else {
            this.currEntry = new TarEntry(byArray);
            if (byArray[257] != 117 || byArray[258] != 115 || byArray[259] != 116 || byArray[260] != 97 || byArray[261] != 114) {
                // empty if block
            }
            if (this.debug) {
                charSequence = "TarInputStream: SET CURRENTRY '" + this.currEntry.getName() + "' size = " + this.currEntry.getSize();
                this.debug((String)charSequence);
            }
            this.entryOffset = 0;
            this.entrySize = (int)this.currEntry.getSize();
        }
        if (null != this.currEntry && this.currEntry.isGNULongNameEntry()) {
            charSequence = new StringBuffer();
            byte[] byArray2 = new byte[256];
            int n = 0;
            while ((n = this.read(byArray2)) >= 0) {
                String string = new String(byArray2, 0, n);
                ((StringBuffer)charSequence).append(string);
            }
            this.getNextEntry();
            if (((StringBuffer)charSequence).length() > 0 && ((StringBuffer)charSequence).charAt(((StringBuffer)charSequence).length() - 1) == '\u0000') {
                ((StringBuffer)charSequence).deleteCharAt(((StringBuffer)charSequence).length() - 1);
            }
            this.currEntry.setName(((StringBuffer)charSequence).toString());
        }
        return this.currEntry;
    }

    public int getRecordSize() {
        return this.buffer.getRecordSize();
    }

    public int available() throws IOException {
        return this.entrySize - this.entryOffset;
    }

    public void close() throws IOException {
        this.buffer.close();
    }

    public void copyEntryContents(OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[32768];
        while ((n = this.read(byArray, 0, byArray.length)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public void mark(int n) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int n = this.read(this.oneBuf, 0, 1);
        if (n == -1) {
            return n;
        }
        return this.oneBuf[0];
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n;
        int n5 = n2;
        int n6 = 0;
        if (this.entryOffset >= this.entrySize) {
            return -1;
        }
        if (n5 + this.entryOffset > this.entrySize) {
            n5 = this.entrySize - this.entryOffset;
        }
        if (null != this.readBuf) {
            int n7 = n5 > this.readBuf.length ? this.readBuf.length : n5;
            System.arraycopy(this.readBuf, 0, byArray, n4, n7);
            if (n7 >= this.readBuf.length) {
                this.readBuf = null;
            } else {
                n3 = this.readBuf.length - n7;
                byte[] byArray2 = new byte[n3];
                System.arraycopy(this.readBuf, n7, byArray2, 0, n3);
                this.readBuf = byArray2;
            }
            n6 += n7;
            n5 -= n7;
            n4 += n7;
        }
        while (n5 > 0) {
            byte[] byArray3 = this.buffer.readRecord();
            if (null == byArray3) {
                String string = "unexpected EOF with " + n5 + " bytes unread";
                throw new IOException(string);
            }
            int n8 = byArray3.length;
            n3 = n5;
            if (n8 > n3) {
                System.arraycopy(byArray3, 0, byArray, n4, n3);
                this.readBuf = new byte[n8 - n3];
                System.arraycopy(byArray3, n3, this.readBuf, 0, n8 - n3);
            } else {
                n3 = n8;
                System.arraycopy(byArray3, 0, byArray, n4, n8);
            }
            n6 += n3;
            n5 -= n3;
            n4 += n3;
        }
        this.entryOffset += n6;
        return n6;
    }

    public void reset() {
    }

    public void skip(int n) throws IOException {
        int n2;
        int n3;
        byte[] byArray = new byte[8192];
        for (int i = n; i > 0 && (n3 = this.read(byArray, 0, n2 = i > byArray.length ? byArray.length : i)) != -1; i -= n3) {
        }
    }

    protected void debug(String string) {
        if (this.debug) {
            System.err.println(string);
        }
    }
}

