/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.url;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractFileNameParser;
import org.apache.commons.vfs.provider.URLFileName;
import org.apache.commons.vfs.provider.URLFileNameParser;
import org.apache.commons.vfs.provider.VfsComponentContext;
import org.apache.commons.vfs.provider.local.GenericFileNameParser;

public class UrlFileNameParser
extends AbstractFileNameParser {
    private URLFileNameParser url = new URLFileNameParser(80);
    private GenericFileNameParser generic = new GenericFileNameParser();

    public boolean encodeCharacter(char c) {
        return super.encodeCharacter(c) || c == '?';
    }

    public FileName parseUri(VfsComponentContext vfsComponentContext, FileName fileName, String string) throws FileSystemException {
        if (this.isUrlBased(fileName, string)) {
            return this.url.parseUri(vfsComponentContext, fileName, string);
        }
        return this.generic.parseUri(vfsComponentContext, fileName, string);
    }

    protected boolean isUrlBased(FileName fileName, String string) {
        if (fileName instanceof URLFileName) {
            return true;
        }
        int n = this.countSlashes(string);
        return n == 2;
    }

    protected int countSlashes(String string) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (n == 0) {
                if (c >= 'a' && c <= 'z' || c != ':') continue;
                ++n;
                continue;
            }
            if (n != true) continue;
            if (c == '/') {
                ++n2;
                continue;
            }
            return n2;
        }
        return n2;
    }
}

