/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.url;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileProvider;
import org.apache.commons.vfs.provider.res.ResourceFileSystemConfigBuilder;
import org.apache.commons.vfs.provider.url.UrlFileNameParser;
import org.apache.commons.vfs.provider.url.UrlFileSystem;

public class UrlFileProvider
extends AbstractFileProvider {
    protected static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.READ_CONTENT, Capability.URI, Capability.GET_LAST_MODIFIED));

    public UrlFileProvider() {
        this.setFileNameParser(new UrlFileNameParser());
    }

    public synchronized FileObject findFile(FileObject fileObject, String string, FileSystemOptions fileSystemOptions) throws FileSystemException {
        try {
            URL uRL = new URL(string);
            URL uRL2 = new URL(uRL, "/");
            String string2 = this.getClass().getName() + uRL2.toString();
            FileSystem fileSystem = this.findFileSystem((Comparable)((Object)string2), fileSystemOptions);
            if (fileSystem == null) {
                String string3 = uRL2.toExternalForm();
                FileName fileName = this.getContext().parseURI(string3);
                fileSystem = new UrlFileSystem(fileName, fileSystemOptions);
                this.addFileSystem((Comparable)((Object)string2), fileSystem);
            }
            return fileSystem.resolveFile(uRL.getPath());
        }
        catch (MalformedURLException malformedURLException) {
            throw new FileSystemException("vfs.provider.url/badly-formed-uri.error", string, (Throwable)malformedURLException);
        }
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return ResourceFileSystemConfigBuilder.getInstance();
    }

    public Collection getCapabilities() {
        return capabilities;
    }
}

