/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.webdav;

import java.lang.reflect.Constructor;
import org.apache.commons.vfs.FileSystemException;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.client.methods.DavMethod;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ExceptionConverter {
    private ExceptionConverter() {
    }

    public static FileSystemException generate(DavException davException) throws FileSystemException {
        return ExceptionConverter.generate(davException, null);
    }

    public static FileSystemException generate(DavException davException, DavMethod davMethod) throws FileSystemException {
        String string = davException.getMessage();
        if (davException.hasErrorCondition()) {
            try {
                Element element = davException.toXml(DomUtil.BUILDER_FACTORY.newDocumentBuilder().newDocument());
                if (DomUtil.matches((Node)element, (String)"error", (Namespace)DavConstants.NAMESPACE) && DomUtil.hasChildElement((Node)element, (String)"exception", null)) {
                    Class<?> clazz;
                    Constructor<?> constructor;
                    Element element2 = DomUtil.getChildElement((Node)element, (String)"exception", null);
                    if (DomUtil.hasChildElement((Node)element2, (String)"message", null)) {
                        string = DomUtil.getChildText((Element)element2, (String)"message", null);
                    }
                    if (DomUtil.hasChildElement((Node)element2, (String)"class", null) && (constructor = (clazz = Class.forName(DomUtil.getChildText((Element)element2, (String)"class", null))).getConstructor(String.class)) != null) {
                        Object obj = constructor.newInstance(string);
                        if (obj instanceof FileSystemException) {
                            return (FileSystemException)obj;
                        }
                        if (obj instanceof Exception) {
                            return new FileSystemException(string, (Exception)obj);
                        }
                    }
                }
            }
            catch (Exception exception) {
                throw new FileSystemException(exception);
            }
        }
        return new FileSystemException(string);
    }
}

