/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.tasks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.tasks.VfsTask;
import org.apache.commons.vfs.util.Messages;
import org.apache.tools.ant.BuildException;

public abstract class AbstractSyncTask
extends VfsTask {
    private final ArrayList srcFiles = new ArrayList();
    private String destFileUrl;
    private String destDirUrl;
    private String srcDirUrl;
    private boolean srcDirIsBase;
    private boolean failonerror = true;
    private String filesList;

    public void setDestFile(String string) {
        this.destFileUrl = string;
    }

    public void setDestDir(String string) {
        this.destDirUrl = string;
    }

    public void setSrc(String string) {
        SourceInfo sourceInfo = new SourceInfo();
        sourceInfo.setFile(string);
        this.addConfiguredSrc(sourceInfo);
    }

    public void setSrcDir(String string) {
        this.srcDirUrl = string;
    }

    public void setSrcDirIsBase(boolean bl) {
        this.srcDirIsBase = bl;
    }

    public void setFailonerror(boolean bl) {
        this.failonerror = bl;
    }

    public boolean isFailonerror() {
        return this.failonerror;
    }

    public void setIncludes(String string) {
        this.filesList = string;
    }

    public void addConfiguredSrc(SourceInfo sourceInfo) throws BuildException {
        if (sourceInfo.file == null) {
            String string = Messages.getString("vfs.tasks/sync.no-source-file.error");
            throw new BuildException(string);
        }
        this.srcFiles.add(sourceInfo);
    }

    public void execute() throws BuildException {
        Object object;
        if (this.destFileUrl == null && this.destDirUrl == null) {
            String string = Messages.getString("vfs.tasks/sync.no-destination.error");
            this.logOrDie(string, 1);
            return;
        }
        if (this.destFileUrl != null && this.destDirUrl != null) {
            String string = Messages.getString("vfs.tasks/sync.too-many-destinations.error");
            this.logOrDie(string, 1);
            return;
        }
        if (this.srcDirUrl != null && !this.srcDirUrl.equals(this.destDirUrl) && this.filesList != null && this.filesList.length() > 0) {
            if (!this.srcDirUrl.endsWith("/")) {
                this.srcDirUrl = this.srcDirUrl + "/";
            }
            object = new StringTokenizer(this.filesList, ", \t\n\r\f", false);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken();
                if (string.endsWith("/**")) {
                    string = string.substring(0, string.length() - 2);
                }
                SourceInfo sourceInfo = new SourceInfo();
                sourceInfo.setFile(this.srcDirUrl + string);
                this.addConfiguredSrc(sourceInfo);
            }
        }
        if (this.srcFiles.size() == 0) {
            object = Messages.getString("vfs.tasks/sync.no-source-files.warn");
            this.logOrDie((String)object, 1);
            return;
        }
        try {
            if (this.destFileUrl != null) {
                this.handleSingleFile();
            } else {
                this.handleFiles();
            }
        }
        catch (BuildException buildException) {
            throw buildException;
        }
        catch (Exception exception) {
            throw new BuildException(exception.getMessage(), (Throwable)exception);
        }
    }

    protected void logOrDie(String string, int n) {
        if (!this.isFailonerror()) {
            this.log(string, n);
            return;
        }
        throw new BuildException(string);
    }

    private void handleFiles() throws Exception {
        Object object;
        FileObject fileObject;
        FileObject fileObject2 = this.resolveFile(this.destDirUrl);
        fileObject2.createFolder();
        FileName fileName = null;
        if (this.srcDirUrl != null) {
            fileName = this.resolveFile(this.srcDirUrl).getName();
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (int i = 0; i < this.srcFiles.size(); ++i) {
            SourceInfo sourceInfo = (SourceInfo)this.srcFiles.get(i);
            fileObject = this.resolveFile(sourceInfo.file);
            if (!fileObject.exists()) {
                object = Messages.getString("vfs.tasks/sync.src-file-no-exist.warn", fileObject);
                this.logOrDie((String)object, 1);
                continue;
            }
            arrayList.add(fileObject);
        }
        HashSet hashSet = new HashSet();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object2;
            fileObject = (FileObject)arrayList.get(i);
            object = fileObject.getName();
            if (fileObject.getType() == FileType.FILE) {
                object2 = null;
                object2 = fileName == null || !this.srcDirIsBase ? object.getBaseName() : fileName.getRelativeName((FileName)object);
                FileObject fileObject3 = fileObject2.resolveFile((String)object2, NameScope.DESCENDENT);
                this.handleFile(hashSet, fileObject, fileObject3);
                continue;
            }
            object2 = fileObject.findFiles(this.srcDirIsBase ? Selectors.SELECT_ALL : Selectors.SELECT_FILES);
            for (int j = 0; j < ((FileObject[])object2).length; ++j) {
                FileObject fileObject4 = object2[j];
                String string = null;
                string = fileName == null || !this.srcDirIsBase ? object.getRelativeName(fileObject4.getName()) : fileName.getRelativeName(fileObject4.getName());
                FileObject fileObject5 = fileObject2.resolveFile(string, NameScope.DESCENDENT);
                this.handleFile(hashSet, fileObject4, fileObject5);
            }
        }
        if (this.detectMissingSourceFiles()) {
            FileObject[] fileObjectArray = fileObject2.findFiles(Selectors.SELECT_FILES);
            for (int i = 0; i < fileObjectArray.length; ++i) {
                object = fileObjectArray[i];
                if (hashSet.contains(object)) continue;
                this.handleMissingSourceFile((FileObject)object);
            }
        }
    }

    private void handleFile(Set set, FileObject fileObject, FileObject fileObject2) throws Exception {
        if (set.contains(fileObject2)) {
            String string = Messages.getString("vfs.tasks/sync.duplicate-source-files.warn", fileObject2);
            this.logOrDie(string, 1);
        } else {
            set.add(fileObject2);
        }
        this.handleFile(fileObject, fileObject2);
    }

    private void handleSingleFile() throws Exception {
        if (this.srcFiles.size() > 1) {
            String string = Messages.getString("vfs.tasks/sync.too-many-source-files.error");
            this.logOrDie(string, 1);
            return;
        }
        SourceInfo sourceInfo = (SourceInfo)this.srcFiles.get(0);
        FileObject fileObject = this.resolveFile(sourceInfo.file);
        if (fileObject.getType() != FileType.FILE) {
            String string = Messages.getString("vfs.tasks/sync.source-not-file.error", fileObject);
            this.logOrDie(string, 1);
            return;
        }
        FileObject fileObject2 = this.resolveFile(this.destFileUrl);
        this.handleFile(fileObject, fileObject2);
    }

    private void handleFile(FileObject fileObject, FileObject fileObject2) throws Exception {
        if (!fileObject2.exists() || fileObject.getContent().getLastModifiedTime() > fileObject2.getContent().getLastModifiedTime()) {
            this.handleOutOfDateFile(fileObject, fileObject2);
        } else {
            this.handleUpToDateFile(fileObject, fileObject2);
        }
    }

    protected void handleOutOfDateFile(FileObject fileObject, FileObject fileObject2) throws Exception {
    }

    protected void handleUpToDateFile(FileObject fileObject, FileObject fileObject2) throws Exception {
    }

    protected void handleMissingSourceFile(FileObject fileObject) throws Exception {
    }

    protected boolean detectMissingSourceFiles() {
        return false;
    }

    public static class SourceInfo {
        private String file;

        public void setFile(String string) {
            this.file = string;
        }
    }
}

