/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.tasks;

import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.tasks.CopyTask;

public class MoveTask
extends CopyTask {
    private boolean tryRename = false;

    public void setTryRename(boolean bl) {
        this.tryRename = bl;
    }

    protected void handleOutOfDateFile(FileObject fileObject, FileObject fileObject2) throws FileSystemException {
        if (!this.tryRename || !fileObject.canRenameTo(fileObject2)) {
            super.handleOutOfDateFile(fileObject, fileObject2);
            this.log("Deleting " + fileObject);
            fileObject.delete(Selectors.SELECT_SELF);
        } else {
            this.log("Rename " + fileObject + " to " + fileObject2);
            fileObject.moveTo(fileObject2);
            if (!this.isPreserveLastModified() && fileObject2.getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FILE)) {
                fileObject2.getContent().setLastModifiedTime(System.currentTimeMillis());
            }
        }
    }
}

