/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.util;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.vfs.util.Cryptor;

public class DefaultCryptor
implements Cryptor {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final byte[] KEY_BYTES = new byte[]{65, 112, 97, 99, 104, 101, 67, 111, 109, 109, 111, 110, 115, 86, 70, 83};
    private static final int INDEX_NOT_FOUND = -1;
    private static final int BITS_IN_HALF_BYTE = 4;
    private static final char MASK = '\u000f';

    public String encrypt(String string) throws Exception {
        byte[] byArray = string.getBytes();
        SecretKeySpec secretKeySpec = new SecretKeySpec(KEY_BYTES, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, secretKeySpec);
        byte[] byArray2 = new byte[cipher.getOutputSize(byArray.length)];
        int n = cipher.update(byArray, 0, byArray.length, byArray2, 0);
        n += cipher.doFinal(byArray2, n);
        return this.encode(byArray2);
    }

    public String decrypt(String string) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(KEY_BYTES, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, secretKeySpec);
        byte[] byArray = this.decode(string);
        byte[] byArray2 = new byte[cipher.getOutputSize(byArray.length)];
        int n = cipher.update(byArray, 0, byArray.length, byArray2, 0);
        n += cipher.doFinal(byArray2, n);
        return new String(byArray2).substring(0, n);
    }

    private String encode(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(HEX_CHARS[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(HEX_CHARS[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    private byte[] decode(String string) {
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        char[] cArray = string.toCharArray();
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            int n3;
            int n4 = this.indexOf(HEX_CHARS, cArray[i]);
            if (n4 == -1) {
                throw new IllegalArgumentException("Character " + cArray[i] + " at position " + i + " is not a valid hexidecimal character");
            }
            if ((n3 = this.indexOf(HEX_CHARS, cArray[++i])) == -1) {
                throw new IllegalArgumentException("Character " + cArray[i] + " at position " + i + " is not a valid hexidecimal character");
            }
            byArray[n2++] = (byte)(n4 << 4 | n3);
        }
        return byArray;
    }

    private int indexOf(char[] cArray, char c) {
        if (cArray == null) {
            return -1;
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (c != cArray[i]) continue;
            return i;
        }
        return -1;
    }
}

