/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.boot;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.boot.AbstractBoot;
import org.pentaho.reporting.libraries.base.boot.DefaultModuleInfo;
import org.pentaho.reporting.libraries.base.boot.Module;
import org.pentaho.reporting.libraries.base.boot.ModuleInfo;
import org.pentaho.reporting.libraries.base.boot.PackageSorter;
import org.pentaho.reporting.libraries.base.boot.PackageState;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.PropertyFileConfiguration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.PadMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PackageManager {
    private static final Log LOGGER = LogFactory.getLog(PackageManager.class);
    private static final int RETURN_MODULE_LOADED = 0;
    private static final int RETURN_MODULE_UNKNOWN = 1;
    private static final int RETURN_MODULE_ERROR = 2;
    private final PackageConfiguration packageConfiguration;
    private final ArrayList<PackageState> modules;
    private HashMap<String, PackageState> modulesByClass;
    private final ArrayList<String> initSections;
    private AbstractBoot booter;

    public PackageManager(AbstractBoot booter) {
        if (booter == null) {
            throw new NullPointerException();
        }
        this.booter = booter;
        this.packageConfiguration = new PackageConfiguration();
        this.modules = new ArrayList();
        this.modulesByClass = new HashMap();
        this.initSections = new ArrayList();
    }

    public boolean isModuleAvailable(ModuleInfo moduleDescription) {
        if (moduleDescription == null) {
            throw new NullPointerException();
        }
        PackageState[] packageStates = this.modules.toArray(new PackageState[this.modules.size()]);
        for (int i = 0; i < packageStates.length; ++i) {
            PackageState state = packageStates[i];
            if (!state.getModule().getModuleClass().equals(moduleDescription.getModuleClass())) continue;
            return state.getState() == 2;
        }
        return false;
    }

    public boolean isModuleAvailable(String moduleClass) {
        if (moduleClass == null) {
            throw new NullPointerException();
        }
        PackageState state = this.modulesByClass.get(moduleClass);
        if (state == null) {
            return false;
        }
        return state.getState() == 2;
    }

    public void load(String modulePrefix) {
        if (modulePrefix == null) {
            throw new NullPointerException();
        }
        if (this.initSections.contains(modulePrefix)) {
            return;
        }
        this.initSections.add(modulePrefix);
        Configuration config = this.booter.getGlobalConfig();
        Iterator it = config.findPropertyKeys(modulePrefix);
        int count = 0;
        while (it.hasNext()) {
            String moduleClass;
            String key = (String)it.next();
            if (!key.endsWith(".Module") || (moduleClass = config.getConfigProperty(key)) == null || moduleClass.length() <= 0) continue;
            this.addModule(moduleClass);
            ++count;
        }
        LOGGER.debug((Object)("Loaded a total of " + count + " modules under prefix: " + modulePrefix));
    }

    public synchronized void initializeModules() {
        PackageState mod;
        int i;
        PackageSorter.sort(this.modules);
        for (i = 0; i < this.modules.size(); ++i) {
            mod = this.modules.get(i);
            if (!this.isConfigurable(mod)) {
                mod.markError();
                continue;
            }
            if (!mod.configure(this.booter) || !LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("Conf: " + new PadMessage(mod.getModule().getModuleClass(), 70) + " [" + mod.getModule().getSubSystem() + ']'));
        }
        for (i = 0; i < this.modules.size(); ++i) {
            mod = this.modules.get(i);
            if (!this.isInitializable(mod)) {
                mod.markError();
                continue;
            }
            if (!mod.initialize(this.booter) || !LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("Init: " + new PadMessage(mod.getModule().getModuleClass(), 70) + " [" + mod.getModule().getSubSystem() + ']'));
        }
    }

    private boolean isConfigurable(PackageState state) {
        ModuleInfo[] requiredModules = state.getModule().getRequiredModules();
        for (int i = 0; i < requiredModules.length; ++i) {
            ModuleInfo module = requiredModules[i];
            String key = module.getModuleClass();
            PackageState dependentState = this.modulesByClass.get(key);
            if (dependentState == null) {
                LOGGER.warn((Object)("Required dependency '" + key + "' for module '" + state.getModule().getModuleClass() + " not found."));
                return false;
            }
            if (dependentState.getState() == 1) continue;
            LOGGER.warn((Object)("Required dependency '" + key + "' for module '" + state.getModule().getModuleClass() + " not configured."));
            return false;
        }
        return true;
    }

    private boolean isInitializable(PackageState state) {
        ModuleInfo[] requiredModules = state.getModule().getRequiredModules();
        for (int i = 0; i < requiredModules.length; ++i) {
            ModuleInfo module = requiredModules[i];
            String key = module.getModuleClass();
            PackageState dependentState = this.modulesByClass.get(key);
            if (dependentState == null) {
                LOGGER.warn((Object)("Required dependency '" + key + "' for module '" + state.getModule().getModuleClass() + " not found."));
                return false;
            }
            if (dependentState.getState() == 2) continue;
            LOGGER.warn((Object)("Required dependency '" + key + "' for module '" + state.getModule().getModuleClass() + " not initializable."));
            return false;
        }
        return true;
    }

    public synchronized void addModule(String modClass) {
        if (modClass == null) {
            throw new NullPointerException();
        }
        DefaultModuleInfo modInfo = new DefaultModuleInfo(modClass, null, null, null);
        ArrayList<Module> loadModules = new ArrayList<Module>();
        if (this.loadModule(modInfo, new ArrayList<Module>(), loadModules, false)) {
            for (int i = 0; i < loadModules.size(); ++i) {
                Module mod = loadModules.get(i);
                PackageState state = new PackageState(mod);
                this.modules.add(state);
                this.modulesByClass.put(mod.getModuleClass(), state);
            }
        }
    }

    private int containsModule(ArrayList<Module> tempModules, ModuleInfo module) {
        int i;
        if (tempModules != null) {
            ModuleInfo[] mods = tempModules.toArray(new ModuleInfo[tempModules.size()]);
            for (i = 0; i < mods.length; ++i) {
                if (!mods[i].getModuleClass().equals(module.getModuleClass())) continue;
                return 0;
            }
        }
        PackageState[] packageStates = this.modules.toArray(new PackageState[this.modules.size()]);
        for (i = 0; i < packageStates.length; ++i) {
            if (!packageStates[i].getModule().getModuleClass().equals(module.getModuleClass())) continue;
            if (packageStates[i].getState() == -2) {
                return 2;
            }
            return 0;
        }
        return 1;
    }

    private void dropFailedModule(PackageState state) {
        if (!this.modules.contains(state)) {
            this.modules.add(state);
        }
    }

    private boolean loadModule(ModuleInfo moduleInfo, ArrayList<Module> incompleteModules, ArrayList<Module> modules, boolean fatal) {
        try {
            Module module = (Module)ObjectUtilities.loadAndInstantiate(moduleInfo.getModuleClass(), this.booter.getClass(), Module.class);
            if (module == null) {
                if (fatal) {
                    LOGGER.warn((Object)("Unresolved dependency for package: " + moduleInfo.getModuleClass()));
                }
                LOGGER.debug((Object)("Module class referenced, but not in classpath: " + moduleInfo.getModuleClass()));
                return false;
            }
            if (!this.acceptVersion(moduleInfo, module)) {
                LOGGER.warn((Object)("Module " + module.getName() + ": required version: " + moduleInfo + ", but found Version: \n" + module));
                PackageState state = new PackageState(module, -2);
                this.dropFailedModule(state);
                return false;
            }
            int moduleContained = this.containsModule(modules, module);
            if (moduleContained == 2) {
                LOGGER.debug((Object)("Indicated failure for module: " + module.getModuleClass()));
                PackageState state = new PackageState(module, -2);
                this.dropFailedModule(state);
                return false;
            }
            if (moduleContained == 1) {
                if (incompleteModules.contains(module)) {
                    LOGGER.error((Object)("Circular module reference: This module definition is invalid: " + module.getClass()));
                    PackageState state = new PackageState(module, -2);
                    this.dropFailedModule(state);
                    return false;
                }
                incompleteModules.add(module);
                ModuleInfo[] required = module.getRequiredModules();
                for (int i = 0; i < required.length; ++i) {
                    if (this.loadModule(required[i], incompleteModules, modules, true)) continue;
                    LOGGER.debug((Object)("Indicated failure for module: " + module.getModuleClass()));
                    PackageState state = new PackageState(module, -2);
                    this.dropFailedModule(state);
                    return false;
                }
                ModuleInfo[] optional = module.getOptionalModules();
                for (int i = 0; i < optional.length; ++i) {
                    if (this.loadModule(optional[i], incompleteModules, modules, true)) continue;
                    LOGGER.debug((Object)("Optional module: " + optional[i].getModuleClass() + " was not loaded."));
                }
                if (this.containsModule(modules, module) == 1) {
                    modules.add(module);
                }
                incompleteModules.remove(module);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Exception while loading module: " + moduleInfo), (Throwable)e);
            return false;
        }
    }

    private boolean acceptVersion(ModuleInfo moduleRequirement, Module module) {
        int compare;
        if (moduleRequirement.getMajorVersion() == null) {
            return true;
        }
        if (module.getMajorVersion() == null) {
            LOGGER.warn((Object)("Module " + module.getName() + " does not define a major version."));
        } else {
            compare = this.acceptVersion(moduleRequirement.getMajorVersion(), module.getMajorVersion());
            if (compare > 0) {
                return false;
            }
            if (compare < 0) {
                return true;
            }
        }
        if (moduleRequirement.getMinorVersion() == null) {
            return true;
        }
        if (module.getMinorVersion() == null) {
            LOGGER.warn((Object)("Module " + module.getName() + " does not define a minor version."));
        } else {
            compare = this.acceptVersion(moduleRequirement.getMinorVersion(), module.getMinorVersion());
            if (compare > 0) {
                return false;
            }
            if (compare < 0) {
                return true;
            }
        }
        if (moduleRequirement.getPatchLevel() == null) {
            return true;
        }
        if (module.getPatchLevel() == null) {
            LOGGER.debug((Object)("Module " + module.getName() + " does not define a patch level."));
        } else if (this.acceptVersion(moduleRequirement.getPatchLevel(), module.getPatchLevel()) > 0) {
            LOGGER.debug((Object)("Did not accept patchlevel: " + moduleRequirement.getPatchLevel() + " - " + module.getPatchLevel()));
            return false;
        }
        return true;
    }

    private int acceptVersion(String modVer, String depModVer) {
        char[] depVerArray;
        char[] modVerArray;
        int mLength = Math.max(modVer.length(), depModVer.length());
        if (modVer.length() > depModVer.length()) {
            modVerArray = modVer.toCharArray();
            depVerArray = new char[mLength];
            int delta = modVer.length() - depModVer.length();
            Arrays.fill(depVerArray, 0, delta, ' ');
            System.arraycopy(depVerArray, delta, depModVer.toCharArray(), 0, depModVer.length());
        } else if (modVer.length() < depModVer.length()) {
            depVerArray = depModVer.toCharArray();
            modVerArray = new char[mLength];
            char[] b1 = new char[mLength];
            int delta = depModVer.length() - modVer.length();
            Arrays.fill(b1, 0, delta, ' ');
            System.arraycopy(b1, delta, modVer.toCharArray(), 0, modVer.length());
        } else {
            depVerArray = depModVer.toCharArray();
            modVerArray = modVer.toCharArray();
        }
        return new String(modVerArray).compareTo(new String(depVerArray));
    }

    public PackageConfiguration getPackageConfiguration() {
        return this.packageConfiguration;
    }

    public Module[] getAllModules() {
        Module[] mods = new Module[this.modules.size()];
        for (int i = 0; i < this.modules.size(); ++i) {
            PackageState state = this.modules.get(i);
            mods[i] = state.getModule();
        }
        return mods;
    }

    public Module[] getActiveModules() {
        ArrayList<Module> mods = new ArrayList<Module>();
        for (int i = 0; i < this.modules.size(); ++i) {
            PackageState state = this.modules.get(i);
            if (state.getState() != 2) continue;
            mods.add(state.getModule());
        }
        return mods.toArray(new Module[mods.size()]);
    }

    public void printUsedModules(PrintStream p) {
        int i;
        Module[] allMods = this.getAllModules();
        ArrayList<Module> activeModules = new ArrayList<Module>();
        for (i = 0; i < allMods.length; ++i) {
            if (!this.isModuleAvailable(allMods[i])) continue;
            activeModules.add(allMods[i]);
        }
        p.print("Active modules: ");
        p.println(activeModules.size());
        p.println("----------------------------------------------------------");
        for (i = 0; i < activeModules.size(); ++i) {
            Module mod = (Module)activeModules.get(i);
            p.print(new PadMessage(mod.getModuleClass(), 70));
            p.print(" [");
            p.print(mod.getSubSystem());
            p.println("]");
            p.print("  Version: ");
            p.print(mod.getMajorVersion());
            p.print("-");
            p.print(mod.getMinorVersion());
            p.print("-");
            p.print(mod.getPatchLevel());
            p.print(" Producer: ");
            p.println(mod.getProducer());
            p.print("  Description: ");
            p.println(mod.getDescription());
        }
    }

    public static class PackageConfiguration
    extends PropertyFileConfiguration {
        private static final long serialVersionUID = -2170306139946858878L;
    }
}

