/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.PrintStream;
import java.io.PrintWriter;

public class StackableRuntimeException
extends RuntimeException {
    private Throwable parent;
    private static final long serialVersionUID = -4378774171699885841L;

    public StackableRuntimeException() {
    }

    public StackableRuntimeException(String message, Throwable ex) {
        super(message);
        this.parent = ex;
    }

    public StackableRuntimeException(String message, Exception ex) {
        super(message);
        this.parent = ex;
    }

    public StackableRuntimeException(String message) {
        super(message);
    }

    public Exception getParent() {
        if (this.parent instanceof Exception) {
            return (Exception)this.parent;
        }
        return null;
    }

    public Throwable getParentThrowable() {
        return this.parent;
    }

    public void printStackTrace(PrintStream stream) {
        super.printStackTrace(stream);
        if (this.getParentThrowable() != null) {
            stream.println("ParentException: ");
            this.getParentThrowable().printStackTrace(stream);
        }
    }

    public void printStackTrace(PrintWriter writer) {
        super.printStackTrace(writer);
        if (this.getParentThrowable() != null) {
            writer.println("ParentException: ");
            this.getParentThrowable().printStackTrace(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            this.printStackTrace(System.err);
        }
    }
}

