/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.JndiUtil;
import org.pentaho.di.core.KettleVariablesList;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.lifecycle.KettleLifecycleSupport;
import org.pentaho.di.core.logging.CentralLogStore;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.plugins.DatabasePluginType;
import org.pentaho.di.core.plugins.ImportRulePluginType;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.KettleLifecyclePluginType;
import org.pentaho.di.core.plugins.LifecyclePluginType;
import org.pentaho.di.core.plugins.PartitionerPluginType;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.i18n.BaseMessages;

public class KettleEnvironment {
    private static Class<?> PKG = Const.class;
    private static Boolean initialized;

    public static void init() throws KettleException {
        KettleEnvironment.init(true);
    }

    public static void init(boolean simpleJndi) throws KettleException {
        if (initialized == null) {
            KettleEnvironment.createKettleHome();
            EnvUtil.environmentInit();
            CentralLogStore.init();
            LogWriter.setConsoleAppenderDebug();
            if (simpleJndi) {
                JndiUtil.initJNDI();
            }
            PluginRegistry.addPluginType((PluginTypeInterface)StepPluginType.getInstance());
            PluginRegistry.addPluginType((PluginTypeInterface)PartitionerPluginType.getInstance());
            PluginRegistry.addPluginType((PluginTypeInterface)JobEntryPluginType.getInstance());
            PluginRegistry.addPluginType((PluginTypeInterface)RepositoryPluginType.getInstance());
            PluginRegistry.addPluginType((PluginTypeInterface)DatabasePluginType.getInstance());
            PluginRegistry.addPluginType((PluginTypeInterface)LifecyclePluginType.getInstance());
            PluginRegistry.addPluginType((PluginTypeInterface)KettleLifecyclePluginType.getInstance());
            PluginRegistry.addPluginType((PluginTypeInterface)ImportRulePluginType.getInstance());
            PluginRegistry.init();
            KettleVariablesList.init();
            KettleEnvironment.initLifecycleListeners();
            initialized = true;
        }
    }

    private static void initLifecycleListeners() throws KettleException {
        final KettleLifecycleSupport s = new KettleLifecycleSupport();
        s.onEnvironmentInit();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    s.onEnvironmentShutdown();
                }
                catch (Throwable t) {
                    System.err.println(BaseMessages.getString((Class)PKG, (String)"LifecycleSupport.ErrorInvokingKettleEnvironmentShutdownListeners", (String[])new String[0]));
                    t.printStackTrace();
                }
            }
        });
    }

    public static void createKettleHome() {
        String directory = Const.getKettleDirectory();
        File dir = new File(directory);
        try {
            dir.mkdirs();
            KettleEnvironment.createDefaultKettleProperties(directory);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void createDefaultKettleProperties(String directory) {
        String kpFile = directory + Const.FILE_SEPARATOR + "kettle.properties";
        File file = new File(kpFile);
        if (file.exists()) return;
        FileOutputStream out = null;
        out = new FileOutputStream(file);
        out.write(Const.getKettlePropertiesFileHeader().getBytes());
        Object var6_4 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (IOException e2) {
            System.err.println(BaseMessages.getString(PKG, (String)"Props.Log.Error.UnableToCreateDefaultKettleProperties.Message", (String[])new String[]{"kettle.properties", kpFile}));
            System.err.println(e2.getStackTrace());
        }
        return;
        {
            catch (IOException e) {
                System.err.println(BaseMessages.getString(PKG, (String)"Props.Log.Error.UnableToCreateDefaultKettleProperties.Message", (String[])new String[]{"kettle.properties", kpFile}));
                System.err.println(e.getStackTrace());
                Object var6_5 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException e2) {
                    System.err.println(BaseMessages.getString(PKG, (String)"Props.Log.Error.UnableToCreateDefaultKettleProperties.Message", (String[])new String[]{"kettle.properties", kpFile}));
                    System.err.println(e2.getStackTrace());
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e2) {
                System.err.println(BaseMessages.getString(PKG, (String)"Props.Log.Error.UnableToCreateDefaultKettleProperties.Message", (String[])new String[]{"kettle.properties", kpFile}));
                System.err.println(e2.getStackTrace());
            }
            throw throwable;
        }
    }

    public static boolean isInitialized() {
        return initialized != null;
    }

    public void loadPluginRegistry() throws KettlePluginException {
    }
}

