/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.gui;

import java.util.LinkedList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.job.JobEntryResult;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobTracker {
    private List<JobTracker> jobTrackers;
    private JobEntryResult result;
    private JobTracker parentJobTracker;
    private String jobName;
    private String jobFilename;
    private int maxChildren;

    public JobTracker(JobMeta jobMeta) {
        if (jobMeta != null) {
            this.jobName = jobMeta.getName();
            this.jobFilename = jobMeta.getFilename();
        }
        this.jobTrackers = new LinkedList<JobTracker>();
        this.maxChildren = Const.toInt((String)EnvUtil.getSystemProperty((String)"KETTLE_MAX_JOB_TRACKER_SIZE"), (int)5000);
    }

    public JobTracker(JobMeta jobMeta, int maxChildren) {
        if (jobMeta != null) {
            this.jobName = jobMeta.getName();
            this.jobFilename = jobMeta.getFilename();
        }
        this.jobTrackers = new LinkedList<JobTracker>();
        this.maxChildren = maxChildren;
    }

    public JobTracker(JobMeta jobMeta, JobEntryResult result) {
        this(jobMeta);
        this.result = result;
    }

    public JobTracker(JobMeta jobMeta, int maxChildren, JobEntryResult result) {
        this(jobMeta, maxChildren);
        this.result = result;
    }

    public void addJobTracker(JobTracker jobTracker) {
        this.jobTrackers.add(jobTracker);
        if (this.jobTrackers.size() > this.maxChildren + 50) {
            this.jobTrackers = this.jobTrackers.subList(50, this.jobTrackers.size());
        }
    }

    public JobTracker getJobTracker(int i) {
        return this.jobTrackers.get(i);
    }

    public int nrJobTrackers() {
        return this.jobTrackers.size();
    }

    public List<JobTracker> getJobTrackers() {
        return this.jobTrackers;
    }

    public void setJobTrackers(List<JobTracker> jobTrackers) {
        this.jobTrackers = jobTrackers;
    }

    public JobEntryResult getJobEntryResult() {
        return this.result;
    }

    public void setJobEntryResult(JobEntryResult result) {
        this.result = result;
    }

    public void clear() {
        this.jobTrackers.clear();
        this.result = null;
    }

    public JobTracker findJobTracker(JobEntryCopy jobEntryCopy) {
        for (int i = this.jobTrackers.size() - 1; i >= 0; --i) {
            JobTracker tracker = this.getJobTracker(i);
            JobEntryResult result = tracker.getJobEntryResult();
            if (result == null || jobEntryCopy.getName() == null || !jobEntryCopy.getName().equals(result.getJobEntryName()) || jobEntryCopy.getNr() != result.getJobEntryNr()) continue;
            return tracker;
        }
        return null;
    }

    public JobTracker getParentJobTracker() {
        return this.parentJobTracker;
    }

    public void setParentJobTracker(JobTracker parentJobTracker) {
        this.parentJobTracker = parentJobTracker;
    }

    public int getTotalNumberOfItems() {
        int total = 1;
        for (int i = 0; i < this.nrJobTrackers(); ++i) {
            total += this.getJobTracker(i).getTotalNumberOfItems();
        }
        return total;
    }

    public String getJobFilename() {
        return this.jobFilename;
    }

    public void setJobFilename(String jobFilename) {
        this.jobFilename = jobFilename;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public void setMaxChildren(int maxChildren) {
        this.maxChildren = maxChildren;
    }
}

