/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.lifecycle;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.pentaho.di.core.lifecycle.LifeEventHandler;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.lifecycle.LifecycleListener;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.plugins.LifecyclePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleSupport {
    private Set<LifecycleListener> lifeListeners = LifecycleSupport.loadPlugins(LifecyclePluginType.class, LifecycleListener.class);

    static <T> Set<T> loadPlugins(Class<? extends PluginTypeInterface> pluginType, Class<T> mainPluginClass) {
        HashSet<Object> pluginInstances = new HashSet<Object>();
        PluginRegistry registry = PluginRegistry.getInstance();
        List plugins = registry.getPlugins(pluginType);
        for (PluginInterface plugin : plugins) {
            try {
                pluginInstances.add(registry.loadClass(plugin, mainPluginClass));
            }
            catch (Throwable e) {
                LogChannel.GENERAL.logError("Unexpected error loading class for plugin " + plugin.getName(), e);
            }
        }
        return pluginInstances;
    }

    public void onStart(LifeEventHandler handler) throws LifecycleException {
        for (LifecycleListener listener : this.lifeListeners) {
            listener.onStart(handler);
        }
    }

    public void onExit(LifeEventHandler handler) throws LifecycleException {
        for (LifecycleListener listener : this.lifeListeners) {
            listener.onExit(handler);
        }
    }
}

