/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.plugins.BasePluginType;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginFolderInterface;
import org.pentaho.di.core.plugins.PluginMainClassType;
import org.pentaho.di.core.plugins.PluginTypeCategoriesOrder;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PluginTypeCategoriesOrder(getNaturalCategoriesOrder={"BaseStep.Category.Input", "BaseStep.Category.Output", "BaseStep.Category.Transform", "BaseStep.Category.Utility", "BaseStep.Category.Flow", "BaseStep.Category.Scripting", "BaseStep.Category.Lookup", "BaseStep.Category.Joins", "BaseStep.Category.DataWarehouse", "BaseStep.Category.Validation", "BaseStep.Category.Statistics", "BaseStep.Category.BigData", "BaseStep.Category.Agile", "BaseStep.Category.DataQuality", "BaseStep.Category.Cryptography", "BaseStep.Category.Palo", "BaseStep.Category.OpenERP", "BaseStep.Category.Job", "BaseStep.Category.Mapping", "BaseStep.Category.Bulk", "BaseStep.Category.Inline", "BaseStep.Category.Experimental", "BaseStep.Category.Deprecated"}, i18nPackageClass=StepInterface.class)
@PluginMainClassType(value=StepMetaInterface.class)
@PluginAnnotationType(value=Step.class)
public class StepPluginType
extends BasePluginType
implements PluginTypeInterface {
    private static StepPluginType stepPluginType;

    private StepPluginType() {
        super(Step.class, "STEP", "Step");
        this.populateFolders("steps");
    }

    public static StepPluginType getInstance() {
        if (stepPluginType == null) {
            stepPluginType = new StepPluginType();
        }
        return stepPluginType;
    }

    protected void registerNatives() throws KettlePluginException {
        String kettleStepsXmlFile = "kettle-steps.xml";
        String alternative = System.getProperty("KETTLE_CORE_STEPS_FILE", null);
        if (!Const.isEmpty((String)alternative)) {
            kettleStepsXmlFile = alternative;
        }
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(kettleStepsXmlFile);
            if (inputStream == null) {
                inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + kettleStepsXmlFile);
            }
            if (inputStream == null && !Const.isEmpty((String)alternative)) {
                try {
                    inputStream = new FileInputStream(kettleStepsXmlFile);
                }
                catch (Exception e) {
                    throw new KettlePluginException("Unable to load native step plugins '" + kettleStepsXmlFile + "'", (Throwable)e);
                }
            }
            if (inputStream == null) {
                throw new KettlePluginException("Unable to find native step definition file: kettle-steps.xml");
            }
            Document document = XMLHandler.loadXMLFile((InputStream)inputStream, null, (boolean)true, (boolean)false);
            Node stepsNode = XMLHandler.getSubNode((Node)document, (String)"steps");
            List stepNodes = XMLHandler.getNodes((Node)stepsNode, (String)"step");
            for (Node stepNode : stepNodes) {
                this.registerPluginFromXmlResource(stepNode, null, ((Object)((Object)this)).getClass(), true, null);
            }
        }
        catch (KettleXMLException e) {
            throw new KettlePluginException("Unable to read the kettle steps XML config file: " + kettleStepsXmlFile, (Throwable)e);
        }
    }

    protected void registerXmlPlugins() throws KettlePluginException {
        for (PluginFolderInterface folder : this.pluginFolders) {
            if (!folder.isPluginXmlFolder()) continue;
            List pluginXmlFiles = this.findPluginXmlFiles(folder.getFolder());
            for (FileObject file : pluginXmlFiles) {
                try {
                    Document document = XMLHandler.loadXMLFile((FileObject)file);
                    Node pluginNode = XMLHandler.getSubNode((Node)document, (String)"plugin");
                    if (pluginNode == null) continue;
                    this.registerPluginFromXmlResource(pluginNode, KettleVFS.getFilename((FileObject)file.getParent()), ((Object)((Object)this)).getClass(), false, file.getParent().getURL());
                }
                catch (Exception e) {
                    this.log.logError("Error found while reading step plugin.xml file: " + file.getName().toString(), (Throwable)e);
                }
            }
        }
    }

    protected String extractCategory(Annotation annotation) {
        return ((Step)annotation).categoryDescription();
    }

    protected String extractDesc(Annotation annotation) {
        return ((Step)annotation).description();
    }

    protected String extractID(Annotation annotation) {
        return ((Step)annotation).id();
    }

    protected String extractName(Annotation annotation) {
        return ((Step)annotation).name();
    }

    protected String extractImageFile(Annotation annotation) {
        return ((Step)annotation).image();
    }

    protected boolean extractSeparateClassLoader(Annotation annotation) {
        return ((Step)annotation).isSeparateClassLoaderNeeded();
    }

    protected String extractI18nPackageName(Annotation annotation) {
        return ((Step)annotation).i18nPackageName();
    }

    protected void addExtraClasses(Map<Class<?>, String> classMap, Class<?> clazz, Annotation annotation) {
    }
}

