/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionPredicates {
    private static final String TO_STRING_PREFIX = CollectionPredicates.class.getName() + ".";
    public static final Predicate EMPTY_COLLECTION = new Predicate(){

        public boolean evaluate(Object object) {
            return ((Collection)object).isEmpty();
        }

        public String toString() {
            return TO_STRING_PREFIX + "EMPTY_COLLECTION";
        }
    };
    public static final Predicate NOT_EMPTY_COLLECTION = new Predicate(){

        public boolean evaluate(Object object) {
            return !EMPTY_COLLECTION.evaluate(object);
        }

        public String toString() {
            return TO_STRING_PREFIX + "NOT_EMPTY_COLLECTION";
        }
    };
    public static final Predicate EMPTY_ARRAY = new Predicate(){

        public boolean evaluate(Object object) {
            return ((Object[])object).length == 0;
        }

        public String toString() {
            return TO_STRING_PREFIX + "EMPTY_ARRAY";
        }
    };
    public static final Predicate NOT_EMPTY_ARRAY = new Predicate(){

        public boolean evaluate(Object object) {
            return !EMPTY_ARRAY.evaluate(object);
        }

        public String toString() {
            return TO_STRING_PREFIX + "NOT_EMPTY_ARRAY";
        }
    };
    public static final Predicate EMPTY_MAP = new Predicate(){

        public boolean evaluate(Object object) {
            return ((Map)object).isEmpty();
        }

        public String toString() {
            return TO_STRING_PREFIX + "EMPTY_MAP";
        }
    };
    public static final Predicate NOT_EMPTY_MAP = new Predicate(){

        public boolean evaluate(Object object) {
            return !EMPTY_MAP.evaluate(object);
        }

        public String toString() {
            return TO_STRING_PREFIX + "NOT_EMPTY_MAP";
        }
    };
    public static final Predicate NOT_NULL_OR_EMPTY_COLLECTION = new Predicate(){

        public boolean evaluate(Object object) {
            return object != null && !EMPTY_COLLECTION.evaluate(object);
        }

        public String toString() {
            return TO_STRING_PREFIX + "NOT_NULL_OR_EMPTY_COLLECTION";
        }
    };
    public static final Predicate NOT_NULL_OR_EMPTY_ARRAY = new Predicate(){

        public boolean evaluate(Object object) {
            return object != null && !EMPTY_ARRAY.evaluate(object);
        }

        public String toString() {
            return TO_STRING_PREFIX + "NOT_NULL_OR_EMPTY_ARRAY";
        }
    };
    public static final Predicate NOT_NULL_OR_EMPTY_MAP = new Predicate(){

        public boolean evaluate(Object object) {
            return object != null && !EMPTY_MAP.evaluate(object);
        }

        public String toString() {
            return TO_STRING_PREFIX + "NOT_NULL_OR_EMPTY_MAP";
        }
    };
    public static final Predicate NULL_OR_EMPTY_COLLECTION = new Predicate(){

        public boolean evaluate(Object object) {
            return object == null || EMPTY_COLLECTION.evaluate(object);
        }

        public String toString() {
            return TO_STRING_PREFIX + "NULL_OR_EMPTY_COLLECTION";
        }
    };
    public static final Predicate NULL_OR_EMPTY_ARRAY = new Predicate(){

        public boolean evaluate(Object object) {
            return object == null || EMPTY_ARRAY.evaluate(object);
        }

        public String toString() {
            return TO_STRING_PREFIX + "NULL_OR_EMPTY_ARRAY";
        }
    };
    public static final Predicate NULL_OR_EMPTY_MAP = new Predicate(){

        public boolean evaluate(Object object) {
            return object == null || EMPTY_MAP.evaluate(object);
        }

        public String toString() {
            return TO_STRING_PREFIX + "NULL_OR_EMPTY_MAP";
        }
    };

    private CollectionPredicates() {
    }

    public static boolean isNullOrEmpty(Collection<?> subject) {
        return NULL_OR_EMPTY_COLLECTION.evaluate(subject);
    }

    public static boolean isNotNullOrEmpty(Collection<?> subject) {
        return NOT_NULL_OR_EMPTY_COLLECTION.evaluate(subject);
    }

    public static boolean isNullOrEmpty(Object[] subject) {
        return NULL_OR_EMPTY_ARRAY.evaluate((Object)subject);
    }

    public static boolean isNotNullOrEmpty(Object[] subject) {
        return NOT_NULL_OR_EMPTY_ARRAY.evaluate((Object)subject);
    }

    public static boolean isNullOrEmpty(Map<?, ?> subject) {
        return NULL_OR_EMPTY_MAP.evaluate(subject);
    }

    public static boolean isNotNullOrEmpty(Map<?, ?> subject) {
        return NOT_NULL_OR_EMPTY_MAP.evaluate(subject);
    }
}

