/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.CollectionPredicates;
import org.pentaho.di.core.util.KeyValue;
import org.pentaho.di.core.util.PluginProperty;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringListPluginProperty
extends KeyValue<List<String>>
implements PluginProperty,
Iterable<String> {
    private static final long serialVersionUID = 2003662016166396542L;
    public static final String VALUE_XML_TAG_NAME = "value";
    public static final char SEPARATOR_CHAR = ',';

    public StringListPluginProperty(String key) {
        super(key, new ArrayList());
    }

    public static String asString(List<String> list) {
        if (list == null) {
            return "";
        }
        return StringUtils.join(list, (char)',');
    }

    public static List<String> fromString(String input) {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.isBlank((String)input)) {
            return result;
        }
        for (String value : StringUtils.split((String)input, (char)',')) {
            result.add(value);
        }
        return result;
    }

    @Override
    public void appendXml(StringBuilder builder) {
        if (!this.evaluate()) {
            return;
        }
        String value = StringListPluginProperty.asString((List)this.getValue());
        builder.append(XMLHandler.addTagValue((String)this.getKey(), (String)value));
    }

    @Override
    public boolean evaluate() {
        return CollectionPredicates.NOT_NULL_OR_EMPTY_COLLECTION.evaluate(this.getValue());
    }

    @Override
    public void loadXml(Node node) {
        String stringValue = XMLHandler.getTagValue((Node)node, (String)this.getKey());
        List<String> values = StringListPluginProperty.fromString(stringValue);
        this.setValue(values);
    }

    @Override
    public void readFromPreferences(Preferences node) {
        String stringValue = node.get(this.getKey(), StringListPluginProperty.asString((List)this.getValue()));
        this.setValue(StringListPluginProperty.fromString(stringValue));
    }

    @Override
    public void readFromRepositoryStep(Repository repository, ObjectId stepId) throws KettleException {
        String stringValue = repository.getStepAttributeString(stepId, this.getKey());
        this.setValue(StringListPluginProperty.fromString(stringValue));
    }

    @Override
    public void saveToPreferences(Preferences node) {
        node.put(this.getKey(), StringListPluginProperty.asString((List)this.getValue()));
    }

    @Override
    public void saveToRepositoryStep(Repository repository, ObjectId transformationId, ObjectId stepId) throws KettleException {
        String stringValue = StringListPluginProperty.asString((List)this.getValue());
        repository.saveStepAttribute(transformationId, stepId, this.getKey(), stringValue);
    }

    public void setValues(String ... values) {
        if (this.getValue() == null) {
            this.setValue(new ArrayList());
        }
        for (String value : values) {
            ((List)this.getValue()).add(value);
        }
    }

    @Override
    public Iterator<String> iterator() throws IllegalStateException {
        this.assertValueNotNull();
        return ((List)this.getValue()).iterator();
    }

    public boolean isEmpty() {
        this.assertValueNotNull();
        return ((List)this.getValue()).isEmpty();
    }

    public int size() throws IllegalStateException {
        this.assertValueNotNull();
        return ((List)this.getValue()).size();
    }

    public void assertValueNotNull() throws IllegalStateException {
        if (this.getValue() == null) {
            throw new IllegalStateException("Value is null");
        }
    }
}

