/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.imp.rules;

import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.ImportRulePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.imp.rule.ImportRuleInterface;
import org.pentaho.di.imp.rule.ImportValidationFeedback;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseImportRule
implements ImportRuleInterface {
    public static String XML_TAG = "rule";
    private String id;
    private boolean enabled = false;

    @Override
    public ImportRuleInterface clone() {
        try {
            return (ImportRuleInterface)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Unable to clone import rule", e);
        }
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public abstract List<ImportValidationFeedback> verifyRule(Object var1);

    @Override
    public String getXML() {
        StringBuilder xml = new StringBuilder();
        xml.append(XMLHandler.addTagValue((String)"id", (String)this.id));
        xml.append(XMLHandler.addTagValue((String)"enabled", (boolean)this.enabled));
        return xml.toString();
    }

    @Override
    public void loadXML(Node ruleNode) throws KettleException {
        this.id = XMLHandler.getTagValue((Node)ruleNode, (String)"id");
        this.enabled = ValueMeta.convertStringToBoolean((String)XMLHandler.getTagValue((Node)ruleNode, (String)"enabled"));
    }

    public String toString() {
        String pluginId = PluginRegistry.getInstance().getPluginId((Object)this);
        PluginInterface plugin = PluginRegistry.getInstance().findPluginWithId(ImportRulePluginType.class, pluginId);
        return plugin.getName() + " (" + (this.enabled ? "enabled" : "disabled") + ").";
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getCompositeClassName() {
        String className = this.getClass().getCanonicalName();
        className = className.replaceFirst("\\.di\\.", ".di.ui.");
        className = className + "Composite";
        return className;
    }
}

