/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.imp.rules;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.imp.rule.ImportRuleInterface;
import org.pentaho.di.imp.rule.ImportValidationFeedback;
import org.pentaho.di.imp.rule.ImportValidationResultType;
import org.pentaho.di.imp.rules.BaseImportRule;
import org.pentaho.di.job.JobMeta;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobHasDescriptionImportRule
extends BaseImportRule
implements ImportRuleInterface {
    private int minLength = 20;

    @Override
    public String toString() {
        if (this.minLength > 0) {
            return super.toString() + " The minimum length is " + this.minLength;
        }
        return super.toString();
    }

    @Override
    public List<ImportValidationFeedback> verifyRule(Object subject) {
        ArrayList<ImportValidationFeedback> feedback = new ArrayList<ImportValidationFeedback>();
        if (!this.isEnabled()) {
            return feedback;
        }
        if (!(subject instanceof JobMeta)) {
            return feedback;
        }
        JobMeta transMeta = (JobMeta)subject;
        String description = transMeta.getDescription();
        if (description != null && description.length() > this.minLength) {
            feedback.add(new ImportValidationFeedback(this, ImportValidationResultType.APPROVAL, "A description is present"));
        } else {
            feedback.add(new ImportValidationFeedback(this, ImportValidationResultType.ERROR, "A description is not present or too short"));
        }
        return feedback;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    @Override
    public String getXML() {
        StringBuilder xml = new StringBuilder();
        xml.append(XMLHandler.openTag((String)XML_TAG));
        xml.append(super.getXML());
        xml.append(XMLHandler.addTagValue((String)"min_length", (int)this.minLength));
        xml.append(XMLHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    @Override
    public void loadXML(Node ruleNode) throws KettleException {
        super.loadXML(ruleNode);
        this.minLength = Const.toInt((String)XMLHandler.getTagValue((Node)ruleNode, (String)"min_length"), (int)0);
    }
}

