/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleJobException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.gui.JobTracker;
import org.pentaho.di.core.logging.CentralLogStore;
import org.pentaho.di.core.logging.ChannelLogTable;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.HasLogChannelInterface;
import org.pentaho.di.core.logging.JobEntryLogTable;
import org.pentaho.di.core.logging.JobLogTable;
import org.pentaho.di.core.logging.Log4jBufferAppender;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LogTableInterface;
import org.pentaho.di.core.logging.LoggingHierarchy;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.parameters.DuplicateParamException;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobAdapter;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.job.JobEntryListener;
import org.pentaho.di.job.JobEntryResult;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobHopMeta;
import org.pentaho.di.job.JobListener;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.job.JobEntryJob;
import org.pentaho.di.job.entries.special.JobEntrySpecial;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.resource.ResourceUtil;
import org.pentaho.di.resource.TopLevelResource;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.WebResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Job
extends Thread
implements VariableSpace,
NamedParams,
HasLogChannelInterface,
LoggingObjectInterface {
    private static Class<?> PKG = Job.class;
    public static final String CONFIGURATION_IN_EXPORT_FILENAME = "__job_execution_configuration__.xml";
    private LogChannelInterface log;
    private LogLevel logLevel = DefaultLogLevel.getLogLevel();
    private String containerObjectId;
    private JobMeta jobMeta;
    private int logCommitSize = 10;
    private Repository rep;
    private AtomicInteger errors;
    private VariableSpace variables = new Variables();
    private Job parentJob;
    private LoggingObjectInterface parentLoggingObject;
    private JobTracker jobTracker;
    private List<JobEntryResult> jobEntryResults;
    private Date startDate;
    private Date endDate;
    private Date currentDate;
    private Date logDate;
    private Date depDate;
    private AtomicBoolean active;
    private AtomicBoolean stopped;
    private long batchId;
    private long passedBatchId;
    private List<RowMetaAndData> sourceRows;
    private Result result;
    private AtomicBoolean initialized;
    private boolean interactive;
    private List<JobListener> jobListeners;
    private List<JobEntryListener> jobEntryListeners;
    private Map<JobEntryCopy, JobEntryTrans> activeJobEntryTransformations;
    private Map<JobEntryCopy, JobEntryJob> activeJobEntryJobs;
    private NamedParams namedParams = new NamedParamsDefault();
    private AtomicBoolean finished;
    private SocketRepository socketRepository;
    private int maxJobEntriesLogged;
    private JobEntryCopy startJobEntryCopy;

    public Job(String name, String file, String[] args) {
        this();
        this.jobMeta = new JobMeta();
        if (name != null) {
            this.setName(name + " (" + super.getName() + ")");
        }
        this.jobMeta.setName(name);
        this.jobMeta.setFilename(file);
        this.jobMeta.setArguments(args);
        this.init();
        this.log = new LogChannel((Object)this);
    }

    public void init() {
        this.jobListeners = new ArrayList<JobListener>();
        this.jobEntryListeners = new ArrayList<JobEntryListener>();
        this.activeJobEntryTransformations = new HashMap<JobEntryCopy, JobEntryTrans>();
        this.activeJobEntryJobs = new HashMap<JobEntryCopy, JobEntryJob>();
        this.active = new AtomicBoolean(false);
        this.stopped = new AtomicBoolean(false);
        this.jobTracker = new JobTracker(this.jobMeta);
        this.jobEntryResults = new LinkedList<JobEntryResult>();
        this.initialized = new AtomicBoolean(false);
        this.finished = new AtomicBoolean(false);
        this.errors = new AtomicInteger(0);
        this.batchId = -1L;
        this.passedBatchId = -1L;
        this.maxJobEntriesLogged = Const.toInt((String)EnvUtil.getSystemProperty((String)"KETTLE_MAX_JOB_ENTRIES_LOGGED"), (int)1000);
        this.result = null;
        this.setDefaultLogCommitSize();
    }

    private void setDefaultLogCommitSize() {
        String propLogCommitSize = this.getVariable("pentaho.log.commit.size");
        if (propLogCommitSize != null) {
            try {
                this.logCommitSize = Integer.parseInt(propLogCommitSize);
            }
            catch (Exception ignored) {
                this.logCommitSize = 10;
            }
        }
    }

    public Job(Repository repository, JobMeta jobMeta) {
        this(repository, jobMeta, null);
    }

    public Job(Repository repository, JobMeta jobMeta, LoggingObjectInterface parentLogging) {
        this.rep = repository;
        this.jobMeta = jobMeta;
        this.parentLoggingObject = parentLogging;
        this.init();
        this.jobTracker = new JobTracker(jobMeta);
        this.log = new LogChannel((Object)this, parentLogging);
        this.logLevel = this.log.getLogLevel();
        this.containerObjectId = this.log.getContainerObjectId();
    }

    public Job() {
        this.init();
        this.log = new LogChannel((Object)this);
        this.logLevel = this.log.getLogLevel();
    }

    @Override
    public String toString() {
        if (this.jobMeta == null || Const.isEmpty((String)this.jobMeta.getName())) {
            return this.getName();
        }
        return this.jobMeta.getName();
    }

    public static final Job createJobWithNewClassLoader() throws KettleException {
        try {
            Class<?> jobClass = Const.createNewClassLoader().loadClass(Job.class.getName());
            Job job = (Job)jobClass.newInstance();
            return job;
        }
        catch (Exception e) {
            String message = BaseMessages.getString(PKG, (String)"Job.Log.ErrorAllocatingNewJob", (String[])new String[]{e.toString()});
            throw new KettleException(message, (Throwable)e);
        }
    }

    public String getJobname() {
        if (this.jobMeta == null) {
            return null;
        }
        return this.jobMeta.getName();
    }

    public void setRepository(Repository rep) {
        this.rep = rep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block8: {
            this.stopped = new AtomicBoolean(false);
            this.finished = new AtomicBoolean(false);
            this.initialized = new AtomicBoolean(true);
            this.variables.initializeVariablesFrom((VariableSpace)this.parentJob);
            this.setInternalKettleVariables(this.variables);
            this.copyParametersFrom(this.jobMeta);
            this.activateParameters();
            this.fireJobStartListeners();
            this.result = this.execute();
            Object var3_1 = null;
            try {
                this.fireJobFinishListeners();
            }
            catch (KettleException e) {
                this.result.setNrErrors(1L);
                this.result.setResult(false);
                this.log.logError(BaseMessages.getString(PKG, (String)"Job.Log.ErrorExecJob", (String[])new String[]{e.getMessage()}), (Throwable)e);
            }
            break block8;
            {
                catch (Throwable je) {
                    this.log.logError(BaseMessages.getString(PKG, (String)"Job.Log.ErrorExecJob", (Object[])new Object[]{je}));
                    this.result = new Result();
                    this.result.setNrErrors(1L);
                    this.result.setResult(false);
                    this.addErrors(1);
                    this.active.set(false);
                    this.finished.set(true);
                    this.stopped.set(false);
                    Object var3_2 = null;
                    try {
                        this.fireJobFinishListeners();
                    }
                    catch (KettleException e) {
                        this.result.setNrErrors(1L);
                        this.result.setResult(false);
                        this.log.logError(BaseMessages.getString(PKG, (String)"Job.Log.ErrorExecJob", (String[])new String[]{e.getMessage()}), (Throwable)e);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    this.fireJobFinishListeners();
                }
                catch (KettleException e) {
                    this.result.setNrErrors(1L);
                    this.result.setResult(false);
                    this.log.logError(BaseMessages.getString(PKG, (String)"Job.Log.ErrorExecJob", (String[])new String[]{e.getMessage()}), (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result execute() throws KettleException {
        this.finished.set(false);
        this.stopped.set(false);
        this.log.logMinimal(BaseMessages.getString(PKG, (String)"Job.Comment.JobStarted", (String[])new String[0]));
        JobEntryResult jerStart = new JobEntryResult(null, null, BaseMessages.getString(PKG, (String)"Job.Comment.JobStarted", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Job.Reason.Started", (String[])new String[0]), null, 0, null);
        this.jobTracker.addJobTracker(new JobTracker(this.jobMeta, jerStart));
        this.active.set(true);
        Job syncObject = this;
        if (this.parentJob != null) {
            syncObject = this.parentJob;
        }
        Job job = syncObject;
        synchronized (job) {
            this.beginProcessing();
        }
        JobEntryCopy startpoint = this.startJobEntryCopy == null ? this.jobMeta.findJobEntry("START", 0, false) : this.startJobEntryCopy;
        if (startpoint == null) {
            throw new KettleJobException(BaseMessages.getString(PKG, (String)"Job.Log.CounldNotFindStartingPoint", (String[])new String[0]));
        }
        Result res = null;
        JobEntryResult jerEnd = null;
        if (startpoint.isStart()) {
            long iteration = 0L;
            boolean isFirst = true;
            JobEntrySpecial jes = (JobEntrySpecial)startpoint.getEntry();
            while ((jes.isRepeat() || isFirst) && !this.isStopped()) {
                isFirst = false;
                res = this.execute(0, null, startpoint, null, BaseMessages.getString(PKG, (String)"Job.Reason.Started", (String[])new String[0]));
                if (iteration > 0L && iteration % 500L == 0L) {
                    System.out.println("other 500 iterations: " + iteration);
                }
                ++iteration;
            }
            jerEnd = new JobEntryResult(res, jes.getLogChannelId(), BaseMessages.getString(PKG, (String)"Job.Comment.JobFinished", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Job.Reason.Finished", (String[])new String[0]), null, 0, null);
        } else {
            res = this.execute(0, null, startpoint, null, BaseMessages.getString(PKG, (String)"Job.Reason.Started", (String[])new String[0]));
            jerEnd = new JobEntryResult(res, startpoint.getEntry().getLogChannel().getLogChannelId(), BaseMessages.getString(PKG, (String)"Job.Comment.JobFinished", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Job.Reason.Finished", (String[])new String[0]), null, 0, null);
        }
        this.jobTracker.addJobTracker(new JobTracker(this.jobMeta, jerEnd));
        this.log.logMinimal(BaseMessages.getString(PKG, (String)"Job.Comment.JobFinished", (String[])new String[0]));
        this.active.set(false);
        this.finished.set(true);
        return res;
    }

    public Result execute(int nr, Result result) throws KettleException {
        JobEntryCopy startpoint;
        this.finished.set(false);
        this.active.set(true);
        this.initialized.set(true);
        if (this.getSourceRows() != null) {
            result.setRows(this.getSourceRows());
        }
        if ((startpoint = this.jobMeta.findJobEntry("START", 0, false)) == null) {
            throw new KettleJobException(BaseMessages.getString(PKG, (String)"Job.Log.CounldNotFindStartingPoint", (String[])new String[0]));
        }
        Result res = this.execute(nr, result, startpoint, null, BaseMessages.getString(PKG, (String)"Job.Reason.StartOfJobentry", (String[])new String[0]));
        this.active.set(false);
        return res;
    }

    public void fireJobFinishListeners() throws KettleException {
        for (JobListener jobListener : this.jobListeners) {
            jobListener.jobFinished(this);
        }
    }

    public void fireJobStartListeners() throws KettleException {
        for (JobListener jobListener : this.jobListeners) {
            jobListener.jobStarted(this);
        }
    }

    private Result execute(final int nr, Result prev_result, final JobEntryCopy jobEntryCopy, JobEntryCopy previous, String reason) throws KettleException {
        int i;
        String throughput;
        Result res = null;
        if (this.stopped.get()) {
            res = new Result(nr);
            res.stopped = true;
            return res;
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed("exec(" + nr + ", " + (prev_result != null ? prev_result.getNrErrors() : 0L) + ", " + (jobEntryCopy != null ? jobEntryCopy.toString() : "null") + ")");
        }
        JobEntryInterface jobEntryInterface = jobEntryCopy.getEntry();
        jobEntryInterface.getLogChannel().setLogLevel(this.logLevel);
        JobEntryResult jerBefore = new JobEntryResult(null, null, BaseMessages.getString(PKG, (String)"Job.Comment.JobStarted", (String[])new String[0]), reason, jobEntryCopy.getName(), jobEntryCopy.getNr(), this.environmentSubstitute(jobEntryCopy.getEntry().getFilename()));
        this.jobTracker.addJobTracker(new JobTracker(this.jobMeta, jerBefore));
        Result prevResult = null;
        prevResult = prev_result != null ? prev_result.clone() : new Result();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(jobEntryInterface.getClass().getClassLoader());
        JobEntryInterface cloneJei = (JobEntryInterface)jobEntryInterface.clone();
        ((VariableSpace)cloneJei).copyVariablesFrom((VariableSpace)this);
        cloneJei.setRepository(this.rep);
        cloneJei.setParentJob(this);
        long start = System.currentTimeMillis();
        cloneJei.getLogChannel().logDetailed("Starting job entry");
        for (JobEntryListener jobEntryListener : this.jobEntryListeners) {
            jobEntryListener.beforeExecution(this, jobEntryCopy, cloneJei);
        }
        if (this.interactive) {
            if (jobEntryCopy.isTransformation()) {
                this.getActiveJobEntryTransformations().put(jobEntryCopy, (JobEntryTrans)cloneJei);
            }
            if (jobEntryCopy.isJob()) {
                this.getActiveJobEntryJobs().put(jobEntryCopy, (JobEntryJob)cloneJei);
            }
        }
        final Result result = cloneJei.execute(prevResult, nr);
        long end = System.currentTimeMillis();
        if (this.interactive) {
            if (jobEntryCopy.isTransformation()) {
                this.getActiveJobEntryTransformations().remove(jobEntryCopy);
            }
            if (jobEntryCopy.isJob()) {
                this.getActiveJobEntryJobs().remove(jobEntryCopy);
            }
        }
        if (cloneJei instanceof JobEntryTrans && (throughput = result.getReadWriteThroughput((int)((end - start) / 1000L))) != null) {
            this.log.logMinimal(throughput);
        }
        for (JobEntryListener jobEntryListener : this.jobEntryListeners) {
            jobEntryListener.afterExecution(this, jobEntryCopy, cloneJei, result);
        }
        Thread.currentThread().setContextClassLoader(cl);
        this.addErrors((int)result.getNrErrors());
        Log4jBufferAppender appender = CentralLogStore.getAppender();
        StringBuffer logTextBuffer = appender.getBuffer(cloneJei.getLogChannel().getLogChannelId(), false);
        result.setLogText(logTextBuffer.toString());
        JobEntryResult jerAfter = new JobEntryResult(result, cloneJei.getLogChannel().getLogChannelId(), BaseMessages.getString(PKG, (String)"Job.Comment.JobFinished", (String[])new String[0]), null, jobEntryCopy.getName(), jobEntryCopy.getNr(), this.environmentSubstitute(jobEntryCopy.getEntry().getFilename()));
        this.jobTracker.addJobTracker(new JobTracker(this.jobMeta, jerAfter));
        this.jobEntryResults.add(jerAfter);
        if (this.maxJobEntriesLogged > 0 && this.jobEntryResults.size() > this.maxJobEntriesLogged + 50) {
            this.jobEntryResults = this.jobEntryResults.subList(50, this.jobEntryResults.size());
        }
        ArrayList<Thread> threads = new ArrayList<Thread>();
        final ArrayList threadResults = new ArrayList();
        final ArrayList<KettleException> threadExceptions = new ArrayList<KettleException>();
        ArrayList<JobEntryCopy> threadEntries = new ArrayList<JobEntryCopy>();
        int nrNext = this.jobMeta.findNrNextJobEntries(jobEntryCopy);
        for (i = 0; i < nrNext && !this.isStopped(); ++i) {
            final JobEntryCopy nextEntry = this.jobMeta.findNextJobEntry(jobEntryCopy, i);
            JobHopMeta hi = this.jobMeta.findJobHop(jobEntryCopy, nextEntry);
            final String nextComment = hi.isUnconditional() ? BaseMessages.getString(PKG, (String)"Job.Comment.FollowedUnconditional", (String[])new String[0]) : (result.getResult() ? BaseMessages.getString(PKG, (String)"Job.Comment.FollowedSuccess", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"Job.Comment.FollowedFailure", (String[])new String[0]));
            if (!hi.isUnconditional() && (!jobEntryCopy.evaluates() || hi.getEvaluation() ^ result.getResult())) continue;
            if (this.log.isBasic()) {
                this.log.logBasic(BaseMessages.getString(PKG, (String)"Job.Log.StartingEntry", (String[])new String[]{nextEntry.getName()}));
            }
            if (nextEntry.resetErrorsBeforeExecution()) {
                result.setNrErrors(0L);
            }
            if (jobEntryCopy.isLaunchingInParallel()) {
                threadEntries.add(nextEntry);
                Runnable runnable = new Runnable(){

                    public void run() {
                        try {
                            Result threadResult = Job.this.execute(nr + 1, result, nextEntry, jobEntryCopy, nextComment);
                            threadResults.add(threadResult);
                        }
                        catch (Throwable e) {
                            Job.this.log.logError(Const.getStackTracker((Throwable)e));
                            threadExceptions.add(new KettleException(BaseMessages.getString((Class)PKG, (String)"Job.Log.UnexpectedError", (String[])new String[]{nextEntry.toString()}), e));
                            Result threadResult = new Result();
                            threadResult.setResult(false);
                            threadResult.setNrErrors(1L);
                            threadResults.add(threadResult);
                        }
                    }
                };
                Thread thread = new Thread(runnable);
                threads.add(thread);
                thread.start();
                if (!this.log.isBasic()) continue;
                this.log.logBasic(BaseMessages.getString(PKG, (String)"Job.Log.LaunchedJobEntryInParallel", (String[])new String[]{nextEntry.getName()}));
                continue;
            }
            try {
                res = this.execute(nr + 1, result, nextEntry, jobEntryCopy, nextComment);
            }
            catch (Throwable e) {
                this.log.logError(Const.getStackTracker((Throwable)e));
                throw new KettleException(BaseMessages.getString(PKG, (String)"Job.Log.UnexpectedError", (String[])new String[]{nextEntry.toString()}), e);
            }
            if (!this.log.isBasic()) continue;
            this.log.logBasic(BaseMessages.getString(PKG, (String)"Job.Log.FinishedJobEntry", (String[])new String[]{nextEntry.getName(), res.getResult() + ""}));
        }
        if (jobEntryCopy.isLaunchingInParallel()) {
            for (i = 0; i < threads.size(); ++i) {
                Thread thread = (Thread)threads.get(i);
                JobEntryCopy nextEntry = (JobEntryCopy)threadEntries.get(i);
                try {
                    thread.join();
                    continue;
                }
                catch (InterruptedException e) {
                    this.log.logError(this.jobMeta.toString(), new Object[]{BaseMessages.getString(PKG, (String)"Job.Log.UnexpectedErrorWhileWaitingForJobEntry", (String[])new String[]{nextEntry.getName()})});
                    threadExceptions.add(new KettleException(BaseMessages.getString(PKG, (String)"Job.Log.UnexpectedErrorWhileWaitingForJobEntry", (String[])new String[]{nextEntry.getName()}), (Throwable)e));
                }
            }
        }
        if (res == null) {
            res = prevResult;
        }
        if (threadExceptions.size() > 0) {
            res.setResult(false);
            res.setNrErrors((long)threadExceptions.size());
            for (KettleException e : threadExceptions) {
                this.log.logError(this.jobMeta.toString(), new Object[]{e.getMessage(), e});
            }
            throw (KettleException)((Object)threadExceptions.get(0));
        }
        for (Result threadResult : threadResults) {
            res.add(threadResult);
        }
        if (res.getNrErrors() > 0L) {
            res.setResult(false);
        }
        return res;
    }

    public void waitUntilFinished() {
        this.waitUntilFinished(-1L);
    }

    public void waitUntilFinished(long maxMiliseconds) {
        long time = 0L;
        while (this.isAlive() && (time < maxMiliseconds || maxMiliseconds <= 0L)) {
            try {
                Thread.sleep(1L);
                ++time;
            }
            catch (InterruptedException e) {}
        }
    }

    public int getErrors() {
        return this.errors.get();
    }

    public void resetErrors() {
        this.errors.set(0);
    }

    public void addErrors(int nrToAdd) {
        if (nrToAdd > 0) {
            this.errors.addAndGet(nrToAdd);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean beginProcessing() throws KettleException {
        ChannelLogTable channelLogTable;
        JobEntryLogTable jobEntryLogTable;
        this.currentDate = new Date();
        this.logDate = new Date();
        this.startDate = Const.MIN_DATE;
        this.endDate = this.currentDate;
        this.resetErrors();
        final JobLogTable jobLogTable = this.jobMeta.getJobLogTable();
        int intervalInSeconds = Const.toInt((String)this.environmentSubstitute(jobLogTable.getLogInterval()), (int)-1);
        if (jobLogTable.isDefined()) {
            DatabaseMeta logcon = this.jobMeta.getJobLogTable().getDatabaseMeta();
            String schemaName = this.environmentSubstitute(this.jobMeta.getJobLogTable().getActualSchemaName());
            String tableName = this.environmentSubstitute(this.jobMeta.getJobLogTable().getActualTableName());
            String schemaAndTable = this.jobMeta.getJobLogTable().getDatabaseMeta().getQuotedSchemaTableCombination(schemaName, tableName);
            Database ldb = new Database((LoggingObjectInterface)this, logcon);
            ldb.shareVariablesWith((VariableSpace)this);
            ldb.connect();
            ldb.setCommit(this.logCommitSize);
            try {
                try {
                    Object[] lastr;
                    Long id_batch = new Long(1L);
                    if (this.jobMeta.getJobLogTable().isBatchIdUsed()) {
                        id_batch = logcon.getNextBatchId(ldb, schemaName, tableName, jobLogTable.getKeyField().getFieldName());
                        this.setBatchId(id_batch);
                        if (this.getPassedBatchId() <= 0L) {
                            this.setPassedBatchId(id_batch);
                        }
                    }
                    if (!Const.isEmpty((Object[])(lastr = ldb.getLastLogDate(schemaAndTable, this.jobMeta.getName(), true, LogStatus.END)))) {
                        Date last;
                        try {
                            last = ldb.getReturnRowMeta().getDate(lastr, 0);
                        }
                        catch (KettleValueException e) {
                            throw new KettleJobException(BaseMessages.getString(PKG, (String)"Job.Log.ConversionError", (String[])new String[]{"" + tableName}), (Throwable)e);
                        }
                        if (last != null) {
                            this.startDate = last;
                        }
                    }
                    this.depDate = this.currentDate;
                    ldb.writeLogRecord((LogTableInterface)this.jobMeta.getJobLogTable(), LogStatus.START, (Object)this, null);
                    if (!ldb.isAutoCommit()) {
                        ldb.commit(true);
                    }
                    ldb.disconnect();
                    if (intervalInSeconds > 0) {
                        final Timer timer = new Timer(this.getName() + " - interval logging timer");
                        TimerTask timerTask = new TimerTask(){

                            public void run() {
                                try {
                                    Job.this.endProcessing();
                                }
                                catch (Exception e) {
                                    Job.this.log.logError(BaseMessages.getString((Class)PKG, (String)"Job.Exception.UnableToPerformIntervalLogging", (String[])new String[0]), (Throwable)e);
                                    Job.this.errors.incrementAndGet();
                                    Job.this.stopAll();
                                }
                            }
                        };
                        timer.schedule(timerTask, intervalInSeconds * 1000, (long)(intervalInSeconds * 1000));
                        this.addJobListener(new JobAdapter(){

                            public void jobFinished(Job job) {
                                timer.cancel();
                            }
                        });
                    }
                    this.addJobListener(new JobAdapter(){

                        public void jobFinished(Job job) {
                            try {
                                Job.this.endProcessing();
                            }
                            catch (Exception e) {
                                Job.this.log.logError(BaseMessages.getString((Class)PKG, (String)"Job.Exception.UnableToWriteToLoggingTable", (String[])new String[]{jobLogTable.toString()}), (Throwable)e);
                            }
                        }
                    });
                }
                catch (KettleDatabaseException dbe) {
                    this.addErrors(1);
                    throw new KettleJobException(BaseMessages.getString(PKG, (String)"Job.Log.UnableToProcessLoggingStart", (String[])new String[]{"" + tableName}), (Throwable)dbe);
                }
                Object var13_14 = null;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                ldb.disconnect();
                throw throwable;
            }
            ldb.disconnect();
        }
        if ((jobEntryLogTable = this.jobMeta.getJobEntryLogTable()).isDefined()) {
            this.addJobListener(new JobAdapter(){

                public void jobFinished(Job job) throws KettleException {
                    try {
                        Job.this.writeJobEntryLogInformation();
                    }
                    catch (KettleException e) {
                        throw new KettleException(BaseMessages.getString((Class)PKG, (String)"Job.Exception.UnableToPerformJobEntryLoggingAtJobEnd", (String[])new String[0]), (Throwable)e);
                    }
                }
            });
        }
        if ((channelLogTable = this.jobMeta.getChannelLogTable()).isDefined()) {
            this.addJobListener(new JobAdapter(){

                public void jobFinished(Job job) throws KettleException {
                    try {
                        Job.this.writeLogChannelInformation();
                    }
                    catch (KettleException e) {
                        throw new KettleException(BaseMessages.getString((Class)PKG, (String)"Trans.Exception.UnableToPerformLoggingAtTransEnd", (String[])new String[0]), (Throwable)e);
                    }
                }
            });
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean endProcessing() throws KettleJobException {
        LogStatus status = !this.isActive() ? (this.isStopped() ? LogStatus.STOP : LogStatus.END) : LogStatus.RUNNING;
        try {
            if (this.errors.get() == 0 && this.result != null && !this.result.getResult()) {
                this.errors.incrementAndGet();
            }
            this.logDate = new Date();
            JobLogTable jobLogTable = this.jobMeta.getJobLogTable();
            if (!jobLogTable.isDefined()) return true;
            String tableName = this.jobMeta.getJobLogTable().getActualTableName();
            DatabaseMeta logcon = this.jobMeta.getJobLogTable().getDatabaseMeta();
            Database ldb = new Database((LoggingObjectInterface)this, logcon);
            ldb.shareVariablesWith((VariableSpace)this);
            try {
                try {
                    ldb.connect();
                    ldb.setCommit(this.logCommitSize);
                    ldb.writeLogRecord((LogTableInterface)this.jobMeta.getJobLogTable(), status, (Object)this, null);
                }
                catch (KettleDatabaseException dbe) {
                    this.addErrors(1);
                    throw new KettleJobException("Unable to end processing by writing log record to table " + tableName, (Throwable)dbe);
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (!ldb.isAutoCommit()) {
                    ldb.commit(true);
                }
                ldb.disconnect();
                throw throwable;
            }
            if (!ldb.isAutoCommit()) {
                ldb.commit(true);
            }
            ldb.disconnect();
            return true;
        }
        catch (Exception e) {
            throw new KettleJobException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeLogChannelInformation() throws KettleException {
        Database db = null;
        ChannelLogTable channelLogTable = this.jobMeta.getChannelLogTable();
        Job j = this.getParentJob();
        if (j != null && channelLogTable.equals(j.getJobMeta().getChannelLogTable())) {
            return;
        }
        try {
            try {
                db = new Database((LoggingObjectInterface)this, channelLogTable.getDatabaseMeta());
                db.shareVariablesWith((VariableSpace)this);
                db.connect();
                db.setCommit(this.logCommitSize);
                List<LoggingHierarchy> loggingHierarchyList = this.getLoggingHierarchy();
                for (LoggingHierarchy loggingHierarchy : loggingHierarchyList) {
                    db.writeLogRecord((LogTableInterface)channelLogTable, LogStatus.START, (Object)loggingHierarchy, null);
                }
                db.cleanupLogRecords((LogTableInterface)channelLogTable);
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Trans.Exception.UnableToWriteLogChannelInformationToLogTable", (String[])new String[0]), (Throwable)e);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!db.isAutoCommit()) {
                db.commit(true);
            }
            db.disconnect();
            throw throwable;
        }
        if (!db.isAutoCommit()) {
            db.commit(true);
        }
        db.disconnect();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeJobEntryLogInformation() throws KettleException {
        Database db = null;
        JobEntryLogTable jobEntryLogTable = this.jobMeta.getJobEntryLogTable();
        try {
            try {
                db = new Database((LoggingObjectInterface)this, jobEntryLogTable.getDatabaseMeta());
                db.shareVariablesWith((VariableSpace)this);
                db.connect();
                db.setCommit(this.logCommitSize);
                for (JobEntryCopy copy : this.jobMeta.getJobCopies()) {
                    db.writeLogRecord((LogTableInterface)jobEntryLogTable, LogStatus.START, (Object)copy, (Object)this);
                }
                Object var6_6 = null;
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Job.Exception.UnableToJobEntryInformationToLogTable", (String[])new String[0]), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!db.isAutoCommit()) {
                db.commit(true);
            }
            db.disconnect();
            throw throwable;
        }
        if (!db.isAutoCommit()) {
            db.commit(true);
        }
        db.disconnect();
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void stopAll() {
        this.stopped.set(true);
    }

    public void setStopped(boolean stopped) {
        this.stopped.set(stopped);
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public Date getDepDate() {
        return this.depDate;
    }

    public Date getLogDate() {
        return this.logDate;
    }

    public JobMeta getJobMeta() {
        return this.jobMeta;
    }

    public Repository getRep() {
        return this.rep;
    }

    public Thread getThread() {
        return this;
    }

    public JobTracker getJobTracker() {
        return this.jobTracker;
    }

    public void setJobTracker(JobTracker jobTracker) {
        this.jobTracker = jobTracker;
    }

    public void setSourceRows(List<RowMetaAndData> sourceRows) {
        this.sourceRows = sourceRows;
    }

    public List<RowMetaAndData> getSourceRows() {
        return this.sourceRows;
    }

    public Job getParentJob() {
        return this.parentJob;
    }

    public void setParentJob(Job parentJob) {
        this.logLevel = parentJob.getLogLevel();
        this.log.setLogLevel(this.logLevel);
        this.containerObjectId = this.log.getContainerObjectId();
        this.parentJob = parentJob;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public long getBatchId() {
        return this.batchId;
    }

    public void setBatchId(long batchId) {
        this.batchId = batchId;
    }

    public long getPassedBatchId() {
        return this.passedBatchId;
    }

    public void setPassedBatchId(long jobBatchId) {
        this.passedBatchId = jobBatchId;
    }

    public void setInternalKettleVariables(VariableSpace var) {
        if (this.jobMeta != null && this.jobMeta.getFilename() != null) {
            try {
                FileObject fileObject = KettleVFS.getFileObject((String)this.jobMeta.getFilename(), (VariableSpace)this);
                FileName fileName = fileObject.getName();
                var.setVariable("Internal.Job.Filename.Name", fileName.getBaseName());
                FileName fileDir = fileName.getParent();
                var.setVariable("Internal.Job.Filename.Directory", fileDir.getURI());
            }
            catch (Exception e) {
                var.setVariable("Internal.Job.Filename.Directory", "");
                var.setVariable("Internal.Job.Filename.Name", "");
            }
        } else {
            var.setVariable("Internal.Job.Filename.Directory", "");
            var.setVariable("Internal.Job.Filename.Name", "");
        }
        var.setVariable("Internal.Job.Name", Const.NVL((String)this.jobMeta.getName(), (String)""));
        var.setVariable("Internal.Job.Repository.Directory", this.jobMeta.getRepositoryDirectory() != null ? this.jobMeta.getRepositoryDirectory().getPath() : "");
        var.setVariable("Internal.Transformation.Filename.Directory", null);
        var.setVariable("Internal.Transformation.Filename.Name", null);
        var.setVariable("Internal.Transformation.Filename.Directory", null);
        var.setVariable("Internal.Transformation.Filename.Name", null);
        var.setVariable("Internal.Transformation.Name", null);
        var.setVariable("Internal.Transformation.Repository.Directory", null);
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Const.isEmpty((String)variableName) && !Const.isEmpty((String)(value = this.environmentSubstitute(variableName)))) {
            return ValueMeta.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public String getStatus() {
        String message;
        if (!this.initialized.get()) {
            message = "Waiting";
        } else if (this.active.get()) {
            message = this.stopped.get() ? "Halting" : "Running";
        } else {
            message = this.stopped.get() ? "Stopped" : "Finished";
            if (this.result != null && this.result.getNrErrors() > 0L) {
                message = message + " (with errors)";
            }
        }
        return message;
    }

    public static String sendToSlaveServer(JobMeta jobMeta, JobExecutionConfiguration executionConfiguration, Repository repository) throws KettleException {
        SlaveServer slaveServer = executionConfiguration.getRemoteServer();
        if (slaveServer == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"Job.Log.NoSlaveServerSpecified", (String[])new String[0]));
        }
        if (Const.isEmpty((String)jobMeta.getName())) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"Job.Log.UniqueJobName", (String[])new String[0]));
        }
        slaveServer.getLogChannel().setLogLevel(executionConfiguration.getLogLevel());
        try {
            String carteObjectId;
            for (String var : Const.INTERNAL_TRANS_VARIABLES) {
                executionConfiguration.getVariables().put(var, jobMeta.getVariable(var));
            }
            for (String var : Const.INTERNAL_JOB_VARIABLES) {
                executionConfiguration.getVariables().put(var, jobMeta.getVariable(var));
            }
            if (executionConfiguration.isPassingExport()) {
                FileObject tempFile = KettleVFS.createTempFile((String)"jobExport", (String)".zip", (String)System.getProperty("java.io.tmpdir"), (VariableSpace)jobMeta);
                TopLevelResource topLevelResource = ResourceUtil.serializeResourceExportInterface(tempFile.getName().toString(), jobMeta, jobMeta, repository, executionConfiguration.getXML(), CONFIGURATION_IN_EXPORT_FILENAME);
                String result = slaveServer.sendExport(topLevelResource.getArchiveName(), "job", topLevelResource.getBaseResourceName());
                WebResult webResult = WebResult.fromXMLString(result);
                if (!webResult.getResult().equalsIgnoreCase("OK")) {
                    throw new KettleException("There was an error passing the exported job to the remote server: " + Const.CR + webResult.getMessage());
                }
                carteObjectId = webResult.getId();
            } else {
                String xml = new JobConfiguration(jobMeta, executionConfiguration).getXML();
                String reply = slaveServer.sendXML(xml, "/kettle/addJob/?xml=Y");
                WebResult webResult = WebResult.fromXMLString(reply);
                if (!webResult.getResult().equalsIgnoreCase("OK")) {
                    throw new KettleException("There was an error posting the job on the remote server: " + Const.CR + webResult.getMessage());
                }
                carteObjectId = webResult.getId();
            }
            String reply = slaveServer.execService("/kettle/startJob/?name=" + URLEncoder.encode(jobMeta.getName(), "UTF-8") + "&xml=Y&id=" + carteObjectId);
            WebResult webResult = WebResult.fromXMLString(reply);
            if (!webResult.getResult().equalsIgnoreCase("OK")) {
                throw new KettleException("There was an error starting the job on the remote server: " + Const.CR + webResult.getMessage());
            }
            return carteObjectId;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void addJobListener(JobListener jobListener) {
        this.jobListeners.add(jobListener);
    }

    public void addJobEntryListener(JobEntryListener jobEntryListener) {
        this.jobEntryListeners.add(jobEntryListener);
    }

    public void removeJobListener(JobListener jobListener) {
        this.jobListeners.remove(jobListener);
    }

    public void removeJobEntryListener(JobEntryListener jobEntryListener) {
        this.jobEntryListeners.remove(jobEntryListener);
    }

    public List<JobEntryListener> getJobEntryListeners() {
        return this.jobEntryListeners;
    }

    public List<JobListener> getJobListeners() {
        return this.jobListeners;
    }

    public boolean isFinished() {
        return this.finished.get();
    }

    public void setFinished(boolean finished) {
        this.finished.set(finished);
    }

    public void addParameterDefinition(String key, String defValue, String description) throws DuplicateParamException {
        this.namedParams.addParameterDefinition(key, defValue, description);
    }

    public String getParameterDescription(String key) throws UnknownParamException {
        return this.namedParams.getParameterDescription(key);
    }

    public String getParameterDefault(String key) throws UnknownParamException {
        return this.namedParams.getParameterDefault(key);
    }

    public String getParameterValue(String key) throws UnknownParamException {
        return this.namedParams.getParameterValue(key);
    }

    public String[] listParameters() {
        return this.namedParams.listParameters();
    }

    public void setParameterValue(String key, String value) throws UnknownParamException {
        this.namedParams.setParameterValue(key, value);
    }

    public void eraseParameters() {
        this.namedParams.eraseParameters();
    }

    public void clearParameters() {
        this.namedParams.clearParameters();
    }

    public void activateParameters() {
        String[] keys;
        for (String key : keys = this.listParameters()) {
            String defValue;
            String value;
            try {
                value = this.getParameterValue(key);
            }
            catch (UnknownParamException e) {
                value = "";
            }
            try {
                defValue = this.getParameterDefault(key);
            }
            catch (UnknownParamException e) {
                defValue = "";
            }
            if (Const.isEmpty((String)value)) {
                this.setVariable(key, Const.NVL((String)defValue, (String)""));
                continue;
            }
            this.setVariable(key, Const.NVL((String)value, (String)""));
        }
    }

    public void copyParametersFrom(NamedParams params) {
        this.namedParams.copyParametersFrom(params);
    }

    public void setSocketRepository(SocketRepository socketRepository) {
        this.socketRepository = socketRepository;
    }

    public SocketRepository getSocketRepository() {
        return this.socketRepository;
    }

    @Override
    public LogChannelInterface getLogChannel() {
        return this.log;
    }

    public String getObjectName() {
        return this.getJobname();
    }

    public String getObjectCopy() {
        return null;
    }

    public String getFilename() {
        if (this.jobMeta == null) {
            return null;
        }
        return this.jobMeta.getFilename();
    }

    public String getLogChannelId() {
        return this.log.getLogChannelId();
    }

    public ObjectId getObjectId() {
        if (this.jobMeta == null) {
            return null;
        }
        return this.jobMeta.getObjectId();
    }

    public ObjectRevision getObjectRevision() {
        if (this.jobMeta == null) {
            return null;
        }
        return this.jobMeta.getObjectRevision();
    }

    public LoggingObjectType getObjectType() {
        return LoggingObjectType.JOB;
    }

    public LoggingObjectInterface getParent() {
        return this.parentLoggingObject;
    }

    public RepositoryDirectoryInterface getRepositoryDirectory() {
        if (this.jobMeta == null) {
            return null;
        }
        return this.jobMeta.getRepositoryDirectory();
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        this.log.setLogLevel(logLevel);
    }

    public List<LoggingHierarchy> getLoggingHierarchy() {
        ArrayList<LoggingHierarchy> hierarchy = new ArrayList<LoggingHierarchy>();
        List childIds = LoggingRegistry.getInstance().getLogChannelChildren(this.getLogChannelId());
        for (String childId : childIds) {
            LoggingObjectInterface loggingObject = LoggingRegistry.getInstance().getLoggingObject(childId);
            if (loggingObject == null) continue;
            hierarchy.add(new LoggingHierarchy(this.getLogChannelId(), this.batchId, loggingObject));
        }
        return hierarchy;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public Map<JobEntryCopy, JobEntryTrans> getActiveJobEntryTransformations() {
        return this.activeJobEntryTransformations;
    }

    public Map<JobEntryCopy, JobEntryJob> getActiveJobEntryJobs() {
        return this.activeJobEntryJobs;
    }

    public List<JobEntryResult> getJobEntryResults() {
        return this.jobEntryResults;
    }

    public String getContainerObjectId() {
        return this.containerObjectId;
    }

    public void setContainerObjectId(String containerObjectId) {
        this.containerObjectId = containerObjectId;
    }

    public LoggingObjectInterface getParentLoggingObject() {
        return this.parentLoggingObject;
    }

    public Date getRegistrationDate() {
        return null;
    }

    public JobEntryCopy getStartJobEntryCopy() {
        return this.startJobEntryCopy;
    }

    public void setStartJobEntryCopy(JobEntryCopy startJobEntryCopy) {
        this.startJobEntryCopy = startJobEntryCopy;
    }
}

