/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.deletefile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.FileExistsValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryDeleteFile
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryDeleteFile.class;
    private String filename = null;
    private boolean failIfFileNotExists = false;

    public JobEntryDeleteFile(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryDeleteFile() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryDeleteFile je = (JobEntryDeleteFile)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fail_if_file_not_exists", (boolean)this.failIfFileNotExists));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.filename = XMLHandler.getTagValue((Node)entrynode, (String)"filename");
            this.failIfFileNotExists = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"fail_if_file_not_exists"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryDeleteFile.Error_0001_Unable_To_Load_Job_From_Xml_Node", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "filename");
            this.failIfFileNotExists = rep.getJobEntryAttributeBoolean(id_jobentry, "fail_if_file_not_exists");
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryDeleteFile.ERROR_0002_Unable_To_Load_From_Repository", (Object[])new Object[]{id_jobentry}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "filename", this.filename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "fail_if_file_not_exists", this.failIfFileNotExists);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryDeleteFile.ERROR_0003_Unable_To_Save_Job_To_Repository", (Object[])new Object[]{id_job}), (Throwable)dbe);
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getRealFilename() {
        return this.environmentSubstitute(this.getFilename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        if (this.filename != null) {
            FileObject fileObject;
            String realFilename;
            block15: {
                realFilename = this.getRealFilename();
                fileObject = null;
                fileObject = KettleVFS.getFileObject((String)realFilename, (VariableSpace)this);
                if (!fileObject.exists()) {
                    if (this.isFailIfFileNotExists()) {
                        result.setResult(false);
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntryDeleteFile.ERROR_0004_File_Does_Not_Exist", (String[])new String[]{realFilename}));
                    } else {
                        result.setResult(true);
                        if (this.log.isBasic()) {
                            this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryDeleteFile.File_Already_Deleted", (String[])new String[]{realFilename}));
                        }
                    }
                    break block15;
                }
                boolean deleted = fileObject.delete();
                if (!deleted) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryDeleteFile.ERROR_0005_Could_Not_Delete_File", (String[])new String[]{realFilename}));
                    result.setResult(false);
                    result.setNrErrors(1L);
                }
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryDeleteFile.File_Deleted", (String[])new String[]{realFilename}));
                }
                result.setResult(true);
            }
            Object var8_8 = null;
            if (fileObject == null) return result;
            try {
                fileObject.close();
                fileObject = null;
                return result;
            }
            catch (IOException ex) {}
            return result;
            {
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryDeleteFile.ERROR_0006_Exception_Deleting_File", (String[])new String[]{realFilename, e.getMessage()}), e);
                    result.setResult(false);
                    result.setNrErrors(1L);
                    Object var8_9 = null;
                    if (fileObject == null) return result;
                    try {
                        fileObject.close();
                        fileObject = null;
                        return result;
                    }
                    catch (IOException ex) {}
                    return result;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (fileObject == null) throw throwable;
                try {
                    fileObject.close();
                    fileObject = null;
                    throw throwable;
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.logError(BaseMessages.getString(PKG, (String)"JobEntryDeleteFile.ERROR_0007_No_Filename_Is_Defined", (String[])new String[0]));
        return result;
    }

    public boolean isFailIfFileNotExists() {
        return this.failIfFileNotExists;
    }

    public void setFailIfFileNotExists(boolean failIfFileExists) {
        this.failIfFileNotExists = failIfFileExists;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.filename)) {
            String realFileName = jobMeta.environmentSubstitute(this.filename);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        if (this.isFailIfFileNotExists()) {
            FileExistsValidator.putFailIfDoesNotExist(ctx, true);
        }
        JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, ctx);
    }

    public static void main(String[] args) {
        ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
        new JobEntryDeleteFile().check(remarks, null);
        System.out.printf("Remarks: %s\n", remarks);
    }
}

