/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.dtdvalidator;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.dtdvalidator.JobEntryDTDValidator;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DTDValidator {
    private static Class<?> PKG = JobEntryDTDValidator.class;
    private String xmlfilename;
    private String xsdfilename;
    private boolean interndtd;
    private String errormessage;
    private int errorscount;
    private LogChannelInterface log;

    public DTDValidator(LogChannelInterface log) {
        this.log = log;
        this.xmlfilename = null;
        this.xsdfilename = null;
        this.interndtd = false;
        this.errormessage = null;
        this.errorscount = 0;
    }

    public void setXMLFilename(String xmlfilename) {
        this.xmlfilename = xmlfilename;
    }

    public String getXMLFilename() {
        return this.xmlfilename;
    }

    public void setDTDFilename(String xsdfilename) {
        this.xsdfilename = xsdfilename;
    }

    public String getDTDFilename() {
        return this.xsdfilename;
    }

    public void setInternDTD(boolean value) {
        this.interndtd = value;
    }

    public boolean isInternDTD() {
        return this.interndtd;
    }

    private void setErrorMessage(String value) {
        this.errormessage = value;
    }

    public String getErrorMessage() {
        return this.errormessage;
    }

    public int getNrErrors() {
        return this.errorscount;
    }

    private void setNrErrors(int value) {
        this.errorscount = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean validate() {
        boolean retval;
        block37: {
            ByteArrayInputStream ba;
            FileObject DTDfile;
            FileObject xmlfile;
            block36: {
                block38: {
                    block39: {
                        BufferedReader xmlBufferedReader;
                        StringBuffer xmlStringbuffer;
                        block35: {
                            retval = false;
                            xmlfile = null;
                            DTDfile = null;
                            ba = null;
                            if (this.xmlfilename == null || (this.getDTDFilename() == null || this.isInternDTD()) && !this.isInternDTD()) break block38;
                            xmlfile = KettleVFS.getFileObject((String)this.getXMLFilename());
                            if (!xmlfile.exists()) break block39;
                            URL xmlFile = new File(KettleVFS.getFilename((FileObject)xmlfile)).toURI().toURL();
                            xmlStringbuffer = new StringBuffer("");
                            xmlBufferedReader = null;
                            InputStreamReader is = null;
                            try {
                                is = new InputStreamReader(xmlFile.openStream());
                                xmlBufferedReader = new BufferedReader(is);
                                char[] buffertXML = new char[1024];
                                int LenXML = -1;
                                while ((LenXML = xmlBufferedReader.read(buffertXML)) != -1) {
                                    xmlStringbuffer.append(buffertXML, 0, LenXML);
                                }
                                Object var12_13 = null;
                                if (is == null) break block35;
                            }
                            catch (Throwable throwable) {
                                Object var12_14 = null;
                                if (is != null) {
                                    is.close();
                                }
                                if (xmlBufferedReader != null) {
                                    xmlBufferedReader.close();
                                }
                                throw throwable;
                            }
                            is.close();
                        }
                        if (xmlBufferedReader != null) {
                            xmlBufferedReader.close();
                        }
                        DocumentBuilderFactory DocBuilderFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder DocBuilder = DocBuilderFactory.newDocumentBuilder();
                        DocBuilderFactory.setValidating(false);
                        ba = new ByteArrayInputStream(xmlStringbuffer.toString().getBytes("UTF-8"));
                        Document xmlDocDTD = DocBuilder.parse(ba);
                        if (ba != null) {
                            ba.close();
                        }
                        String encoding = null;
                        encoding = xmlDocDTD.getXmlEncoding() == null ? "UTF-8" : xmlDocDTD.getXmlEncoding();
                        int xmlStartDTD = xmlStringbuffer.indexOf("<!DOCTYPE");
                        if (this.isInternDTD()) {
                            if (xmlStartDTD != -1) {
                                this.log.logBasic(BaseMessages.getString(PKG, (String)"JobEntryDTDValidator.ERRORDTDFound.Label", (String[])new String[]{this.getXMLFilename()}));
                            } else {
                                this.setErrorMessage(BaseMessages.getString(PKG, (String)"JobEntryDTDValidator.ERRORDTDNotFound.Label", (String[])new String[]{this.getXMLFilename()}));
                            }
                        } else {
                            DTDfile = KettleVFS.getFileObject((String)this.getDTDFilename());
                            if (DTDfile.exists()) {
                                if (xmlStartDTD != -1) {
                                    int EndDTD = xmlStringbuffer.indexOf(">", xmlStartDTD);
                                    xmlStringbuffer.replace(xmlStartDTD, EndDTD + 1, "");
                                }
                                String xmlRootnodeDTD = xmlDocDTD.getDocumentElement().getNodeName();
                                String RefDTD = "<?xml version='" + xmlDocDTD.getXmlVersion() + "' encoding='" + encoding + "'?>\n<!DOCTYPE " + xmlRootnodeDTD + " SYSTEM '" + KettleVFS.getFilename((FileObject)DTDfile) + "'>\n";
                                int xmloffsetDTD = xmlStringbuffer.indexOf("<" + xmlRootnodeDTD);
                                xmlStringbuffer.replace(0, xmloffsetDTD, RefDTD);
                            } else {
                                this.log.logError(BaseMessages.getString(PKG, (String)"JobEntryDTDValidator.ERRORDTDFileNotExists.Subject", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"JobEntryDTDValidator.ERRORDTDFileNotExists.Msg", (String[])new String[]{this.getDTDFilename()})});
                            }
                        }
                        if (!(this.isInternDTD() && xmlStartDTD == -1 || !this.isInternDTD() && !DTDfile.exists())) {
                            MyErrorHandler error = new MyErrorHandler();
                            DocBuilderFactory.setValidating(true);
                            DocBuilder = DocBuilderFactory.newDocumentBuilder();
                            DocBuilder.setErrorHandler(error);
                            ba = new ByteArrayInputStream(xmlStringbuffer.toString().getBytes(encoding));
                            xmlDocDTD = DocBuilder.parse(ba);
                            if (error.errorMessage == null) {
                                this.log.logBasic(BaseMessages.getString(PKG, (String)"JobEntryDTDValidator.DTDValidatorOK.Subject", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"JobEntryDTDValidator.DTDValidatorOK.Label", (String[])new String[]{this.getXMLFilename()})});
                                retval = true;
                            } else {
                                this.setNrErrors(error.nrErrors);
                                this.setErrorMessage(BaseMessages.getString(PKG, (String)"JobEntryDTDValidator.DTDValidatorKO", (Object[])new Object[]{this.getXMLFilename(), error.nrErrors, error.errorMessage}));
                            }
                        }
                        break block36;
                    }
                    if (!xmlfile.exists()) {
                        this.setErrorMessage(BaseMessages.getString(PKG, (String)"JobEntryDTDValidator.FileDoesNotExist.Label", (String[])new String[]{this.getXMLFilename()}));
                    }
                    break block36;
                }
                this.setErrorMessage(BaseMessages.getString(PKG, (String)"JobEntryDTDValidator.AllFilesNotNull.Label", (String[])new String[0]));
            }
            Object var18_22 = null;
            try {
                if (xmlfile != null) {
                    xmlfile.close();
                }
                if (DTDfile != null) {
                    DTDfile.close();
                }
                if (ba != null) {
                    ba.close();
                }
                break block37;
            }
            catch (IOException e2) {}
            break block37;
            {
                catch (Exception e) {
                    this.setErrorMessage(BaseMessages.getString(PKG, (String)"JobEntryDTDValidator.ErrorDTDValidator.Label", (String[])new String[]{this.getXMLFilename(), this.getDTDFilename(), e.getMessage()}));
                    Object var18_23 = null;
                    try {
                        if (xmlfile != null) {
                            xmlfile.close();
                        }
                        if (DTDfile != null) {
                            DTDfile.close();
                        }
                        if (ba != null) {
                            ba.close();
                        }
                        break block37;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var18_24 = null;
                try {
                    if (xmlfile != null) {
                        xmlfile.close();
                    }
                    if (DTDfile != null) {
                        DTDfile.close();
                    }
                    if (ba != null) {
                        ba.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return retval;
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        String errorMessage = null;
        int error = -1;
        int nrErrors = 0;

        private MyErrorHandler() {
        }

        public void warning(SAXParseException e) throws SAXException {
            this.error = 0;
            this.allErrors(e);
        }

        public void error(SAXParseException e) throws SAXException {
            this.error = 1;
            this.allErrors(e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            this.error = 2;
            this.allErrors(e);
        }

        private void allErrors(SAXParseException e) {
            ++this.nrErrors;
            if (this.errorMessage == null) {
                this.errorMessage = "";
            }
            this.errorMessage = this.errorMessage + Const.CR + Const.CR + "Error Nr." + this.nrErrors + " (";
            switch (this.error) {
                case 0: {
                    this.errorMessage = this.errorMessage + "Warning";
                    break;
                }
                case 1: {
                    this.errorMessage = this.errorMessage + "Error";
                    break;
                }
                case 2: {
                    this.errorMessage = this.errorMessage + "FatalError";
                    break;
                }
            }
            this.errorMessage = this.errorMessage + ")" + Const.CR + "              Public ID: " + e.getPublicId() + Const.CR + "              System ID: " + e.getSystemId() + Const.CR + "              Line number: " + e.getLineNumber() + Const.CR + "              Column number: " + e.getColumnNumber() + Const.CR + "              Message: " + e.getMessage();
        }
    }
}

