/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.ftp;

import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.pentaho.di.i18n.BaseMessages;

public class MVSFileParser
extends FTPFileParser {
    private static Class<?> PKG = MVSFileParser.class;
    private static Logger log4j = Logger.getLogger(MVSFileParser.class);
    private static final String PARSER_KEY = "MVS";
    private static final String HEADER_VOLUME = "Volume";
    private static final String HEADER_NAME = "Name";
    private static final String LINE_TYPE_ARCIVE = "ARCIVE";
    private static final String ENTRY_FILE_TYPE = "PS";
    private static final String LINE_TYPE_MIGRATED = "Migrated";
    private static final int FOLDER_HEADER_TYPE_IDX = 0;
    private static final int FOLDER_LISTING_LENGTH_NORMAL = 10;
    private static final int FOLDER_LISTING_LENGTH_ARCIVE = 8;
    private String dateFormatString;
    private String alternateFormatString;
    private SimpleDateFormat dateFormat;
    private SimpleDateFormat dateTimeFormat;
    private boolean partitionedDataset = false;

    public boolean isValidFormat(String[] listing) {
        String[] header;
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.DEBUG.Checking.Parser", (String[])new String[0]));
        }
        if (listing.length > 0 && ((header = this.splitMVSLine(listing[0])).length == 10 || header.length == 8)) {
            if (header[0].equals(HEADER_VOLUME)) {
                this.partitionedDataset = false;
                if (log4j.isInfoEnabled()) {
                    log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.INFO.Detected.Dir", (String[])new String[0]));
                }
                return this.isValidDirectoryFormat(listing);
            }
            if (header[0].equals(HEADER_NAME)) {
                this.partitionedDataset = true;
                if (log4j.isInfoEnabled()) {
                    log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.INFO.Detected.PDS", (String[])new String[0]));
                }
                return this.isValidPDSFormat(listing);
            }
        }
        return false;
    }

    public FTPFile parse(String raw) throws ParseException {
        String[] aLine = this.splitMVSLine(raw);
        FTPFile rtn = null;
        rtn = this.partitionedDataset ? this.parsePDSLine(aLine, raw) : this.parseFolder(aLine, raw);
        return rtn;
    }

    public void setLocale(Locale arg0) {
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.DEBUG.Ignore.Locale", (String[])new String[0]));
        }
    }

    public String toString() {
        return PARSER_KEY;
    }

    protected FTPFile parsePDSLine(String[] aLine, String raw) throws ParseException {
        FTPFile rtn = null;
        if (aLine[0].equals(HEADER_NAME)) {
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.DEBUG.Skip.Header", (String[])new String[0]));
            }
            return null;
        }
        rtn = new FTPFile(raw);
        rtn.setName(aLine[0]);
        if (this.dateTimeFormat == null) {
            this.dateTimeFormat = new SimpleDateFormat(this.dateFormatString + " HH:mm");
        }
        rtn.setCreated(this.dateFormat.parse(aLine[2]));
        String modDateTime = aLine[3] + ' ' + aLine[4];
        rtn.setLastModified(this.dateTimeFormat.parse(modDateTime));
        rtn.setDir(false);
        return rtn;
    }

    protected FTPFile parseFolder(String[] aLine, String raw) {
        if (aLine[0].equals(HEADER_VOLUME)) {
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.DEBUG.Skip.Header", (String[])new String[0]));
            }
            return null;
        }
        if (aLine[0].equals(LINE_TYPE_ARCIVE)) {
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.DEBUG.Skip.ARCIVE", (String[])new String[0]));
            }
            return null;
        }
        if (aLine[0].equals(LINE_TYPE_MIGRATED)) {
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.DEBUG.Skip.Migrated", (String[])new String[0]));
            }
            return null;
        }
        if (aLine[5].charAt(0) != 'F' && aLine[5].charAt(0) != 'V') {
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.DEBUG.Skip.recf", (String[])new String[0]));
            }
            return null;
        }
        if (aLine[8].charAt(0) != 'P') {
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.DEBUG.Skip.dso", (String[])new String[0]));
            }
            return null;
        }
        FTPFile rtn = new FTPFile(raw);
        rtn.setName(aLine[9]);
        rtn.setCreated(new Date());
        rtn.setLastModified(new Date());
        if (aLine[8].equals(ENTRY_FILE_TYPE)) {
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.DEBUG.Found.File", (String[])new String[]{aLine[9]}));
            }
            rtn.setDir(false);
            long l = -1L;
            try {
                l = Long.parseLong(aLine[4]);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            rtn.setSize(l);
        } else {
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.DEBUG.Found.Folder", (String[])new String[]{aLine[9]}));
            }
            rtn.setDir(true);
        }
        return rtn;
    }

    protected String[] splitMVSLine(String raw) {
        if (raw == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(raw);
        String[] rtn = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            rtn[i] = nextToken.trim();
            ++i;
        }
        return rtn;
    }

    protected boolean isValidDirectoryFormat(String[] listing) {
        for (int i = 1; i < listing.length; ++i) {
            String[] aLine = this.splitMVSLine(listing[i]);
            if (aLine.length == 2 && aLine[0].equals(LINE_TYPE_MIGRATED)) {
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.DEBUG.Detected.Migrated", (String[])new String[0]));
                }
            } else if (aLine.length != 10 && !aLine[0].equals(LINE_TYPE_ARCIVE)) {
                log4j.error((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.ERROR.Invalid.Folder.Line", (String[])new String[]{listing[i]}));
                return false;
            }
            if (this.dateFormatString != null) {
                if (this.checkDateFormat(aLine[2])) continue;
                return false;
            }
            if (aLine.length != 10) continue;
            this.guessDateFormat(aLine[2]);
        }
        return true;
    }

    protected boolean isValidPDSFormat(String[] listing) {
        for (int i = 1; i < listing.length; ++i) {
            String[] aLine = this.splitMVSLine(listing[i]);
            if (aLine.length != 9) {
                log4j.error((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.ERROR.Invalid.PDS.Line", (String[])new String[]{listing[i]}));
                return false;
            }
            if (this.dateFormatString != null) {
                if (this.checkDateFormat(aLine[3])) continue;
                return false;
            }
            this.guessDateFormat(aLine[2]);
        }
        return true;
    }

    protected boolean checkDateFormat(String dateStr) {
        try {
            this.dateFormat.parse(dateStr);
        }
        catch (ParseException ex) {
            if (log4j.isDebugEnabled() && log4j.isDebugEnabled()) {
                log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.DEBUG.Date.Parse.Error", (String[])new String[0]));
            }
            if (this.alternateFormatString != null) {
                if (log4j.isDebugEnabled() && log4j.isDebugEnabled()) {
                    log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.DEBUG.Date.Parse.Choose.Alt", (String[])new String[0]));
                }
                this.dateFormatString = this.alternateFormatString;
                this.dateFormat = new SimpleDateFormat(this.dateFormatString);
                this.alternateFormatString = null;
                try {
                    this.dateFormat.parse(dateStr);
                }
                catch (ParseException ex2) {
                    return false;
                }
            }
            log4j.error((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.ERROR.Date.Parse.Fail", (String[])new String[]{dateStr}));
            return false;
        }
        return true;
    }

    protected void guessDateFormat(String dateStr) {
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.DEBUG.Guess.Date", (String[])new String[0]));
        }
        String[] dateSplit = dateStr.split("/");
        String yrFmt = null;
        int yrPos = -1;
        int dayPos = -1;
        for (int i = 0; i < dateSplit.length; ++i) {
            int aDigit = Integer.parseInt(dateSplit[i]);
            if (dateSplit[i].length() == 4) {
                yrFmt = "yyyy";
                yrPos = i;
                continue;
            }
            if (aDigit > 31) {
                yrFmt = "yy";
                yrPos = i;
                continue;
            }
            if (aDigit <= 12) continue;
            dayPos = i;
        }
        if (yrFmt != null) {
            StringBuffer fmt = new StringBuffer();
            if (dayPos >= 0) {
                String[] tmp = new String[3];
                tmp[yrPos] = yrFmt;
                tmp[dayPos] = "dd";
                for (int i = 0; i < tmp.length; ++i) {
                    fmt.append(i > 0 ? "/" : "");
                    fmt.append(tmp[i] == null ? "MM" : tmp[i]);
                }
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.DEBUG.Guess.Date.Obvious", (String[])new String[0]));
                }
            } else {
                StringBuffer altFmt = new StringBuffer();
                if (yrPos == 0) {
                    fmt.append(yrFmt).append("/MM/dd");
                    altFmt.append(yrFmt).append("/dd/MM");
                } else {
                    fmt.append("MM/dd/").append(yrFmt);
                    altFmt.append("dd/MM/").append(yrFmt);
                }
                this.alternateFormatString = altFmt.toString();
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.DEBUG.Guess.Date.Ambiguous", (String[])new String[0]));
                }
            }
            this.dateFormatString = fmt.toString();
            this.dateFormat = new SimpleDateFormat(this.dateFormatString);
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.DEBUG.Guess.Date.Decided", (String[])new String[]{this.dateFormatString}));
            }
            try {
                this.dateFormat.parse(dateStr);
            }
            catch (ParseException ex) {
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.DEBUG.Guess.Date.Unparsable", (String[])new String[]{dateStr}));
                }
            }
        } else {
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)BaseMessages.getString(PKG, (String)"MVSFileParser.DEBUG.Guess.Date.Year.Ambiguous", (String[])new String[0]));
            }
            return;
        }
    }

    public boolean isPartitionedDataset() {
        return this.partitionedDataset;
    }

    public String getDateFormatString() {
        return this.dateFormatString;
    }

    public void setDateFormatString(String value) {
        this.dateFormatString = value;
    }
}

