/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.ftpsget;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.vfs.FileObject;
import org.ftp4che.FTPConnection;
import org.ftp4che.FTPConnectionFactory;
import org.ftp4che.event.FTPEvent;
import org.ftp4che.event.FTPListener;
import org.ftp4che.util.ftpfile.FTPFile;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.ftpsget.JobEntryFTPSGet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTPSConnection
implements FTPListener {
    private static Class<?> PKG = JobEntryFTPSGet.class;
    public static final String HOME_FOLDER = "/";
    public static final String COMMAND_SUCCESSUL = "COMMAND SUCCESSFUL";
    public static final int CONNECTION_TYPE_FTP = 0;
    public static final int CONNECTION_TYPE_FTP_IMPLICIT_SSL = 1;
    public static final int CONNECTION_TYPE_FTP_AUTH_SSL = 2;
    public static final int CONNECTION_TYPE_FTP_IMPLICIT_SSL_WITH_CRYPTED = 3;
    public static final int CONNECTION_TYPE_FTP_AUTH_TLS = 4;
    public static final int CONNECTION_TYPE_FTP_IMPLICIT_TLS = 5;
    public static final int CONNECTION_TYPE_FTP_IMPLICIT_TLS_WITH_CRYPTED = 6;
    public static final String[] connection_type_Desc = new String[]{BaseMessages.getString(PKG, (String)"JobFTPS.ConnectionType.FTP", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobFTPS.ConnectionType.ImplicitSSL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobFTPS.ConnectionType.AuthSSL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobFTPS.ConnectionType.ImplicitSSLCrypted", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobFTPS.ConnectionType.AuthTLS", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobFTPS.ConnectionType.ImplicitTLS", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobFTPS.ConnectionType.ImplicitTLSCrypted", (String[])new String[0])};
    public static final String[] connection_type_Code = new String[]{"FTP_CONNECTION", "IMPLICIT_SSL_FTP_CONNECTION", "AUTH_SSL_FTP_CONNECTION", "IMPLICIT_SSL_WITH_CRYPTED_DATA_FTP_CONNECTION", "AUTH_TLS_FTP_CONNECTION", "IMPLICIT_TLS_FTP_CONNECTION", "IMPLICIT_TLS_WITH_CRYPTED_DATA_FTP_CONNECTION"};
    private FTPConnection connection = null;
    private ArrayList<String> replies = new ArrayList();
    private String hostName;
    private int portNumber;
    private String userName;
    private String passWord;
    private int connectionType;
    private int timeOut;
    private boolean passiveMode;
    private String proxyHost;
    private String proxyUser;
    private String proxyPassword;
    private int proxyPort;

    public FTPSConnection(int connectionType, String hostname, int port, String username, String password) {
        this.hostName = hostname;
        this.portNumber = port;
        this.userName = username;
        this.passWord = password;
        this.connectionType = connectionType;
        this.passiveMode = false;
    }

    public void setProxyHost(String proxyhost) {
        this.proxyHost = proxyhost;
    }

    public void setProxyPort(int proxyport) {
        this.proxyPort = proxyport;
    }

    public void setProxyUser(String username) {
        this.proxyUser = username;
    }

    public void setProxyPassword(String password) {
        this.proxyPassword = password;
    }

    public void connect() throws KettleException {
        try {
            this.connection = FTPConnectionFactory.getInstance((Properties)this.getProperties(this.hostName, this.portNumber, this.userName, this.passWord, this.connectionType, this.timeOut, this.passiveMode));
            this.connection.addFTPStatusListener((FTPListener)this);
            this.connection.connect();
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobFTPS.Error.Connecting", (String[])new String[]{this.hostName}), (Throwable)e);
        }
    }

    private Properties getProperties(String hostname, int port, String username, String password, int connectionType, int timeout, boolean passiveMode) {
        Properties pt = new Properties();
        pt.setProperty("connection.host", hostname);
        pt.setProperty("connection.port", String.valueOf(port));
        pt.setProperty("user.login", username);
        pt.setProperty("user.password", password);
        pt.setProperty("connection.type", FTPSConnection.getConnectionType(connectionType));
        pt.setProperty("connection.timeout", String.valueOf(timeout));
        pt.setProperty("connection.passive", String.valueOf(passiveMode));
        if (this.proxyHost != null) {
            pt.setProperty("proxy.host", this.proxyHost);
        }
        if (this.proxyPort != 0) {
            pt.setProperty("proxy.port", String.valueOf(this.proxyPort));
        }
        if (this.proxyUser != null) {
            pt.setProperty("proxy.user", this.proxyUser);
        }
        if (this.proxyPassword != null) {
            pt.setProperty("proxy.pass", this.proxyPassword);
        }
        return pt;
    }

    public static String getConnectionTypeDesc(String tt) {
        if (Const.isEmpty((String)tt)) {
            return connection_type_Desc[0];
        }
        if (tt.equalsIgnoreCase(connection_type_Code[1])) {
            return connection_type_Desc[1];
        }
        return connection_type_Desc[0];
    }

    public static String getConnectionTypeCode(String tt) {
        if (tt == null) {
            return connection_type_Code[0];
        }
        if (tt.equals(connection_type_Desc[1])) {
            return connection_type_Code[1];
        }
        return connection_type_Code[0];
    }

    public static String getConnectionTypeDesc(int i) {
        if (i < 0 || i >= connection_type_Desc.length) {
            return connection_type_Desc[0];
        }
        return connection_type_Desc[i];
    }

    public static String getConnectionType(int i) {
        return connection_type_Code[i];
    }

    public static int getConnectionTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < connection_type_Desc.length; ++i) {
            if (!connection_type_Desc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static int getConnectionTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < connection_type_Code.length; ++i) {
            if (!connection_type_Code[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static String getConnectionTypeCode(int i) {
        if (i < 0 || i >= connection_type_Code.length) {
            return connection_type_Code[0];
        }
        return connection_type_Code[i];
    }

    public void setBinaryMode(boolean type) throws KettleException {
        try {
            this.connection.setTransferType(true);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void setPassiveMode(boolean passivemode) {
        this.passiveMode = passivemode;
    }

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    public void setTimeOut(int timeout) {
        this.timeOut = timeout;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public ArrayList<String> getReplies() {
        return this.replies;
    }

    public void setConnectionType(int connectiontype) {
        this.connectionType = connectiontype;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public void connectionStatusChanged(FTPEvent arg0) {
    }

    public void replyMessageArrived(FTPEvent event) {
        this.replies = new ArrayList();
        for (String e : event.getReply().getLines()) {
            if (e.trim().equals("") || (e = e.substring(3).trim().replace("\n", "")).toUpperCase().contains(COMMAND_SUCCESSUL)) continue;
            e = e.substring(1).trim();
            this.replies.add(e);
        }
    }

    public void changeDirectory(String directory) throws KettleException {
        try {
            this.connection.changeDirectory(directory);
        }
        catch (Exception f) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobFTPS.Error.ChangingFolder", (String[])new String[]{directory}), (Throwable)f);
        }
    }

    public void createDirectory(String directory) throws KettleException {
        try {
            this.connection.makeDirectory(directory);
        }
        catch (Exception f) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobFTPS.Error.CreationFolder", (String[])new String[]{directory}), (Throwable)f);
        }
    }

    public List<FTPFile> getFileList(String folder) throws KettleException {
        try {
            if (this.connection != null) {
                List response = this.connection.getDirectoryListing(folder);
                return response;
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void downloadFile(FTPFile file, String localFilename) throws KettleException {
        try {
            File localFile = new File(localFilename);
            this.writeToFile(this.connection.downloadStream(file), localFile);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    private void writeToFile(InputStream is, File file) throws KettleException {
        try {
            int c;
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            while ((c = is.read()) != -1) {
                out.writeByte(c);
            }
            is.close();
            out.close();
        }
        catch (IOException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobFTPS.Error.WritingToFile", (String[])new String[]{file.getName()}), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void uploadFile(String localFileName, String shortFileName) throws KettleException {
        FileObject file = null;
        try {
            try {
                file = KettleVFS.getFileObject((String)localFileName);
                this.connection.uploadStream(file.getContent().getInputStream(), new FTPFile(new File(shortFileName)));
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"JobFTPS.Error.UuploadingFile", (String[])new String[]{localFileName}), (Throwable)e);
            }
            Object var6_4 = null;
            if (file == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (file == null) throw throwable;
            try {
                file.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        file.close();
        return;
    }

    public String[] getFileNames() throws KettleException {
        ArrayList<String> list = null;
        try {
            List<FTPFile> fileList = this.getFileList(this.getWorkingDirectory());
            list = new ArrayList<String>();
            for (FTPFile file : fileList) {
                if (file.isDirectory()) continue;
                list.add(file.getName());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobFTPS.Error.RetrievingFilenames", (String[])new String[0]), (Throwable)e);
        }
        return list == null ? null : list.toArray(new String[list.size()]);
    }

    public void deleteFile(FTPFile file) throws KettleException {
        try {
            this.connection.deleteFile(file);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobFTPS.Error.DeletingFile", (String[])new String[]{file.getName()}), (Throwable)e);
        }
    }

    public void deleteFile(String filename) throws KettleException {
        try {
            this.connection.deleteFile(new FTPFile(this.getWorkingDirectory(), filename));
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobFTPS.Error.DeletingFile", (String[])new String[]{filename}), (Throwable)e);
        }
    }

    public void moveToFolder(FTPFile fromFile, String targetFoldername) throws KettleException {
        try {
            this.connection.renameFile(fromFile, new FTPFile(targetFoldername, fromFile.getName()));
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobFTPS.Error.MovingFileToFolder", (String[])new String[]{fromFile.getName(), targetFoldername}), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDirectoryExists(String directory) {
        String currectDirectory = null;
        boolean retval = false;
        currectDirectory = this.connection.getWorkDirectory();
        this.connection.changeDirectory(directory);
        retval = true;
        Object var6_4 = null;
        if (currectDirectory == null) return retval;
        try {
            this.connection.changeDirectory(currectDirectory);
            return retval;
        }
        catch (Exception e2) {}
        return retval;
        {
            catch (Exception e) {
                Object var6_5 = null;
                if (currectDirectory == null) return retval;
                try {
                    this.connection.changeDirectory(currectDirectory);
                    return retval;
                }
                catch (Exception e2) {}
                return retval;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (currectDirectory == null) throw throwable;
            try {
                this.connection.changeDirectory(currectDirectory);
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public boolean isFileExists(String filename) {
        boolean retval = false;
        try {
            FTPFile file = new FTPFile(new File(filename));
            this.connection.getModificationTime(file);
            retval = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public String getWorkingDirectory() throws Exception {
        return this.connection.getWorkDirectory();
    }

    public void disconnect() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
        if (this.replies != null) {
            this.replies.clear();
        }
    }
}

