/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.sftpput;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.sftp.SFTPClient;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntrySFTPPUT
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntrySFTPPUT.class;
    private int afterFTPS = 0;
    public static final String[] afterFTPSDesc = new String[]{BaseMessages.getString(PKG, (String)"JobSFTPPUT.AfterSFTP.DoNothing.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSFTPPUT.AfterSFTP.Delete.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSFTPPUT.AfterSFTP.Move.Label", (String[])new String[0])};
    public static final String[] afterFTPSCode = new String[]{"nothing", "delete", "move"};
    public static final int AFTER_FTPSPUT_NOTHING = 0;
    public static final int AFTER_FTPSPUT_DELETE = 1;
    public static final int AFTER_FTPSPUT_MOVE = 2;
    private String serverName = null;
    private String serverPort = "22";
    private String userName;
    private String password;
    private String sftpDirectory;
    private String localDirectory;
    private String wildcard;
    private boolean copyprevious = false;
    private boolean addFilenameResut = false;
    private boolean usekeyfilename = false;
    private String keyfilename = null;
    private String keyfilepass = null;
    private String compression = "none";
    private boolean createRemoteFolder = false;
    private String proxyType = null;
    private String proxyHost = null;
    private String proxyPort = null;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private String destinationfolder = null;
    private boolean createDestinationFolder = false;
    private boolean successWhenNoFile = false;

    public JobEntrySFTPPUT(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntrySFTPPUT() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntrySFTPPUT je = (JobEntrySFTPPUT)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"serverport", (String)this.serverPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sftpdirectory", (String)this.sftpDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"localdirectory", (String)this.localDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"copyprevious", (boolean)this.copyprevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addFilenameResut", (boolean)this.addFilenameResut));
        retval.append("      ").append(XMLHandler.addTagValue((String)"usekeyfilename", (boolean)this.usekeyfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"keyfilename", (String)this.keyfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"keyfilepass", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.keyfilepass)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"compression", (String)this.compression));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxyType", (String)this.proxyType));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxyHost", (String)this.proxyHost));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxyPort", (String)this.proxyPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxyUsername", (String)this.proxyUsername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxyPassword", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createRemoteFolder", (boolean)this.createRemoteFolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"aftersftpput", (String)JobEntrySFTPPUT.getAfterSFTPPutCode(this.getAfterFTPS())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destinationfolder", (String)this.destinationfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createdestinationfolder", (boolean)this.createDestinationFolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"successWhenNoFile", (boolean)this.successWhenNoFile));
        return retval.toString();
    }

    private static String getAfterSFTPPutCode(int i) {
        if (i < 0 || i >= afterFTPSCode.length) {
            return afterFTPSCode[0];
        }
        return afterFTPSCode[i];
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.serverName = XMLHandler.getTagValue((Node)entrynode, (String)"servername");
            this.serverPort = XMLHandler.getTagValue((Node)entrynode, (String)"serverport");
            this.userName = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.sftpDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"sftpdirectory");
            this.localDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"localdirectory");
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.copyprevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"copyprevious"));
            this.addFilenameResut = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addFilenameResut"));
            this.usekeyfilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"usekeyfilename"));
            this.keyfilename = XMLHandler.getTagValue((Node)entrynode, (String)"keyfilename");
            this.keyfilepass = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"keyfilepass"));
            this.compression = XMLHandler.getTagValue((Node)entrynode, (String)"compression");
            this.proxyType = XMLHandler.getTagValue((Node)entrynode, (String)"proxyType");
            this.proxyHost = XMLHandler.getTagValue((Node)entrynode, (String)"proxyHost");
            this.proxyPort = XMLHandler.getTagValue((Node)entrynode, (String)"proxyPort");
            this.proxyUsername = XMLHandler.getTagValue((Node)entrynode, (String)"proxyUsername");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"proxyPassword"));
            this.createRemoteFolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createRemoteFolder"));
            boolean remove = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"remove"));
            this.setAfterFTPS(JobEntrySFTPPUT.getAfterSFTPPutByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"aftersftpput"), (String)"")));
            if (remove && this.getAfterFTPS() == 0) {
                this.setAfterFTPS(1);
            }
            this.destinationfolder = XMLHandler.getTagValue((Node)entrynode, (String)"destinationfolder");
            this.createDestinationFolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createdestinationfolder"));
            this.successWhenNoFile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"successWhenNoFile"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'SFTPPUT' from XML node", (Throwable)xe);
        }
    }

    private static int getAfterSFTPPutByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < afterFTPSCode.length; ++i) {
            if (!afterFTPSCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static String getAfterSFTPPutDesc(int i) {
        if (i < 0 || i >= afterFTPSDesc.length) {
            return afterFTPSDesc[0];
        }
        return afterFTPSDesc[i];
    }

    public static int getAfterSFTPPutByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < afterFTPSDesc.length; ++i) {
            if (!afterFTPSDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntrySFTPPUT.getAfterSFTPPutByCode(tt);
    }

    @Override
    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.serverName = rep.getJobEntryAttributeString(id_jobentry, "servername");
            this.serverPort = rep.getJobEntryAttributeString(id_jobentry, "serverport");
            this.userName = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.sftpDirectory = rep.getJobEntryAttributeString(id_jobentry, "sftpdirectory");
            this.localDirectory = rep.getJobEntryAttributeString(id_jobentry, "localdirectory");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.copyprevious = rep.getJobEntryAttributeBoolean(id_jobentry, "copyprevious");
            this.addFilenameResut = rep.getJobEntryAttributeBoolean(id_jobentry, "addFilenameResut");
            this.usekeyfilename = rep.getJobEntryAttributeBoolean(id_jobentry, "usekeyfilename");
            this.keyfilename = rep.getJobEntryAttributeString(id_jobentry, "keyfilename");
            this.keyfilepass = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "keyfilepass"));
            this.compression = rep.getJobEntryAttributeString(id_jobentry, "compression");
            this.proxyType = rep.getJobEntryAttributeString(id_jobentry, "proxyType");
            this.proxyHost = rep.getJobEntryAttributeString(id_jobentry, "proxyHost");
            this.proxyPort = rep.getJobEntryAttributeString(id_jobentry, "proxyPort");
            this.proxyUsername = rep.getJobEntryAttributeString(id_jobentry, "proxyUsername");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "proxyPassword"));
            this.createRemoteFolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createRemoteFolder");
            boolean remove = rep.getJobEntryAttributeBoolean(id_jobentry, "remove");
            this.setAfterFTPS(JobEntrySFTPPUT.getAfterSFTPPutByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "aftersftpput"), (String)"")));
            if (remove && this.getAfterFTPS() == 0) {
                this.setAfterFTPS(1);
            }
            this.destinationfolder = rep.getJobEntryAttributeString(id_jobentry, "destinationfolder");
            this.createDestinationFolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createdestinationfolder");
            this.successWhenNoFile = rep.getJobEntryAttributeBoolean(id_jobentry, "successWhenNoFile");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'SFTPPUT' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "servername", this.serverName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "serverport", this.serverPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "username", this.userName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "sftpdirectory", this.sftpDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "localdirectory", this.localDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "copyprevious", this.copyprevious);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "addFilenameResut", this.addFilenameResut);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "usekeyfilename", this.usekeyfilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "keyfilename", this.keyfilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "keyfilepass", Encr.encryptPasswordIfNotUsingVariables((String)this.keyfilepass));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "compression", this.compression);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxyType", this.proxyType);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxyHost", this.proxyHost);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxyPort", this.proxyPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxyUsername", this.proxyUsername);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxyPassword", Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "aftersftpput", JobEntrySFTPPUT.getAfterSFTPPutCode(this.getAfterFTPS()));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "createRemoteFolder", this.createRemoteFolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "destinationfolder", this.destinationfolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "createdestinationfolder", this.createDestinationFolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "successWhenNoFile", this.successWhenNoFile);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'SFTPPUT' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void setCreateDestinationFolder(boolean createDestinationFolder) {
        this.createDestinationFolder = createDestinationFolder;
    }

    public boolean isCreateDestinationFolder() {
        return this.createDestinationFolder;
    }

    public void setSuccessWhenNoFile(boolean successWhenNoFile) {
        this.successWhenNoFile = successWhenNoFile;
    }

    public boolean isSuccessWhenNoFile() {
        return this.successWhenNoFile;
    }

    public void setDestinationFolder(String destinationfolderin) {
        this.destinationfolder = destinationfolderin;
    }

    public String getDestinationFolder() {
        return this.destinationfolder;
    }

    public int getAfterFTPS() {
        return this.afterFTPS;
    }

    public void setAfterFTPS(int value) {
        this.afterFTPS = value;
    }

    public String getScpDirectory() {
        return this.sftpDirectory;
    }

    public void setScpDirectory(String directory) {
        this.sftpDirectory = directory;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public String getLocalDirectory() {
        return this.localDirectory;
    }

    public void setLocalDirectory(String localDirectory) {
        this.localDirectory = localDirectory;
    }

    public boolean isCopyPrevious() {
        return this.copyprevious;
    }

    public void setCopyPrevious(boolean copyprevious) {
        this.copyprevious = copyprevious;
    }

    public boolean isAddFilenameResut() {
        return this.addFilenameResut;
    }

    public boolean isUseKeyFile() {
        return this.usekeyfilename;
    }

    public void setUseKeyFile(boolean value) {
        this.usekeyfilename = value;
    }

    public String getKeyFilename() {
        return this.keyfilename;
    }

    public void setKeyFilename(String value) {
        this.keyfilename = value;
    }

    public String getKeyPassPhrase() {
        return this.keyfilepass;
    }

    public void setKeyPassPhrase(String value) {
        this.keyfilepass = value;
    }

    public void setAddFilenameResut(boolean addFilenameResut) {
        this.addFilenameResut = addFilenameResut;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(String value) {
        this.proxyType = value;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String value) {
        this.proxyHost = value;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String value) {
        this.proxyPort = value;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String value) {
        this.proxyUsername = value;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String value) {
        this.proxyPassword = value;
    }

    public boolean isCreateRemoteFolder() {
        return this.createRemoteFolder;
    }

    public void setCreateRemoteFolder(boolean value) {
        this.createRemoteFolder = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result execute(Result previousResult, int nr) throws KettleException {
        block90: {
            block80: {
                block89: {
                    block79: {
                        block88: {
                            block78: {
                                block87: {
                                    block77: {
                                        block86: {
                                            block76: {
                                                block85: {
                                                    block75: {
                                                        result = previousResult;
                                                        rows = result.getRows();
                                                        result.setResult(false);
                                                        if (this.log.isDetailed()) {
                                                            this.logDetailed(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTPPUT.Log.StartJobEntry", (String[])new String[0]));
                                                        }
                                                        myFileList = new ArrayList<FileObject>();
                                                        if (this.copyprevious) {
                                                            if (rows.size() == 0) {
                                                                if (this.log.isDetailed()) {
                                                                    this.logDetailed(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTPPUT.ArgsFromPreviousNothing", (String[])new String[0]));
                                                                }
                                                                result.setResult(true);
                                                                return result;
                                                            }
                                                            try {
                                                                resultRow = null;
                                                                for (iteration = 0; iteration < rows.size(); ++iteration) {
                                                                    resultRow = (RowMetaAndData)rows.get(iteration);
                                                                    file_previous = resultRow.getString(0, null);
                                                                    if (Const.isEmpty((String)file_previous)) continue;
                                                                    file = KettleVFS.getFileObject((String)file_previous, (VariableSpace)this);
                                                                    if (!file.exists()) {
                                                                        this.logError(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTPPUT.Log.FilefromPreviousNotFound", (String[])new String[]{file_previous}));
                                                                        continue;
                                                                    }
                                                                    myFileList.add(file);
                                                                    if (!this.log.isDebug()) continue;
                                                                    this.logDebug(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTPPUT.Log.FilenameFromResult", (String[])new String[]{file_previous}));
                                                                }
                                                            }
                                                            catch (Exception e) {
                                                                this.logError(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTPPUT.Error.ArgFromPrevious", (String[])new String[0]));
                                                                result.setNrErrors(1L);
                                                                return result;
                                                            }
                                                        }
                                                        sftpclient = null;
                                                        realServerName = this.environmentSubstitute(this.serverName);
                                                        realServerPort = this.environmentSubstitute(this.serverPort);
                                                        realUsername = this.environmentSubstitute(this.userName);
                                                        realPassword = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.password));
                                                        realSftpDirString = this.environmentSubstitute(this.sftpDirectory);
                                                        realWildcard = this.environmentSubstitute(this.wildcard);
                                                        realLocalDirectory = this.environmentSubstitute(this.localDirectory);
                                                        realKeyFilename = null;
                                                        realPassPhrase = null;
                                                        realDestinationFolder = this.environmentSubstitute(this.getDestinationFolder());
                                                        try {
                                                            try {
                                                                block82: {
                                                                    if (this.getAfterFTPS() != 2) break block82;
                                                                    if (Const.isEmpty((String)realDestinationFolder)) {
                                                                        this.logError(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSSH2PUT.Log.DestinatFolderMissing", (String[])new String[0]));
                                                                        result.setNrErrors(1L);
                                                                        var17_19 = result;
                                                                        var30_22 = null;
                                                                        break block75;
                                                                    }
                                                                    folder = null;
                                                                    try {
                                                                        block83: {
                                                                            folder = KettleVFS.getFileObject((String)realDestinationFolder, (VariableSpace)this);
                                                                            if (folder.exists()) ** GOTO lbl-1000
                                                                            if (!this.createDestinationFolder) break block83;
                                                                            folder.createFolder();
                                                                            ** GOTO lbl-1000
                                                                        }
                                                                        this.logError(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSSH2PUT.Log.DestinatFolderNotExist", (String[])new String[]{realDestinationFolder}));
                                                                        result.setNrErrors(1L);
                                                                        var18_38 = result;
                                                                        var20_44 = null;
                                                                        if (folder == null) break block76;
                                                                    }
                                                                    catch (Exception e) {
                                                                        throw new KettleException((Throwable)e);
                                                                    }
                                                                    catch (Throwable var19_53) {
                                                                        var20_46 = null;
                                                                        if (folder == null) throw var19_53;
                                                                        try {
                                                                            folder.close();
                                                                            throw var19_53;
                                                                        }
                                                                        catch (Exception e) {
                                                                            // empty catch block
                                                                        }
                                                                        throw var19_53;
                                                                    }
                                                                    try {}
                                                                    catch (Exception e) {
                                                                        break block76;
                                                                    }
                                                                    folder.close();
                                                                    break block76;
lbl-1000:
                                                                    // 2 sources

                                                                    {
                                                                        realDestinationFolder = KettleVFS.getFilename((FileObject)folder);
                                                                    }
                                                                    var20_45 = null;
                                                                    if (folder != null) {
                                                                        try {}
                                                                        catch (Exception e) {}
                                                                        folder.close();
                                                                    }
                                                                }
                                                                if (this.isUseKeyFile()) {
                                                                    realKeyFilename = this.environmentSubstitute(this.getKeyFilename());
                                                                    if (Const.isEmpty((String)realKeyFilename)) {
                                                                        this.logError(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTP.Error.KeyFileMissing", (String[])new String[0]));
                                                                        result.setNrErrors(1L);
                                                                        folder = result;
                                                                        break block77;
                                                                    }
                                                                    if (!KettleVFS.fileExists((String)realKeyFilename)) {
                                                                        this.logError(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTP.Error.KeyFileNotFound", (String[])new String[0]));
                                                                        result.setNrErrors(1L);
                                                                        folder = result;
                                                                        break block78;
                                                                    }
                                                                    realPassPhrase = this.environmentSubstitute(this.getKeyPassPhrase());
                                                                }
                                                                sftpclient = new SFTPClient(InetAddress.getByName(realServerName), Const.toInt((String)realServerPort, (int)22), realUsername, realKeyFilename, realPassPhrase);
                                                                if (this.log.isDetailed()) {
                                                                    this.logDetailed(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTPPUT.Log.OpenedConnection", (String[])new String[]{realServerName, "" + realServerPort, realUsername}));
                                                                }
                                                                sftpclient.setCompression(this.getCompression());
                                                                realProxyHost = this.environmentSubstitute(this.getProxyHost());
                                                                if (!Const.isEmpty((String)realProxyHost)) {
                                                                    sftpclient.setProxy(realProxyHost, this.environmentSubstitute(this.getProxyPort()), this.environmentSubstitute(this.getProxyUsername()), this.environmentSubstitute(this.getProxyPassword()), this.getProxyType());
                                                                }
                                                                sftpclient.login(realPassword);
                                                                if (!Const.isEmpty((String)realSftpDirString)) {
                                                                    existfolder = sftpclient.folderExists(realSftpDirString);
                                                                    if (!existfolder) {
                                                                        if (!this.isCreateRemoteFolder()) {
                                                                            throw new KettleException(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTPPUT.Error.CanNotFindRemoteFolder", (String[])new String[]{realSftpDirString}));
                                                                        }
                                                                        if (this.log.isDetailed()) {
                                                                            this.logDetailed(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTPPUT.Error.CanNotFindRemoteFolder", (String[])new String[]{realSftpDirString}));
                                                                        }
                                                                        sftpclient.createFolder(realSftpDirString);
                                                                        if (this.log.isDetailed()) {
                                                                            this.logDetailed(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTPPUT.Log.RemoteFolderCreated", (String[])new String[]{realSftpDirString}));
                                                                        }
                                                                    }
                                                                    sftpclient.chdir(realSftpDirString);
                                                                    if (this.log.isDetailed()) {
                                                                        this.logDetailed(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTPPUT.Log.ChangedDirectory", (String[])new String[]{realSftpDirString}));
                                                                    }
                                                                }
                                                                if (!this.copyprevious) {
                                                                    myFileList = new ArrayList<E>();
                                                                    localFiles = KettleVFS.getFileObject((String)realLocalDirectory, (VariableSpace)this);
                                                                    children = localFiles.getChildren();
                                                                    if (children != null) {
                                                                        for (i = 0; i < children.length; ++i) {
                                                                            if (!children[i].getType().equals(FileType.FILE)) continue;
                                                                            myFileList.add(children[i]);
                                                                        }
                                                                    }
                                                                }
                                                                if (myFileList == null || myFileList.size() == 0) {
                                                                    if (!this.isSuccessWhenNoFile()) {
                                                                        this.logError(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTPPUT.Error.NoFileToSend", (String[])new String[0]));
                                                                        result.setNrErrors(1L);
                                                                        localFiles = result;
                                                                        break block79;
                                                                    }
                                                                    if (this.isBasic()) {
                                                                        this.logBasic(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTPPUT.Error.NoFileToSend", (String[])new String[0]));
                                                                    }
                                                                }
                                                                if (this.log.isDetailed()) {
                                                                    this.logDetailed(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTPPUT.Log.RowsFromPreviousResult", (Object[])new Object[]{myFileList.size()}));
                                                                }
                                                                pattern = null;
                                                                if (!this.copyprevious && !Const.isEmpty((String)realWildcard)) {
                                                                    pattern = Pattern.compile(realWildcard);
                                                                }
                                                                it = myFileList.iterator();
                                                                while (it.hasNext() && !this.parentJob.isStopped()) {
                                                                    myFile = (FileObject)it.next();
                                                                    try {
                                                                        localFilename = myFile.toString();
                                                                        destinationFilename = myFile.getName().getBaseName();
                                                                        getIt = true;
                                                                        if (pattern != null) {
                                                                            matcher = pattern.matcher(destinationFilename);
                                                                            getIt = matcher.matches();
                                                                        }
                                                                        if (getIt) {
                                                                            if (this.log.isDebug()) {
                                                                                this.logDebug(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTPPUT.Log.PuttingFile", (String[])new String[]{localFilename, realSftpDirString}));
                                                                            }
                                                                            sftpclient.put(myFile, destinationFilename);
                                                                            if (this.log.isDetailed()) {
                                                                                this.logDetailed(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTPPUT.Log.TransferedFile", (String[])new String[]{localFilename}));
                                                                            }
                                                                            switch (this.getAfterFTPS()) {
                                                                                case 1: {
                                                                                    myFile.delete();
                                                                                    if (!this.log.isDetailed()) break;
                                                                                    this.logDetailed(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTPPUT.Log.DeletedFile", (String[])new String[]{localFilename}));
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    destination = null;
                                                                                    try {
                                                                                        destination = KettleVFS.getFileObject((String)(realDestinationFolder + Const.FILE_SEPARATOR + myFile.getName().getBaseName()), (VariableSpace)this);
                                                                                        myFile.moveTo(destination);
                                                                                        if (this.log.isDetailed()) {
                                                                                            this.logDetailed(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTPPUT.Log.FileMoved", (Object[])new Object[]{myFile, destination}));
                                                                                        }
                                                                                        var26_60 = null;
                                                                                        if (destination == null) break;
                                                                                    }
                                                                                    catch (Throwable var25_59) {
                                                                                        var26_60 = null;
                                                                                        if (destination == null) throw var25_59;
                                                                                        destination.close();
                                                                                        throw var25_59;
                                                                                    }
                                                                                    destination.close();
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    if (!this.addFilenameResut) break;
                                                                                    resultFile = new ResultFile(0, myFile, this.parentJob.getJobname(), this.toString());
                                                                                    result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                                                                                    if (!this.log.isDetailed()) break;
                                                                                    this.logDetailed(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTPPUT.Log.FilenameAddedToResultFilenames", (String[])new String[]{localFilename}));
                                                                                }
                                                                            }
                                                                        }
                                                                        var28_61 = null;
                                                                        if (myFile == null) continue;
                                                                    }
                                                                    catch (Throwable var27_62) {
                                                                        var28_61 = null;
                                                                        if (myFile == null) throw var27_62;
                                                                        myFile.close();
                                                                        throw var27_62;
                                                                    }
                                                                    myFile.close();
                                                                }
                                                                result.setResult(true);
                                                                break block80;
                                                            }
                                                            catch (Exception e) {
                                                                result.setNrErrors(1L);
                                                                this.logError(BaseMessages.getString(JobEntrySFTPPUT.PKG, (String)"JobSFTPPUT.Exception", (String[])new String[]{e.getMessage()}));
                                                                this.logError(Const.getStackTracker((Throwable)e));
                                                                var30_28 = null;
                                                                try {
                                                                    if (sftpclient != null) {
                                                                        sftpclient.disconnect();
                                                                    }
                                                                }
                                                                catch (Exception e) {
                                                                    // empty catch block
                                                                }
                                                                myFileList = null;
                                                                return result;
                                                            }
                                                        }
                                                        catch (Throwable var29_63) {
                                                            block84: {
                                                                var30_29 = null;
                                                                ** try [egrp 9[TRYBLOCK] [25 : 1744->1757)] { 
lbl238:
                                                                // 1 sources

                                                                if (sftpclient != null) {
                                                                    sftpclient.disconnect();
                                                                }
                                                                break block84;
lbl241:
                                                                // 1 sources

                                                                catch (Exception e) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                            myFileList = null;
                                                            throw var29_63;
                                                        }
                                                    }
                                                    ** try [egrp 9[TRYBLOCK] [25 : 1744->1757)] { 
lbl248:
                                                    // 1 sources

                                                    if (sftpclient != null) {
                                                        sftpclient.disconnect();
                                                    }
                                                    break block85;
lbl251:
                                                    // 1 sources

                                                    catch (Exception e) {
                                                        // empty catch block
                                                    }
                                                }
                                                myFileList = null;
                                                return var17_19;
                                            }
                                            var30_23 = null;
                                            ** try [egrp 9[TRYBLOCK] [25 : 1744->1757)] { 
lbl259:
                                            // 1 sources

                                            if (sftpclient != null) {
                                                sftpclient.disconnect();
                                            }
                                            break block86;
lbl262:
                                            // 1 sources

                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                        }
                                        myFileList = null;
                                        return var18_38;
                                    }
                                    var30_24 = null;
                                    ** try [egrp 9[TRYBLOCK] [25 : 1744->1757)] { 
lbl270:
                                    // 1 sources

                                    if (sftpclient != null) {
                                        sftpclient.disconnect();
                                    }
                                    break block87;
lbl273:
                                    // 1 sources

                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                myFileList = null;
                                return folder;
                            }
                            var30_25 = null;
                            ** try [egrp 9[TRYBLOCK] [25 : 1744->1757)] { 
lbl281:
                            // 1 sources

                            if (sftpclient != null) {
                                sftpclient.disconnect();
                            }
                            break block88;
lbl284:
                            // 1 sources

                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        myFileList = null;
                        return folder;
                    }
                    var30_26 = null;
                    ** try [egrp 9[TRYBLOCK] [25 : 1744->1757)] { 
lbl292:
                    // 1 sources

                    if (sftpclient != null) {
                        sftpclient.disconnect();
                    }
                    break block89;
lbl295:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                }
                myFileList = null;
                return localFiles;
            }
            var30_27 = null;
            ** try [egrp 9[TRYBLOCK] [25 : 1744->1757)] { 
lbl303:
            // 1 sources

            if (sftpclient != null) {
                sftpclient.disconnect();
            }
            break block90;
lbl306:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
        }
        myFileList = null;
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.serverName)) {
            String realServerName = jobMeta.environmentSubstitute(this.serverName);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServerName, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "serverName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "localDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "userName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "password", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "serverPort", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }
}

