/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.talendjobexec;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.plugins.KettleURLClassLoader;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryTalendJobExec
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryTalendJobExec.class;
    private static Map<String, ClassLoader> classLoaderCache = new HashMap<String, ClassLoader>();
    private String filename;
    private String className;

    public JobEntryTalendJobExec(String n) {
        super(n, "");
        this.setID(-1L);
        this.filename = null;
    }

    public JobEntryTalendJobExec() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryTalendJobExec je = (JobEntryTalendJobExec)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"class_name", (String)this.className));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.filename = XMLHandler.getTagValue((Node)entrynode, (String)"filename");
            this.className = XMLHandler.getTagValue((Node)entrynode, (String)"class_name");
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryTalendJobExec.ERROR_0001_Cannot_Load_Job_Entry_From_Xml_Node", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "filename");
            this.className = rep.getJobEntryAttributeString(id_jobentry, "class_name");
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryTalendJobExec.ERROR_0002_Cannot_Load_Job_From_Repository", (Object[])new Object[]{id_jobentry}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "filename", this.filename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "class_name", this.className);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryTalendJobExec.ERROR_0003_Cannot_Save_Job_Entry", (Object[])new Object[]{id_job}), (Throwable)dbe);
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getRealFilename() {
        return this.environmentSubstitute(this.getFilename());
    }

    @Override
    public Result execute(Result previousResult, int nr) {
        Result result;
        block5: {
            result = previousResult;
            result.setResult(false);
            if (this.filename != null) {
                String realFilename = this.getRealFilename();
                try {
                    FileObject file = KettleVFS.getFileObject((String)realFilename, (VariableSpace)this);
                    if (file.exists() && file.isReadable()) {
                        result = this.executeTalenJob(file, result, nr);
                        break block5;
                    }
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryTalendJobExec.File_Does_Not_Exist", (String[])new String[]{realFilename}));
                }
                catch (Exception e) {
                    result.setNrErrors(1L);
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryTalendJobExec.ERROR_0004_IO_Exception", (String[])new String[]{e.getMessage()}), e);
                }
            } else {
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryTalendJobExec.ERROR_0005_No_Filename_Defined", (String[])new String[0]));
            }
        }
        return result;
    }

    private Result executeTalenJob(FileObject file, Result result, int nr) throws Exception {
        ClassLoader classLoader = null;
        try {
            classLoader = classLoaderCache.get(file.toString());
            if (classLoader == null) {
                final URL[] jarFiles = this.prepareJarFiles(file);
                classLoader = new KettleURLClassLoader(jarFiles, this.getClass().getClassLoader());
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        try {
                            JobEntryTalendJobExec.this.cleanupJarFiles(jarFiles);
                        }
                        catch (Exception e) {
                            System.err.println("Error cleaning up temporary Talend jar file extracts: " + Const.getStackTracker((Throwable)e));
                        }
                    }
                });
                classLoaderCache.put(file.toString(), classLoader);
            }
            Class<?> clazz = classLoader.loadClass(this.environmentSubstitute(this.getClassName()));
            Object jobObject = clazz.newInstance();
            Method runJob = clazz.getMethod("runJobInTOS", String[].class);
            int returnCode = (Integer)runJob.invoke(jobObject, new Object[]{new String[0]});
            result.setExitStatus(returnCode);
            result.setResult(true);
            result.setNrErrors(0L);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryTalendJobExec.ERROR_0006_ExceptionExecutingTalenJob", (String[])new String[0]), (Throwable)e);
        }
        return result;
    }

    private URL[] prepareJarFiles(FileObject zipFile) throws Exception {
        FileInputList fileList = FileInputList.createFileList((VariableSpace)this, (String[])new String[]{"zip:" + zipFile.toString()}, (String[])new String[]{".*\\.jar$"}, (String[])new String[]{".*classpath\\.jar$"}, (String[])new String[]{"Y"}, (boolean[])new boolean[]{true});
        ArrayList<URL> files = new ArrayList<URL>();
        for (FileObject file : fileList.getFiles()) {
            FileObject jarfilecopy = KettleVFS.createTempFile((String)file.getName().getBaseName(), (String)".jar", (String)this.environmentSubstitute("${java.io.tmpdir}"));
            jarfilecopy.copyFrom(file, (FileSelector)new AllFileSelector());
            files.add(jarfilecopy.getURL());
        }
        return files.toArray(new URL[files.size()]);
    }

    private void cleanupJarFiles(URL[] jarFiles) throws Exception {
        if (jarFiles == null) {
            return;
        }
        for (URL jarFile : jarFiles) {
            File file = new File(jarFile.toURI());
            file.delete();
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.filename)) {
            String realFileName = jobMeta.environmentSubstitute(this.filename);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        try {
            FileObject fileObject;
            if (!Const.isEmpty((String)this.filename) && (fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.filename), (VariableSpace)space)).exists()) {
                this.filename = resourceNamingInterface.nameResource(fileObject, space, true);
                return this.filename;
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

