/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.unzip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryUnZip
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryUnZip.class;
    private String zipFilename = null;
    public int afterunzip = 0;
    private String wildcard = null;
    private String wildcardexclude = null;
    private String targetdirectory = null;
    private String movetodirectory = null;
    private boolean addfiletoresult = false;
    private boolean isfromprevious = false;
    private boolean adddate = false;
    private boolean addtime = false;
    private boolean SpecifyFormat = false;
    private String date_time_format;
    private boolean rootzip = false;
    private boolean createfolder = false;
    private String nr_limit = "10";
    private String wildcardSource = null;
    private int iffileexist = 0;
    private boolean createMoveToDirectory = false;
    private boolean addOriginalTimestamp = false;
    private boolean setOriginalModificationDate = false;
    public String SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED = "success_when_at_least";
    public String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    private String success_condition = this.SUCCESS_IF_NO_ERRORS;
    public static final int IF_FILE_EXISTS_SKIP = 0;
    public static final int IF_FILE_EXISTS_OVERWRITE = 1;
    public static final int IF_FILE_EXISTS_UNIQ = 2;
    public static final int IF_FILE_EXISTS_FAIL = 3;
    public static final int IF_FILE_EXISTS_OVERWRITE_DIFF_SIZE = 4;
    public static final int IF_FILE_EXISTS_OVERWRITE_EQUAL_SIZE = 5;
    public static final int IF_FILE_EXISTS_OVERWRITE_ZIP_BIG = 6;
    public static final int IF_FILE_EXISTS_OVERWRITE_ZIP_BIG_EQUAL = 7;
    public static final int IF_FILE_EXISTS_OVERWRITE_ZIP_SMALL = 8;
    public static final int IF_FILE_EXISTS_OVERWRITE_ZIP_SMALL_EQUAL = 9;
    public static final String[] typeIfFileExistsCode = new String[]{"SKIP", "OVERWRITE", "UNIQ", "FAIL", "OVERWRITE_DIFF_SIZE", "OVERWRITE_EQUAL_SIZE", "OVERWRITE_ZIP_BIG", "OVERWRITE_ZIP_BIG_EQUAL", "OVERWRITE_ZIP_BIG_SMALL", "OVERWRITE_ZIP_BIG_SMALL_EQUAL"};
    public static final String[] typeIfFileExistsDesc = new String[]{BaseMessages.getString(PKG, (String)"JobUnZip.Skip.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobUnZip.Overwrite.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobUnZip.Give_Unique_Name.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobUnZip.Fail.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobUnZip.OverwriteIfSizeDifferent.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobUnZip.OverwriteIfSizeEquals.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobUnZip.OverwriteIfZipBigger.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobUnZip.OverwriteIfZipBiggerOrEqual.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobUnZip.OverwriteIfZipSmaller.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobUnZip.OverwriteIfZipSmallerOrEqual.Label", (String[])new String[0])};
    private int NrErrors = 0;
    private int NrSuccess = 0;
    boolean successConditionBroken = false;
    boolean successConditionBrokenExit = false;
    int limitFiles = 0;
    private static SimpleDateFormat daf;
    private boolean dateFormatSet = false;

    public JobEntryUnZip(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryUnZip() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryUnZip je = (JobEntryUnZip)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"zipfilename", (String)this.zipFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcardexclude", (String)this.wildcardexclude));
        retval.append("      ").append(XMLHandler.addTagValue((String)"targetdirectory", (String)this.targetdirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"movetodirectory", (String)this.movetodirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"afterunzip", (int)this.afterunzip));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addfiletoresult", (boolean)this.addfiletoresult));
        retval.append("      ").append(XMLHandler.addTagValue((String)"isfromprevious", (boolean)this.isfromprevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"adddate", (boolean)this.adddate));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addtime", (boolean)this.addtime));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addOriginalTimestamp", (boolean)this.addOriginalTimestamp));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyFormat", (boolean)this.SpecifyFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_format", (String)this.date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"rootzip", (boolean)this.rootzip));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createfolder", (boolean)this.createfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_limit", (String)this.nr_limit));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcardSource", (String)this.wildcardSource));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)this.success_condition));
        retval.append("      ").append(XMLHandler.addTagValue((String)"iffileexists", (String)JobEntryUnZip.getIfFileExistsCode(this.iffileexist)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"create_move_to_directory", (boolean)this.createMoveToDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"setOriginalModificationDate", (boolean)this.setOriginalModificationDate));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.zipFilename = XMLHandler.getTagValue((Node)entrynode, (String)"zipfilename");
            this.afterunzip = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"afterunzip"), (int)-1);
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.wildcardexclude = XMLHandler.getTagValue((Node)entrynode, (String)"wildcardexclude");
            this.targetdirectory = XMLHandler.getTagValue((Node)entrynode, (String)"targetdirectory");
            this.movetodirectory = XMLHandler.getTagValue((Node)entrynode, (String)"movetodirectory");
            this.addfiletoresult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addfiletoresult"));
            this.isfromprevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"isfromprevious"));
            this.adddate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"adddate"));
            this.addtime = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addtime"));
            this.addOriginalTimestamp = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addOriginalTimestamp"));
            this.SpecifyFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"SpecifyFormat"));
            this.date_time_format = XMLHandler.getTagValue((Node)entrynode, (String)"date_time_format");
            this.rootzip = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"rootzip"));
            this.createfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createfolder"));
            this.nr_limit = XMLHandler.getTagValue((Node)entrynode, (String)"nr_limit");
            this.wildcardSource = XMLHandler.getTagValue((Node)entrynode, (String)"wildcardSource");
            this.success_condition = XMLHandler.getTagValue((Node)entrynode, (String)"success_condition");
            if (Const.isEmpty((String)this.success_condition)) {
                this.success_condition = this.SUCCESS_IF_NO_ERRORS;
            }
            this.iffileexist = JobEntryUnZip.getIfFileExistsInt(XMLHandler.getTagValue((Node)entrynode, (String)"iffileexists"));
            this.createMoveToDirectory = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"create_move_to_directory"));
            this.setOriginalModificationDate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"setOriginalModificationDate"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'unzip' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.zipFilename = rep.getJobEntryAttributeString(id_jobentry, "zipfilename");
            this.afterunzip = (int)rep.getJobEntryAttributeInteger(id_jobentry, "afterunzip");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.wildcardexclude = rep.getJobEntryAttributeString(id_jobentry, "wildcardexclude");
            this.targetdirectory = rep.getJobEntryAttributeString(id_jobentry, "targetdirectory");
            this.movetodirectory = rep.getJobEntryAttributeString(id_jobentry, "movetodirectory");
            this.addfiletoresult = rep.getJobEntryAttributeBoolean(id_jobentry, "addfiletoresult");
            this.isfromprevious = rep.getJobEntryAttributeBoolean(id_jobentry, "isfromprevious");
            this.adddate = rep.getJobEntryAttributeBoolean(id_jobentry, "adddate");
            this.addtime = rep.getJobEntryAttributeBoolean(id_jobentry, "addtime");
            this.addOriginalTimestamp = rep.getJobEntryAttributeBoolean(id_jobentry, "addOriginalTimestamp");
            this.SpecifyFormat = rep.getJobEntryAttributeBoolean(id_jobentry, "SpecifyFormat");
            this.date_time_format = rep.getJobEntryAttributeString(id_jobentry, "date_time_format");
            this.rootzip = rep.getJobEntryAttributeBoolean(id_jobentry, "rootzip");
            this.createfolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createfolder");
            this.nr_limit = rep.getJobEntryAttributeString(id_jobentry, "nr_limit");
            this.wildcardSource = rep.getJobEntryAttributeString(id_jobentry, "wildcardSource");
            this.success_condition = rep.getJobEntryAttributeString(id_jobentry, "success_condition");
            if (Const.isEmpty((String)this.success_condition)) {
                this.success_condition = this.SUCCESS_IF_NO_ERRORS;
            }
            this.iffileexist = JobEntryUnZip.getIfFileExistsInt(rep.getJobEntryAttributeString(id_jobentry, "iffileexists"));
            this.createMoveToDirectory = rep.getJobEntryAttributeBoolean(id_jobentry, "create_move_to_directory");
            this.setOriginalModificationDate = rep.getJobEntryAttributeBoolean(id_jobentry, "setOriginalModificationDate");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'unzip' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "zipfilename", this.zipFilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "afterunzip", this.afterunzip);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcardexclude", this.wildcardexclude);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "targetdirectory", this.targetdirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "movetodirectory", this.movetodirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "addfiletoresult", this.addfiletoresult);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "isfromprevious", this.isfromprevious);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "addtime", this.addtime);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "adddate", this.adddate);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "addOriginalTimestamp", this.addOriginalTimestamp);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "SpecifyFormat", this.SpecifyFormat);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "date_time_format", this.date_time_format);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "rootzip", this.rootzip);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "createfolder", this.createfolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "nr_limit", this.nr_limit);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcardSource", this.wildcardSource);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "success_condition", this.success_condition);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "iffileexists", JobEntryUnZip.getIfFileExistsCode(this.iffileexist));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "create_move_to_directory", this.createMoveToDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "setOriginalModificationDate", this.setOriginalModificationDate);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'unzip' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        block87: {
            block98: {
                block97: {
                    block84: {
                        block96: {
                            block95: {
                                block83: {
                                    block94: {
                                        block93: {
                                            block79: {
                                                block92: {
                                                    block77: {
                                                        block78: {
                                                            result = previousResult;
                                                            result.setResult(false);
                                                            result.setNrErrors(1L);
                                                            rows = result.getRows();
                                                            resultRow = null;
                                                            realFilenameSource = this.environmentSubstitute(this.zipFilename);
                                                            realWildcardSource = this.environmentSubstitute(this.wildcardSource);
                                                            realWildcard = this.environmentSubstitute(this.wildcard);
                                                            realWildcardExclude = this.environmentSubstitute(this.wildcardexclude);
                                                            realTargetdirectory = this.environmentSubstitute(this.targetdirectory);
                                                            realMovetodirectory = this.environmentSubstitute(this.movetodirectory);
                                                            this.limitFiles = Const.toInt((String)this.environmentSubstitute(this.getLimit()), (int)10);
                                                            this.NrErrors = 0;
                                                            this.NrSuccess = 0;
                                                            this.successConditionBroken = false;
                                                            this.successConditionBrokenExit = false;
                                                            if (this.isfromprevious) {
                                                                if (this.log.isDetailed()) {
                                                                    this.logDetailed(BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.Log.ArgFromPrevious.Found", (String[])new String[]{(rows != null ? rows.size() : 0) + ""}));
                                                                }
                                                                if (rows.size() == 0) {
                                                                    return result;
                                                                }
                                                            } else if (Const.isEmpty((String)this.zipFilename)) {
                                                                this.logError(BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.No_ZipFile_Defined.Label", (String[])new String[0]));
                                                                return result;
                                                            }
                                                            fileObject = null;
                                                            targetdir = null;
                                                            movetodir = null;
                                                            try {
                                                                block86: {
                                                                    block85: {
                                                                        block80: {
                                                                            try {
                                                                                block100: {
                                                                                    block99: {
                                                                                        if (Const.isEmpty((String)realTargetdirectory)) {
                                                                                            this.logError(BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.Error.TargetFolderMissing", (String[])new String[0]));
                                                                                            var15_15 = result;
                                                                                            var19_18 = null;
                                                                                            if (fileObject == null) break block77;
                                                                                            break block78;
                                                                                        }
                                                                                        exitjobentry = false;
                                                                                        targetdir = KettleVFS.getFileObject((String)realTargetdirectory, (VariableSpace)this);
                                                                                        if (targetdir.exists()) break block99;
                                                                                        if (this.createfolder) {
                                                                                            targetdir.createFolder();
                                                                                            if (this.log.isDetailed()) {
                                                                                                this.logDetailed(BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.Log.TargetFolderCreated", (String[])new String[]{realTargetdirectory}));
                                                                                            }
                                                                                            break block100;
                                                                                        } else {
                                                                                            this.log.logError(BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.Error.Label", (String[])new String[0]), new Object[]{BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.TargetFolderNotFound.Label", (String[])new String[0])});
                                                                                            exitjobentry = true;
                                                                                        }
                                                                                        break block100;
                                                                                    }
                                                                                    if (targetdir.getType() != FileType.FOLDER) {
                                                                                        this.log.logError(BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.Error.Label", (String[])new String[0]), new Object[]{BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.TargetFolderNotFolder.Label", (String[])new String[]{realTargetdirectory})});
                                                                                        exitjobentry = true;
                                                                                    } else if (this.log.isDetailed()) {
                                                                                        this.logDetailed(BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.TargetFolderExists.Label", (String[])new String[]{realTargetdirectory}));
                                                                                    }
                                                                                }
                                                                                if (this.afterunzip == 2) {
                                                                                    if (Const.isEmpty((String)this.movetodirectory)) {
                                                                                        this.log.logError(BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.Error.Label", (String[])new String[0]), new Object[]{BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.MoveToDirectoryEmpty.Label", (String[])new String[0])});
                                                                                        exitjobentry = true;
                                                                                    } else {
                                                                                        movetodir = KettleVFS.getFileObject((String)realMovetodirectory, (VariableSpace)this);
                                                                                        if (!movetodir.exists() || movetodir.getType() != FileType.FOLDER) {
                                                                                            if (this.createMoveToDirectory) {
                                                                                                movetodir.createFolder();
                                                                                                if (this.log.isDetailed()) {
                                                                                                    this.logDetailed(BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.Log.MoveToFolderCreated", (String[])new String[]{realMovetodirectory}));
                                                                                                }
                                                                                            } else {
                                                                                                this.log.logError(BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.Error.Label", (String[])new String[0]), new Object[]{BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.MoveToDirectoryNotExists.Label", (String[])new String[0])});
                                                                                                exitjobentry = true;
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                                if (exitjobentry) {
                                                                                    var16_34 = result;
                                                                                    break block79;
                                                                                }
                                                                                if (this.isfromprevious) {
                                                                                    if (rows == null) break block80;
                                                                                    for (iteration = 0; iteration < rows.size() && !this.parentJob.isStopped(); ++iteration) {
                                                                                        if (this.successConditionBroken) {
                                                                                            if (!this.successConditionBrokenExit) {
                                                                                                this.logError(BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrErrors}));
                                                                                                this.successConditionBrokenExit = true;
                                                                                            }
                                                                                            result.setNrErrors((long)this.NrErrors);
                                                                                            var17_38 = result;
                                                                                            var19_20 = null;
                                                                                            if (fileObject != null) {
                                                                                                try {
                                                                                                    fileObject.close();
                                                                                                }
                                                                                                catch (IOException ex) {
                                                                                                    // empty catch block
                                                                                                }
                                                                                            }
                                                                                            if (targetdir != null) {
                                                                                                try {
                                                                                                    targetdir.close();
                                                                                                }
                                                                                                catch (IOException ex) {
                                                                                                    // empty catch block
                                                                                                }
                                                                                            }
                                                                                            if (movetodir == null) return var17_38;
                                                                                            try {
                                                                                                movetodir.close();
                                                                                                return var17_38;
                                                                                            }
                                                                                            catch (IOException ex) {
                                                                                                // empty catch block
                                                                                            }
                                                                                            return var17_38;
                                                                                        }
                                                                                        resultRow = (RowMetaAndData)rows.get(iteration);
                                                                                        realFilenameSource = resultRow.getString(0, null);
                                                                                        realWildcardSource = resultRow.getString(1, null);
                                                                                        fileObject = KettleVFS.getFileObject((String)realFilenameSource, (VariableSpace)this);
                                                                                        if (fileObject.exists()) {
                                                                                            this.processOneFile(result, this.parentJob, fileObject, realTargetdirectory, realWildcard, realWildcardExclude, movetodir, realMovetodirectory, realWildcardSource);
                                                                                            continue;
                                                                                        }
                                                                                        this.updateErrors();
                                                                                        this.logError(BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.Error.CanNotFindFile", (String[])new String[]{realFilenameSource}));
                                                                                    }
                                                                                    break block80;
                                                                                }
                                                                                fileObject = KettleVFS.getFileObject((String)realFilenameSource, (VariableSpace)this);
                                                                                if (!fileObject.exists()) {
                                                                                    this.log.logError(BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.Error.Label", (String[])new String[0]), new Object[]{BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.ZipFile.NotExists.Label", (String[])new String[]{realFilenameSource})});
                                                                                    var16_36 = result;
                                                                                    break block83;
                                                                                }
                                                                                if (this.log.isDetailed()) {
                                                                                    this.logDetailed(BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.Zip_FileExists.Label", (String[])new String[]{realFilenameSource}));
                                                                                }
                                                                                if (Const.isEmpty((String)this.targetdirectory)) {
                                                                                    this.log.logError(BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.Error.Label", (String[])new String[0]), new Object[]{BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.TargetFolderNotFound.Label", (String[])new String[0])});
                                                                                    var16_37 = result;
                                                                                    break block84;
                                                                                }
                                                                                this.processOneFile(result, this.parentJob, fileObject, realTargetdirectory, realWildcard, realWildcardExclude, movetodir, realMovetodirectory, realWildcardSource);
                                                                            }
                                                                            catch (Exception e) {
                                                                                block89: {
                                                                                    block88: {
                                                                                        this.log.logError(BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.Error.Label", (String[])new String[0]), new Object[]{BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.ErrorUnzip.Label", (String[])new String[]{realFilenameSource, e.getMessage()})});
                                                                                        this.updateErrors();
                                                                                        var19_24 = null;
                                                                                        if (fileObject != null) {
                                                                                            ** try [egrp 2[TRYBLOCK] [14 : 1188->1198)] { 
lbl141:
                                                                                            // 1 sources

                                                                                            fileObject.close();
                                                                                            break block88;
lbl143:
                                                                                            // 1 sources

                                                                                            catch (IOException ex) {
                                                                                                // empty catch block
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    if (targetdir != null) {
                                                                                        ** try [egrp 3[TRYBLOCK] [15 : 1205->1215)] { 
lbl148:
                                                                                        // 1 sources

                                                                                        targetdir.close();
                                                                                        break block89;
lbl150:
                                                                                        // 1 sources

                                                                                        catch (IOException ex) {
                                                                                            // empty catch block
                                                                                        }
                                                                                    }
                                                                                }
                                                                                if (movetodir != null) {
                                                                                    try {}
                                                                                    catch (IOException ex) {}
                                                                                    movetodir.close();
                                                                                }
                                                                                break block87;
                                                                            }
                                                                        }
                                                                        var19_23 = null;
                                                                        if (fileObject != null) {
                                                                            ** try [egrp 2[TRYBLOCK] [14 : 1188->1198)] { 
lbl163:
                                                                            // 1 sources

                                                                            fileObject.close();
                                                                            break block85;
lbl165:
                                                                            // 1 sources

                                                                            catch (IOException ex) {
                                                                                // empty catch block
                                                                            }
                                                                        }
                                                                    }
                                                                    if (targetdir != null) {
                                                                        ** try [egrp 3[TRYBLOCK] [15 : 1205->1215)] { 
lbl170:
                                                                        // 1 sources

                                                                        targetdir.close();
                                                                        break block86;
lbl172:
                                                                        // 1 sources

                                                                        catch (IOException ex) {
                                                                            // empty catch block
                                                                        }
                                                                    }
                                                                }
                                                                if (movetodir != null) {
                                                                    try {}
                                                                    catch (IOException ex) {}
                                                                    movetodir.close();
                                                                }
                                                                break block87;
                                                            }
                                                            catch (Throwable var18_39) {
                                                                block91: {
                                                                    block90: {
                                                                        var19_25 = null;
                                                                        if (fileObject != null) {
                                                                            ** try [egrp 2[TRYBLOCK] [14 : 1188->1198)] { 
lbl186:
                                                                            // 1 sources

                                                                            fileObject.close();
                                                                            break block90;
lbl188:
                                                                            // 1 sources

                                                                            catch (IOException ex) {
                                                                                // empty catch block
                                                                            }
                                                                        }
                                                                    }
                                                                    if (targetdir != null) {
                                                                        ** try [egrp 3[TRYBLOCK] [15 : 1205->1215)] { 
lbl193:
                                                                        // 1 sources

                                                                        targetdir.close();
                                                                        break block91;
lbl195:
                                                                        // 1 sources

                                                                        catch (IOException ex) {
                                                                            // empty catch block
                                                                        }
                                                                    }
                                                                }
                                                                if (movetodir == null) throw var18_39;
                                                                ** try [egrp 4[TRYBLOCK] [16 : 1222->1232)] { 
lbl200:
                                                                // 1 sources

                                                                movetodir.close();
                                                                throw var18_39;
lbl202:
                                                                // 1 sources

                                                                catch (IOException ex) {
                                                                    // empty catch block
                                                                }
                                                                throw var18_39;
                                                            }
                                                        }
                                                        ** try [egrp 2[TRYBLOCK] [14 : 1188->1198)] { 
lbl207:
                                                        // 1 sources

                                                        fileObject.close();
                                                        break block77;
lbl209:
                                                        // 1 sources

                                                        catch (IOException ex) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    if (targetdir != null) {
                                                        ** try [egrp 3[TRYBLOCK] [15 : 1205->1215)] { 
lbl214:
                                                        // 1 sources

                                                        targetdir.close();
                                                        break block92;
lbl216:
                                                        // 1 sources

                                                        catch (IOException ex) {
                                                            // empty catch block
                                                        }
                                                    }
                                                }
                                                if (movetodir == null) return var15_15;
                                                ** try [egrp 4[TRYBLOCK] [16 : 1222->1232)] { 
lbl221:
                                                // 1 sources

                                                movetodir.close();
                                                return var15_15;
lbl223:
                                                // 1 sources

                                                catch (IOException ex) {
                                                    // empty catch block
                                                }
                                                return var15_15;
                                            }
                                            var19_19 = null;
                                            if (fileObject != null) {
                                                ** try [egrp 2[TRYBLOCK] [14 : 1188->1198)] { 
lbl230:
                                                // 1 sources

                                                fileObject.close();
                                                break block93;
lbl232:
                                                // 1 sources

                                                catch (IOException ex) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (targetdir != null) {
                                            ** try [egrp 3[TRYBLOCK] [15 : 1205->1215)] { 
lbl237:
                                            // 1 sources

                                            targetdir.close();
                                            break block94;
lbl239:
                                            // 1 sources

                                            catch (IOException ex) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (movetodir == null) return var16_34;
                                    ** try [egrp 4[TRYBLOCK] [16 : 1222->1232)] { 
lbl244:
                                    // 1 sources

                                    movetodir.close();
                                    return var16_34;
lbl246:
                                    // 1 sources

                                    catch (IOException ex) {
                                        // empty catch block
                                    }
                                    return var16_34;
                                }
                                var19_21 = null;
                                if (fileObject != null) {
                                    ** try [egrp 2[TRYBLOCK] [14 : 1188->1198)] { 
lbl253:
                                    // 1 sources

                                    fileObject.close();
                                    break block95;
lbl255:
                                    // 1 sources

                                    catch (IOException ex) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (targetdir != null) {
                                ** try [egrp 3[TRYBLOCK] [15 : 1205->1215)] { 
lbl260:
                                // 1 sources

                                targetdir.close();
                                break block96;
lbl262:
                                // 1 sources

                                catch (IOException ex) {
                                    // empty catch block
                                }
                            }
                        }
                        if (movetodir == null) return var16_36;
                        ** try [egrp 4[TRYBLOCK] [16 : 1222->1232)] { 
lbl267:
                        // 1 sources

                        movetodir.close();
                        return var16_36;
lbl269:
                        // 1 sources

                        catch (IOException ex) {
                            // empty catch block
                        }
                        return var16_36;
                    }
                    var19_22 = null;
                    if (fileObject != null) {
                        ** try [egrp 2[TRYBLOCK] [14 : 1188->1198)] { 
lbl276:
                        // 1 sources

                        fileObject.close();
                        break block97;
lbl278:
                        // 1 sources

                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                }
                if (targetdir != null) {
                    ** try [egrp 3[TRYBLOCK] [15 : 1205->1215)] { 
lbl283:
                    // 1 sources

                    targetdir.close();
                    break block98;
lbl285:
                    // 1 sources

                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
            if (movetodir == null) return var16_37;
            ** try [egrp 4[TRYBLOCK] [16 : 1222->1232)] { 
lbl290:
            // 1 sources

            movetodir.close();
            return var16_37;
lbl292:
            // 1 sources

            catch (IOException ex) {
                // empty catch block
            }
            return var16_37;
        }
        result.setNrErrors((long)this.NrErrors);
        result.setNrLinesWritten((long)this.NrSuccess);
        if (this.getSuccessStatus()) {
            result.setResult(true);
        }
        this.displayResults();
        return result;
    }

    private void displayResults() {
        if (this.log.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobUnZip.Log.Info.FilesInError", (String[])new String[]{"" + this.NrErrors}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobUnZip.Log.Info.FilesInSuccess", (String[])new String[]{"" + this.NrSuccess}));
            this.logDetailed("=======================================");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processOneFile(Result result, Job parentJob, FileObject fileObject, String realTargetdirectory, String realWildcard, String realWildcardExclude, FileObject movetodir, String realMovetodirectory, String realWildcardSource) {
        block19: {
            block20: {
                retval = false;
                try {
                    try {
                        if (fileObject.getType().equals(FileType.FILE)) {
                            if (!this.unzipFile(fileObject, realTargetdirectory, realWildcard, realWildcardExclude, result, parentJob, fileObject, movetodir, realMovetodirectory)) {
                                this.updateErrors();
                                break block19;
                            } else {
                                this.updateSuccess();
                            }
                            break block19;
                        }
                        children = fileObject.getChildren();
                        for (i = 0; i < children.length && !parentJob.isStopped(); ++i) {
                            if (this.successConditionBroken) {
                                if (!this.successConditionBrokenExit) {
                                    this.logError(BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrErrors}));
                                    this.successConditionBrokenExit = true;
                                }
                                var13_14 = false;
                                var18_18 = null;
                                if (fileObject == null) return var13_14;
                                break block20;
                            }
                            if (children[i].getType().equals(FileType.FOLDER)) continue;
                            unzip = true;
                            filename = children[i].getName().getPath();
                            patternSource = null;
                            if (!Const.isEmpty((String)realWildcardSource)) {
                                patternSource = Pattern.compile(realWildcardSource);
                            }
                            if (patternSource != null) {
                                matcher = patternSource.matcher(filename);
                                unzip = matcher.matches();
                            }
                            if (!unzip) continue;
                            if (!this.unzipFile(children[i], realTargetdirectory, realWildcard, realWildcardExclude, result, parentJob, fileObject, movetodir, realMovetodirectory)) {
                                this.updateErrors();
                                continue;
                            }
                            this.updateSuccess();
                        }
                        break block19;
                    }
                    catch (Exception e) {
                        this.updateErrors();
                        this.logError(BaseMessages.getString(JobEntryUnZip.PKG, (String)"JobUnZip.Error.Label", (String[])new String[]{e.getMessage()}));
                        var18_20 = null;
                        if (fileObject == null) return retval;
                        try {
                            fileObject.close();
                            return retval;
                        }
                        catch (IOException ex) {
                            return retval;
                        }
                    }
                }
                catch (Throwable var17_26) {
                    var18_21 = null;
                    if (fileObject == null) throw var17_26;
                    ** try [egrp 2[TRYBLOCK] [6 : 329->338)] { 
lbl53:
                    // 1 sources

                    fileObject.close();
                    throw var17_26;
lbl55:
                    // 1 sources

                    catch (IOException ex) {
                        // empty catch block
                    }
                    throw var17_26;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 329->338)] { 
lbl60:
            // 1 sources

            fileObject.close();
            return var13_14;
lbl62:
            // 1 sources

            catch (IOException ex) {
                // empty catch block
            }
            return var13_14;
        }
        var18_19 = null;
        if (fileObject == null) return retval;
        try {}
        catch (IOException ex) {}
        fileObject.close();
        return retval;
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean unzipFile(FileObject sourceFileObject, String realTargetdirectory, String realWildcard, String realWildcardExclude, Result result, Job parentJob, FileObject fileObject, FileObject movetodir, String realMovetodirectory) {
        boolean retval = false;
        String unzipToFolder = realTargetdirectory;
        try {
            FileObject destFile;
            block56: {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobUnZip.Log.ProcessingFile", (String[])new String[]{sourceFileObject.toString()}));
                }
                if (this.rootzip) {
                    String foldername;
                    FileObject rootfolder;
                    String shortSourceFilename = sourceFileObject.getName().getBaseName();
                    int lenstring = shortSourceFilename.length();
                    int lastindexOfDot = shortSourceFilename.lastIndexOf(46);
                    if (lastindexOfDot == -1) {
                        lastindexOfDot = lenstring;
                    }
                    if (!(rootfolder = KettleVFS.getFileObject((String)(foldername = realTargetdirectory + "/" + shortSourceFilename.substring(0, lastindexOfDot)), (VariableSpace)this)).exists()) {
                        try {
                            rootfolder.createFolder();
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"JobUnZip.Log.RootFolderCreated", (String[])new String[]{foldername}));
                            }
                        }
                        catch (Exception e) {
                            throw new Exception(BaseMessages.getString(PKG, (String)"JobUnZip.Error.CanNotCreateRootFolder", (String[])new String[]{foldername}), e);
                        }
                    }
                    unzipToFolder = foldername;
                }
                String zipFilename = "zip:" + sourceFileObject.getName().getFriendlyURI();
                FileObject zipFile = KettleVFS.getFileObject((String)zipFilename, (VariableSpace)this);
                FileObject[] items = zipFile.findFiles((FileSelector)new AllFileSelector(){

                    public boolean traverseDescendents(FileSelectInfo info) {
                        return true;
                    }

                    public boolean includeFile(FileSelectInfo info) {
                        if (info.getDepth() == 0) {
                            return false;
                        }
                        FileObject fileObject = info.getFile();
                        return fileObject != null;
                    }
                });
                Pattern pattern = null;
                if (!Const.isEmpty((String)realWildcard)) {
                    pattern = Pattern.compile(realWildcard);
                }
                Pattern patternexclude = null;
                if (!Const.isEmpty((String)realWildcardExclude)) {
                    patternexclude = Pattern.compile(realWildcardExclude);
                }
                for (FileObject item : items) {
                    Exception e2;
                    Object var33_42;
                    FileObject newFileObject;
                    block54: {
                        block58: {
                            String newFileName;
                            block57: {
                                if (this.successConditionBroken) {
                                    if (this.successConditionBrokenExit) return false;
                                    this.logError(BaseMessages.getString(PKG, (String)"JobUnZip.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrErrors}));
                                    this.successConditionBrokenExit = true;
                                    return false;
                                }
                                newFileObject = null;
                                if (this.log.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobUnZip.Log.ProcessingZipEntry", (String[])new String[]{item.getName().getURI(), sourceFileObject.toString()}));
                                }
                                newFileName = unzipToFolder + Const.FILE_SEPARATOR + this.getTargetFilename(item);
                                newFileObject = KettleVFS.getFileObject((String)newFileName, (VariableSpace)this);
                                if (!item.getType().equals(FileType.FOLDER)) break block57;
                                if (this.log.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobUnZip.CreatingDirectory.Label", (String[])new String[]{newFileName}));
                                }
                                if (!newFileObject.exists()) {
                                    newFileObject.createFolder();
                                }
                                break block58;
                            }
                            boolean getIt = true;
                            boolean getItexclude = false;
                            if (pattern != null) {
                                Matcher matcher = pattern.matcher(item.getName().getURI());
                                getIt = matcher.matches();
                            }
                            if (patternexclude != null) {
                                Matcher matcherexclude = patternexclude.matcher(item.getName().getURI());
                                getItexclude = matcherexclude.matches();
                            }
                            boolean take = this.takeThisFile(item, newFileName);
                            if (getIt && !getItexclude && take) {
                                OutputStream os;
                                block53: {
                                    Object var31_41;
                                    if (this.log.isDetailed()) {
                                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobUnZip.ExtractingEntry.Label", (String[])new String[]{item.getName().getURI(), newFileName}));
                                    }
                                    if (this.iffileexist == 2) {
                                        int lenstring = newFileName.length();
                                        int lastindexOfDot = newFileName.lastIndexOf(46);
                                        if (lastindexOfDot == -1) {
                                            lastindexOfDot = lenstring;
                                        }
                                        newFileName = newFileName.substring(0, lastindexOfDot) + StringUtil.getFormattedDateTimeNow((boolean)true) + newFileName.substring(lastindexOfDot, lenstring);
                                        if (this.log.isDebug()) {
                                            this.logDebug(BaseMessages.getString(PKG, (String)"JobUnZip.Log.CreatingUniqFile", (String[])new String[]{newFileName}));
                                        }
                                    }
                                    if (!newFileObject.getParent().exists()) {
                                        newFileObject.getParent().createFolder();
                                    }
                                    InputStream is = null;
                                    os = null;
                                    try {
                                        is = KettleVFS.getInputStream((FileObject)item);
                                        os = KettleVFS.getOutputStream((FileObject)newFileObject, (boolean)false);
                                        if (is != null) {
                                            int len;
                                            byte[] buff = new byte[2048];
                                            while ((len = is.read(buff)) > 0) {
                                                os.write(buff, 0, len);
                                            }
                                            this.addFilenameToResultFilenames(result, parentJob, newFileName);
                                        }
                                        var31_41 = null;
                                        if (is == null) break block53;
                                    }
                                    catch (Throwable throwable) {
                                        var31_41 = null;
                                        if (is != null) {
                                            is.close();
                                        }
                                        if (os == null) throw throwable;
                                        os.close();
                                        throw throwable;
                                    }
                                    is.close();
                                }
                                if (os != null) {
                                    os.close();
                                }
                            }
                        }
                        var33_42 = null;
                        if (newFileObject == null) break block54;
                        try {
                            newFileObject.close();
                            if (this.setOriginalModificationDate) {
                                newFileObject.getContent().setLastModifiedTime(item.getContent().getLastModifiedTime());
                            }
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                    KettleVFS.getInstance().getFileSystemManager().closeFileSystem(item.getFileSystem());
                    if (items == null) continue;
                    items = null;
                    {
                        continue;
                        catch (Exception e3) {
                            this.updateErrors();
                            this.logError(BaseMessages.getString(PKG, (String)"JobUnZip.Error.CanNotProcessZipEntry", (String[])new String[]{item.getName().getURI(), sourceFileObject.toString()}), e3);
                            var33_42 = null;
                            if (newFileObject != null) {
                                try {
                                    newFileObject.close();
                                    if (this.setOriginalModificationDate) {
                                        newFileObject.getContent().setLastModifiedTime(item.getContent().getLastModifiedTime());
                                    }
                                }
                                catch (Exception e2) {
                                    // empty catch block
                                }
                            }
                            KettleVFS.getInstance().getFileSystemManager().closeFileSystem(item.getFileSystem());
                            if (items == null) continue;
                            items = null;
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var33_42 = null;
                        if (newFileObject != null) {
                            try {
                                newFileObject.close();
                                if (this.setOriginalModificationDate) {
                                    newFileObject.getContent().setLastModifiedTime(item.getContent().getLastModifiedTime());
                                }
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                        }
                        KettleVFS.getInstance().getFileSystemManager().closeFileSystem(item.getFileSystem());
                        if (items == null) throw throwable;
                        items = null;
                        throw throwable;
                    }
                }
                if (this.afterunzip == 1) {
                    boolean deleted = fileObject.delete();
                    if (!deleted) {
                        this.updateErrors();
                        this.logError(BaseMessages.getString(PKG, (String)"JobUnZip.Cant_Delete_File.Label", (String[])new String[]{sourceFileObject.toString()}));
                    }
                    if (!this.log.isDebug()) return true;
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobUnZip.File_Deleted.Label", (String[])new String[]{sourceFileObject.toString()}));
                    return true;
                }
                if (this.afterunzip != 2) return true;
                destFile = null;
                String destinationFilename = movetodir + Const.FILE_SEPARATOR + fileObject.getName().getBaseName();
                destFile = KettleVFS.getFileObject((String)destinationFilename, (VariableSpace)this);
                fileObject.moveTo(destFile);
                if (!this.log.isDetailed()) break block56;
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobUnZip.Log.FileMovedTo", (String[])new String[]{sourceFileObject.toString(), realMovetodirectory}));
            }
            Object var36_46 = null;
            if (destFile == null) return true;
            try {
                destFile.close();
                return true;
            }
            catch (IOException ex) {}
            return true;
            {
                catch (Exception e) {
                    this.updateErrors();
                    this.logError(BaseMessages.getString(PKG, (String)"JobUnZip.Cant_Move_File.Label", (String[])new String[]{sourceFileObject.toString(), realMovetodirectory, e.getMessage()}));
                    Object var36_47 = null;
                    if (destFile == null) return true;
                    try {
                        destFile.close();
                        return true;
                    }
                    catch (IOException ex) {}
                    return true;
                }
            }
            catch (Throwable throwable) {
                Object var36_48 = null;
                if (destFile == null) throw throwable;
                try {
                    destFile.close();
                    throw throwable;
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.updateErrors();
            this.log.logError(BaseMessages.getString(PKG, (String)"JobUnZip.Error.Label", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"JobUnZip.ErrorUnzip.Label", (String[])new String[]{sourceFileObject.toString(), e.getMessage()}), e});
        }
        return retval;
    }

    private void addFilenameToResultFilenames(Result result, Job parentJob, String newfile) throws Exception {
        if (this.addfiletoresult) {
            ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)newfile, (VariableSpace)this), parentJob.getJobname(), this.toString());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
        }
    }

    private void updateErrors() {
        ++this.NrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private void updateSuccess() {
        ++this.NrSuccess;
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.NrErrors > 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrErrors >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.NrErrors == 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrSuccess >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED) || this.NrErrors <= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private boolean takeThisFile(FileObject sourceFile, String destinationFile) throws FileSystemException {
        boolean retval = false;
        File destination = new File(destinationFile);
        if (!destination.exists()) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"JobUnZip.Log.CanNotFindFile", (String[])new String[]{destinationFile}));
            }
            return true;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"JobUnZip.Log.FileExists", (String[])new String[]{destinationFile}));
        }
        if (this.iffileexist == 0) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"JobUnZip.Log.FileSkip", (String[])new String[]{destinationFile}));
            }
            return false;
        }
        if (this.iffileexist == 3) {
            this.updateErrors();
            this.logError(BaseMessages.getString(PKG, (String)"JobUnZip.Log.FileError", (String[])new String[]{destinationFile, "" + this.NrErrors}));
            return false;
        }
        if (this.iffileexist == 1) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"JobUnZip.Log.FileOverwrite", (String[])new String[]{destinationFile}));
            }
            return true;
        }
        Long entrySize = sourceFile.getContent().getSize();
        Long destinationSize = destination.length();
        if (this.iffileexist == 4) {
            if (entrySize != destinationSize) {
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobUnZip.Log.FileDiffSize.Diff", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
                }
                return true;
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"JobUnZip.Log.FileDiffSize.Same", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
            }
            return false;
        }
        if (this.iffileexist == 5) {
            if (entrySize == destinationSize) {
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobUnZip.Log.FileEqualSize.Same", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
                }
                return true;
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"JobUnZip.Log.FileEqualSize.Diff", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
            }
            return false;
        }
        if (this.iffileexist == 6) {
            if (entrySize > destinationSize) {
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobUnZip.Log.FileBigSize.Big", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
                }
                return true;
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"JobUnZip.Log.FileBigSize.Small", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
            }
            return false;
        }
        if (this.iffileexist == 7) {
            if (entrySize >= destinationSize) {
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobUnZip.Log.FileBigEqualSize.Big", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
                }
                return true;
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"JobUnZip.Log.FileBigEqualSize.Small", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
            }
            return false;
        }
        if (this.iffileexist == 8) {
            if (entrySize < destinationSize) {
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobUnZip.Log.FileSmallSize.Small", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
                }
                return true;
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"JobUnZip.Log.FileSmallSize.Big", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
            }
            return false;
        }
        if (this.iffileexist == 9) {
            if (entrySize <= destinationSize) {
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobUnZip.Log.FileSmallEqualSize.Small", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
                }
                return true;
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"JobUnZip.Log.FileSmallEqualSize.Big", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
            }
            return false;
        }
        if (this.iffileexist == 2) {
            return true;
        }
        return retval;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public static final int getIfFileExistsInt(String desc) {
        for (int i = 0; i < typeIfFileExistsCode.length; ++i) {
            if (!typeIfFileExistsCode[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        return 0;
    }

    public static final String getIfFileExistsCode(int i) {
        if (i < 0 || i >= typeIfFileExistsCode.length) {
            return null;
        }
        return typeIfFileExistsCode[i];
    }

    public int getIfFileExist() {
        return this.iffileexist;
    }

    public void setIfFileExists(int iffileexist) {
        this.iffileexist = iffileexist;
    }

    public boolean isCreateMoveToDirectory() {
        return this.createMoveToDirectory;
    }

    public void setCreateMoveToDirectory(boolean createMoveToDirectory) {
        this.createMoveToDirectory = createMoveToDirectory;
    }

    public void setZipFilename(String zipFilename) {
        this.zipFilename = zipFilename;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public void setWildcardExclude(String wildcardexclude) {
        this.wildcardexclude = wildcardexclude;
    }

    public void setSourceDirectory(String targetdirectoryin) {
        this.targetdirectory = targetdirectoryin;
    }

    public void setMoveToDirectory(String movetodirectory) {
        this.movetodirectory = movetodirectory;
    }

    public String getSourceDirectory() {
        return this.targetdirectory;
    }

    public String getMoveToDirectory() {
        return this.movetodirectory;
    }

    public String getZipFilename() {
        return this.zipFilename;
    }

    public String getWildcardSource() {
        return this.wildcardSource;
    }

    public void setWildcardSource(String wildcardSource) {
        this.wildcardSource = wildcardSource;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public String getWildcardExclude() {
        return this.wildcardexclude;
    }

    public void setAddFileToResult(boolean addfiletoresultin) {
        this.addfiletoresult = addfiletoresultin;
    }

    public boolean isAddFileToResult() {
        return this.addfiletoresult;
    }

    public void setDateInFilename(boolean adddate) {
        this.adddate = adddate;
    }

    public void setAddOriginalTimestamp(boolean addOriginalTimestamp) {
        this.addOriginalTimestamp = addOriginalTimestamp;
    }

    public boolean isOriginalTimestamp() {
        return this.addOriginalTimestamp;
    }

    public void setOriginalModificationDate(boolean setOriginalModificationDate) {
        this.setOriginalModificationDate = setOriginalModificationDate;
    }

    public boolean isOriginalModificationDate() {
        return this.setOriginalModificationDate;
    }

    public boolean isDateInFilename() {
        return this.adddate;
    }

    public void setTimeInFilename(boolean addtime) {
        this.addtime = addtime;
    }

    public boolean isTimeInFilename() {
        return this.addtime;
    }

    public boolean isSpecifyFormat() {
        return this.SpecifyFormat;
    }

    public void setSpecifyFormat(boolean SpecifyFormat) {
        this.SpecifyFormat = SpecifyFormat;
    }

    public String getDateTimeFormat() {
        return this.date_time_format;
    }

    public void setDateTimeFormat(String date_time_format) {
        this.date_time_format = date_time_format;
    }

    public void setDatafromprevious(boolean isfromprevious) {
        this.isfromprevious = isfromprevious;
    }

    public boolean getDatafromprevious() {
        return this.isfromprevious;
    }

    public void setCreateRootFolder(boolean rootzip) {
        this.rootzip = rootzip;
    }

    public boolean isCreateRootFolder() {
        return this.rootzip;
    }

    public void setCreateFolder(boolean createfolder) {
        this.createfolder = createfolder;
    }

    public boolean isCreateFolder() {
        return this.createfolder;
    }

    public void setLimit(String nr_limitin) {
        this.nr_limit = nr_limitin;
    }

    public String getLimit() {
        return this.nr_limit;
    }

    public void setSuccessCondition(String success_condition) {
        this.success_condition = success_condition;
    }

    public String getSuccessCondition() {
        return this.success_condition;
    }

    protected String getTargetFilename(FileObject file) throws FileSystemException {
        String retval = "";
        String filename = file.getName().getPath();
        if (filename != null) {
            retval = filename;
        }
        if (file.getType() != FileType.FILE) {
            return retval;
        }
        if (!(this.SpecifyFormat || this.adddate || this.addtime)) {
            return retval;
        }
        int lenstring = retval.length();
        int lastindexOfDot = retval.lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        retval = retval.substring(0, lastindexOfDot);
        if (daf == null) {
            daf = new SimpleDateFormat();
        }
        Date timestamp = new Date();
        if (this.addOriginalTimestamp) {
            timestamp = new Date(file.getContent().getLastModifiedTime());
        }
        if (this.SpecifyFormat && !Const.isEmpty((String)this.date_time_format)) {
            if (!this.dateFormatSet) {
                daf.applyPattern(this.date_time_format);
            }
            String dt = daf.format(timestamp);
            retval = retval + dt;
        } else {
            if (this.adddate) {
                if (!this.dateFormatSet) {
                    daf.applyPattern("yyyyMMdd");
                }
                String d = daf.format(timestamp);
                retval = retval + "_" + d;
            }
            if (this.addtime) {
                if (!this.dateFormatSet) {
                    daf.applyPattern("HHmmssSSS");
                }
                String t = daf.format(timestamp);
                retval = retval + "_" + t;
            }
        }
        if (daf != null) {
            this.dateFormatSet = true;
        }
        retval = retval + filename.substring(lastindexOfDot, lenstring);
        return retval;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        ValidatorContext ctx1 = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx1, this.getVariables());
        AndValidator.putValidators(ctx1, JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileDoesNotExistValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "zipFilename", remarks, ctx1);
        if (2 == this.afterunzip) {
            JobEntryValidatorUtils.andValidator().validate(this, "moveToDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        }
        JobEntryValidatorUtils.andValidator().validate(this, "sourceDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

