/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.waitforsql;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryWaitForSQL
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryWaitForSQL.class;
    public boolean isClearResultList = true;
    public boolean isAddRowsResult = false;
    public boolean isUseVars = false;
    public boolean iscustomSQL = false;
    public String customSQL = null;
    private DatabaseMeta connection = null;
    public String tablename = null;
    public String schemaname = null;
    private String maximumTimeout = DEFAULT_MAXIMUM_TIMEOUT;
    private String checkCycleTime = DEFAULT_CHECK_CYCLE_TIME;
    private boolean successOnTimeout = false;
    private static final String selectCount = "SELECT count(*) FROM ";
    public static final String[] successConditionsDesc = new String[]{BaseMessages.getString(PKG, (String)"JobEntryWaitForSQL.SuccessWhenRowCountEqual.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryWaitForSQL.SuccessWhenRowCountDifferent.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryWaitForSQL.SuccessWhenRowCountSmallerThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryWaitForSQL.SuccessWhenRowCountSmallerOrEqualThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryWaitForSQL.SuccessWhenRowCountGreaterThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryWaitForSQL.SuccessWhenRowCountGreaterOrEqual.Label", (String[])new String[0])};
    public static final String[] successConditionsCode = new String[]{"rows_count_equal", "rows_count_different", "rows_count_smaller", "rows_count_smaller_equal", "rows_count_greater", "rows_count_greater_equal"};
    public static final int SUCCESS_CONDITION_ROWS_COUNT_EQUAL = 0;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_DIFFERENT = 1;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_SMALLER = 2;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_SMALLER_EQUAL = 3;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_GREATER = 4;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_GREATER_EQUAL = 5;
    public String rowsCountValue = "0";
    public int successCondition = 4;
    private static String DEFAULT_MAXIMUM_TIMEOUT = "0";
    private static String DEFAULT_CHECK_CYCLE_TIME = "60";

    public JobEntryWaitForSQL(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryWaitForSQL() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryWaitForSQL je = (JobEntryWaitForSQL)super.clone();
        return je;
    }

    public int getSuccessCondition() {
        return this.successCondition;
    }

    public static int getSuccessConditionByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionsDesc.length; ++i) {
            if (!successConditionsDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntryWaitForSQL.getSuccessConditionByCode(tt);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"schemaname", (String)this.schemaname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"tablename", (String)this.tablename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)JobEntryWaitForSQL.getSuccessConditionCode(this.successCondition)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"rows_count_value", (String)this.rowsCountValue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"is_custom_sql", (boolean)this.iscustomSQL));
        retval.append("      ").append(XMLHandler.addTagValue((String)"is_usevars", (boolean)this.isUseVars));
        retval.append("      ").append(XMLHandler.addTagValue((String)"custom_sql", (String)this.customSQL));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_rows_result", (boolean)this.isAddRowsResult));
        retval.append("      ").append(XMLHandler.addTagValue((String)"maximum_timeout", (String)this.maximumTimeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"check_cycle_time", (String)this.checkCycleTime));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_on_timeout", (boolean)this.successOnTimeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"clear_result_rows", (boolean)this.isClearResultList));
        return retval.toString();
    }

    private static String getSuccessConditionCode(int i) {
        if (i < 0 || i >= successConditionsCode.length) {
            return successConditionsCode[0];
        }
        return successConditionsCode[i];
    }

    private static int getSucessConditionByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionsCode.length; ++i) {
            if (!successConditionsCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static String getSuccessConditionDesc(int i) {
        if (i < 0 || i >= successConditionsDesc.length) {
            return successConditionsDesc[0];
        }
        return successConditionsDesc[i];
    }

    public boolean isSuccessOnTimeout() {
        return this.successOnTimeout;
    }

    public void setSuccessOnTimeout(boolean successOnTimeout) {
        this.successOnTimeout = successOnTimeout;
    }

    public String getCheckCycleTime() {
        return this.checkCycleTime;
    }

    public void setCheckCycleTime(String checkCycleTime) {
        this.checkCycleTime = checkCycleTime;
    }

    public String getMaximumTimeout() {
        return this.maximumTimeout;
    }

    public void setMaximumTimeout(String maximumTimeout) {
        this.maximumTimeout = maximumTimeout;
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            String dbname = XMLHandler.getTagValue((Node)entrynode, (String)"connection");
            this.connection = DatabaseMeta.findDatabase(databases, (String)dbname);
            this.schemaname = XMLHandler.getTagValue((Node)entrynode, (String)"schemaname");
            this.tablename = XMLHandler.getTagValue((Node)entrynode, (String)"tablename");
            this.successCondition = JobEntryWaitForSQL.getSucessConditionByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"success_condition"), (String)""));
            this.rowsCountValue = Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"rows_count_value"), (String)"0");
            this.iscustomSQL = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"is_custom_sql"));
            this.isUseVars = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"is_usevars"));
            this.customSQL = XMLHandler.getTagValue((Node)entrynode, (String)"custom_sql");
            this.isAddRowsResult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_rows_result"));
            this.maximumTimeout = XMLHandler.getTagValue((Node)entrynode, (String)"maximum_timeout");
            this.checkCycleTime = XMLHandler.getTagValue((Node)entrynode, (String)"check_cycle_time");
            this.successOnTimeout = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"success_on_timeout"));
            this.isClearResultList = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"clear_result_rows"));
        }
        catch (KettleException e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryWaitForSQL.UnableLoadXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.connection = rep.loadDatabaseMetaFromJobEntryAttribute(id_jobentry, "connection", "id_database", databases);
            this.schemaname = rep.getJobEntryAttributeString(id_jobentry, "schemaname");
            this.tablename = rep.getJobEntryAttributeString(id_jobentry, "tablename");
            this.successCondition = JobEntryWaitForSQL.getSuccessConditionByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "success_condition"), (String)""));
            this.rowsCountValue = rep.getJobEntryAttributeString(id_jobentry, "rows_count_value");
            this.iscustomSQL = rep.getJobEntryAttributeBoolean(id_jobentry, "is_custom_sql");
            this.isUseVars = rep.getJobEntryAttributeBoolean(id_jobentry, "is_usevars");
            this.isAddRowsResult = rep.getJobEntryAttributeBoolean(id_jobentry, "add_rows_result");
            this.customSQL = rep.getJobEntryAttributeString(id_jobentry, "custom_sql");
            this.maximumTimeout = rep.getJobEntryAttributeString(id_jobentry, "maximum_timeout");
            this.checkCycleTime = rep.getJobEntryAttributeString(id_jobentry, "check_cycle_time");
            this.successOnTimeout = rep.getJobEntryAttributeBoolean(id_jobentry, "success_on_timeout");
            this.isClearResultList = rep.getJobEntryAttributeBoolean(id_jobentry, "clear_result_rows");
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryWaitForSQL.UnableLoadRep", (String[])new String[]{"" + id_jobentry}), (Throwable)dbe);
        }
    }

    private static int getSuccessConditionByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionsCode.length; ++i) {
            if (!successConditionsCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        try {
            rep.saveDatabaseMetaJobEntryAttribute(id_job, this.getObjectId(), "connection", "id_database", this.connection);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "schemaname", this.schemaname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "tablename", this.tablename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "success_condition", JobEntryWaitForSQL.getSuccessConditionCode(this.successCondition));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "rows_count_value", this.rowsCountValue);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "custom_sql", this.customSQL);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "is_custom_sql", this.iscustomSQL);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "is_usevars", this.isUseVars);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_rows_result", this.isAddRowsResult);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "maximum_timeout", this.maximumTimeout);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "check_cycle_time", this.checkCycleTime);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "success_on_timeout", this.successOnTimeout);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "clear_result_rows", this.isClearResultList);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryWaitForSQL.UnableSaveRep", (String[])new String[]{"" + id_job}), (Throwable)dbe);
        }
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        result.setNrErrors(1L);
        String realCustomSQL = null;
        String realTablename = this.environmentSubstitute(this.tablename);
        String realSchemaname = this.environmentSubstitute(this.schemaname);
        if (this.connection == null) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryWaitForSQL.NoDbConnection", (String[])new String[0]));
            return result;
        }
        if (this.iscustomSQL) {
            if (this.isClearResultList) {
                result.getRows().clear();
            }
            realCustomSQL = this.customSQL;
            if (this.isUseVars) {
                realCustomSQL = this.environmentSubstitute(realCustomSQL);
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryWaitForSQL.Log.EnteredCustomSQL", (String[])new String[]{realCustomSQL}));
            }
            if (Const.isEmpty((String)realCustomSQL)) {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryWaitForSQL.Error.NoCustomSQL", (String[])new String[0]));
                return result;
            }
        } else if (Const.isEmpty((String)realTablename)) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryWaitForSQL.Error.NoTableName", (String[])new String[0]));
            return result;
        }
        try {
            block26: {
                Database dbchecked = null;
                try {
                    dbchecked = new Database((LoggingObjectInterface)this, this.connection);
                    dbchecked.shareVariablesWith((VariableSpace)this);
                    dbchecked.connect();
                    Object var9_9 = null;
                    if (dbchecked == null) break block26;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (dbchecked == null) throw throwable;
                    dbchecked.disconnect();
                    throw throwable;
                }
                dbchecked.disconnect();
            }
            long timeStart = System.currentTimeMillis() / 1000L;
            int nrRowsLimit = Const.toInt((String)this.environmentSubstitute(this.rowsCountValue), (int)0);
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryWaitForSQL.Log.nrRowsLimit", (String[])new String[]{"" + nrRowsLimit}));
            }
            long iMaximumTimeout = Const.toInt((String)this.environmentSubstitute(this.maximumTimeout), (int)Const.toInt((String)DEFAULT_MAXIMUM_TIMEOUT, (int)0));
            long iCycleTime = Const.toInt((String)this.environmentSubstitute(this.checkCycleTime), (int)Const.toInt((String)DEFAULT_CHECK_CYCLE_TIME, (int)0));
            if (iMaximumTimeout < 0L) {
                iMaximumTimeout = Const.toInt((String)DEFAULT_MAXIMUM_TIMEOUT, (int)0);
                this.logBasic("Maximum timeout invalid, reset to " + iMaximumTimeout);
            }
            if (iCycleTime < 1L) {
                iCycleTime = Const.toInt((String)DEFAULT_CHECK_CYCLE_TIME, (int)1);
                this.logBasic("Check cycle time invalid, reset to " + iCycleTime);
            }
            if (iMaximumTimeout == 0L) {
                this.logBasic("Waiting indefinitely for SQL data");
            } else {
                this.logBasic("Waiting " + iMaximumTimeout + " seconds for SQL data");
            }
            boolean continueLoop = true;
            while (continueLoop && !this.parentJob.isStopped()) {
                if (this.SQLDataOK(result, nrRowsLimit, realSchemaname, realTablename, realCustomSQL)) {
                    this.logBasic("Detected SQL data within timeout");
                    result.setResult(true);
                    continueLoop = false;
                    continue;
                }
                long now = System.currentTimeMillis() / 1000L;
                if (iMaximumTimeout > 0L && now > timeStart + iMaximumTimeout) {
                    continueLoop = false;
                    if (this.isSuccessOnTimeout()) {
                        this.logBasic("Didn't detect SQL data before timeout, success");
                        result.setResult(true);
                    } else {
                        this.logBasic("Didn't detect SQL data before timeout, failure");
                        result.setResult(false);
                    }
                }
                long sleepTime = 0L;
                sleepTime = iMaximumTimeout == 0L ? iCycleTime : (now + iCycleTime < timeStart + iMaximumTimeout ? iCycleTime : iCycleTime - (now + iCycleTime - (timeStart + iMaximumTimeout)));
                try {
                    if (sleepTime <= 0L) continue;
                    if (this.log.isDetailed()) {
                        this.logDetailed("Sleeping " + sleepTime + " seconds before next check for SQL data");
                    }
                    Thread.sleep(sleepTime * 1000L);
                }
                catch (InterruptedException e) {
                    result.setResult(false);
                    continueLoop = false;
                }
            }
            return result;
        }
        catch (Exception e) {
            this.logBasic("Exception while waiting for SQL data: " + e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean SQLDataOK(Result result, long nrRowsLimit, String realSchemaName, String realTableName, String customSQL) throws KettleException {
        String countStatement = null;
        long rowsCount = 0L;
        boolean successOK = false;
        List ar = null;
        RowMetaInterface rowMeta = null;
        Database db = new Database((LoggingObjectInterface)this, this.connection);
        db.shareVariablesWith((VariableSpace)this);
        try {
            Object var16_14;
            block27: {
                try {
                    block30: {
                        block29: {
                            db.connect();
                            countStatement = this.iscustomSQL ? customSQL : (!Const.isEmpty((String)realSchemaName) ? selectCount + db.getDatabaseMeta().getQuotedSchemaTableCombination(realSchemaName, realTableName) : selectCount + db.getDatabaseMeta().quoteField(realTableName));
                            if (countStatement == null) break block27;
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryWaitForSQL.Log.RunSQLStatement", (String[])new String[]{countStatement}));
                            }
                            if (!this.iscustomSQL) break block29;
                            ar = db.getRows(countStatement, 0);
                            if (ar != null) {
                                rowsCount = ar.size();
                                break block30;
                            } else if (this.log.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryWaitForSQL.Log.customSQLreturnedNothing", (String[])new String[]{countStatement}));
                            }
                            break block30;
                        }
                        RowMetaAndData row = db.getOneRow(countStatement);
                        if (row != null) {
                            rowsCount = row.getInteger(0);
                        }
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryWaitForSQL.Log.NrRowsReturned", (String[])new String[]{"" + rowsCount}));
                    }
                    switch (this.successCondition) {
                        case 0: {
                            successOK = rowsCount == nrRowsLimit;
                            break;
                        }
                        case 1: {
                            successOK = rowsCount != nrRowsLimit;
                            break;
                        }
                        case 2: {
                            successOK = rowsCount < nrRowsLimit;
                            break;
                        }
                        case 3: {
                            successOK = rowsCount <= nrRowsLimit;
                            break;
                        }
                        case 4: {
                            successOK = rowsCount > nrRowsLimit;
                            break;
                        }
                        case 5: {
                            successOK = rowsCount >= nrRowsLimit;
                            break;
                        }
                    }
                }
                catch (KettleDatabaseException dbe) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryWaitForSQL.Error.RunningEntry", (String[])new String[]{dbe.getMessage()}));
                    var16_14 = null;
                    if (db != null) {
                        if (this.isAddRowsResult && this.iscustomSQL && ar != null) {
                            rowMeta = db.getQueryFields(countStatement, false);
                        }
                        db.disconnect();
                    }
                }
                {
                }
            }
            var16_14 = null;
            if (db != null) {
                if (this.isAddRowsResult && this.iscustomSQL && ar != null) {
                    rowMeta = db.getQueryFields(countStatement, false);
                }
                db.disconnect();
            }
        }
        catch (Throwable throwable) {
            Object var16_15 = null;
            if (db != null) {
                if (this.isAddRowsResult && this.iscustomSQL && ar != null) {
                    rowMeta = db.getQueryFields(countStatement, false);
                }
                db.disconnect();
            }
            throw throwable;
        }
        if (successOK && this.isAddRowsResult && this.iscustomSQL && ar != null) {
            ArrayList<RowMetaAndData> rows = new ArrayList<RowMetaAndData>();
            for (int i = 0; i < ar.size(); ++i) {
                rows.add(new RowMetaAndData(rowMeta, (Object[])ar.get(i)));
            }
            if (rows != null) {
                result.getRows().addAll(rows);
            }
        }
        return successOK;
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (this.connection != null) {
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(this.connection.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "WaitForSQL", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

