/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.writetofile;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryWriteToFile
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryWriteToFile.class;
    private String filename = null;
    private boolean createParentFolder = false;
    private boolean appendFile = false;
    private String content = null;
    private String encoding = null;

    public JobEntryWriteToFile(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryWriteToFile() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryWriteToFile je = (JobEntryWriteToFile)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createParentFolder", (boolean)this.createParentFolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"appendFile", (boolean)this.appendFile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"content", (String)this.content));
        retval.append("      ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.filename = XMLHandler.getTagValue((Node)entrynode, (String)"filename");
            this.createParentFolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createParentFolder"));
            this.appendFile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"appendFile"));
            this.content = XMLHandler.getTagValue((Node)entrynode, (String)"content");
            this.encoding = XMLHandler.getTagValue((Node)entrynode, (String)"encoding");
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'create file' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "filename");
            this.createParentFolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createParentFolder");
            this.appendFile = rep.getJobEntryAttributeBoolean(id_jobentry, "appendFile");
            this.content = rep.getJobEntryAttributeString(id_jobentry, "content");
            this.encoding = rep.getJobEntryAttributeString(id_jobentry, "encoding");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'create file' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "filename", this.filename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "createParentFolder", this.createParentFolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "appendFile", this.appendFile);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "content", this.content);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "encoding", this.encoding);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'create file' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getRealFilename() {
        return this.environmentSubstitute(this.getFilename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result;
        block23: {
            block24: {
                Exception ex222;
                FileOutputStream fos;
                OutputStreamWriter osw;
                String realFilename;
                block21: {
                    result = previousResult;
                    result.setResult(false);
                    result.setNrErrors(1L);
                    realFilename = this.getRealFilename();
                    if (Const.isEmpty((String)realFilename)) break block24;
                    String content = this.environmentSubstitute(this.getContent());
                    String encoding = this.environmentSubstitute(this.getEncoding());
                    osw = null;
                    fos = null;
                    this.createParentFolder(realFilename);
                    fos = new FileOutputStream(realFilename, this.isAppendFile());
                    if (Const.isEmpty((String)encoding)) {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"JobWriteToFile.Log.WritingToFile", (String[])new String[]{realFilename}));
                        }
                        osw = new OutputStreamWriter(fos);
                    } else {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"JobWriteToFile.Log.WritingToFileWithEncoding", (String[])new String[]{realFilename, encoding}));
                        }
                        osw = new OutputStreamWriter((OutputStream)fos, encoding);
                    }
                    osw.write(content);
                    result.setResult(true);
                    result.setNrErrors(0L);
                    Object var11_9 = null;
                    if (osw == null) break block21;
                    try {
                        osw.flush();
                        osw.close();
                    }
                    catch (Exception ex222) {
                        // empty catch block
                    }
                }
                if (fos != null) {
                    try {
                        fos.flush();
                        fos.close();
                    }
                    catch (Exception ex222) {}
                }
                break block23;
                {
                    catch (Exception e) {
                        Exception ex222;
                        this.logError(BaseMessages.getString(PKG, (String)"JobWriteToFile.Error.WritingFile", (String[])new String[]{realFilename, e.getMessage()}));
                        Object var11_10 = null;
                        if (osw != null) {
                            try {
                                osw.flush();
                                osw.close();
                            }
                            catch (Exception ex222) {
                                // empty catch block
                            }
                        }
                        if (fos != null) {
                            try {
                                fos.flush();
                                fos.close();
                            }
                            catch (Exception ex222) {}
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    Exception ex222;
                    Object var11_11 = null;
                    if (osw != null) {
                        try {
                            osw.flush();
                            osw.close();
                        }
                        catch (Exception ex222) {
                            // empty catch block
                        }
                    }
                    if (fos != null) {
                        try {
                            fos.flush();
                            fos.close();
                        }
                        catch (Exception ex222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            this.logError(BaseMessages.getString(PKG, (String)"JobWriteToFile.Error.MissinfgFile", (String[])new String[0]));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createParentFolder(String realFilename) throws KettleException {
        FileObject parent = null;
        try {
            try {
                parent = KettleVFS.getFileObject((String)realFilename).getParent();
                if (!parent.exists()) {
                    if (!this.isCreateParentFolder()) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"JobWriteToFile.Log.ParentFoldetNotExist", (String[])new String[]{parent.getName().toString()}));
                    }
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobWriteToFile.Log.ParentFoldetNotExist", (String[])new String[]{parent.getName().toString()}));
                    }
                    parent.createFolder();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobWriteToFile.Log.ParentFolderCreated", (String[])new String[]{parent.getName().toString()}));
                    }
                }
                Object var5_3 = null;
                if (parent == null) return;
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"JobWriteToFile.Error.CheckingParentFolder", (String[])new String[]{realFilename}), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (parent == null) throw throwable;
            try {
                parent.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        parent.close();
        return;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public boolean isAppendFile() {
        return this.appendFile;
    }

    public void setAppendFile(boolean appendFile) {
        this.appendFile = appendFile;
    }

    public boolean isCreateParentFolder() {
        return this.createParentFolder;
    }

    public void setCreateParentFolder(boolean createParentFolder) {
        this.createParentFolder = createParentFolder;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.getFilename())) {
            String realFileName = jobMeta.environmentSubstitute(this.getFilename());
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

