/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.zipfile;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.FileDoesNotExistValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryZipFile
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryZipFile.class;
    private String zipFilename = null;
    public int compressionrate = 1;
    public int ifzipfileexists = 2;
    public int afterzip = 0;
    private String wildcard = null;
    private String wildcardexclude = null;
    private String sourcedirectory = null;
    private String movetodirectory = null;
    private boolean addfiletoresult = false;
    private boolean isfromprevious = false;
    private boolean createparentfolder = false;
    private boolean adddate = false;
    private boolean addtime = false;
    private boolean SpecifyFormat = false;
    private String date_time_format = null;
    private boolean createMoveToDirectory = false;
    private boolean includingSubFolders = true;

    public JobEntryZipFile(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryZipFile() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryZipFile je = (JobEntryZipFile)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(500);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"zipfilename", (String)this.zipFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"compressionrate", (int)this.compressionrate));
        retval.append("      ").append(XMLHandler.addTagValue((String)"ifzipfileexists", (int)this.ifzipfileexists));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcardexclude", (String)this.wildcardexclude));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sourcedirectory", (String)this.sourcedirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"movetodirectory", (String)this.movetodirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"afterzip", (int)this.afterzip));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addfiletoresult", (boolean)this.addfiletoresult));
        retval.append("      ").append(XMLHandler.addTagValue((String)"isfromprevious", (boolean)this.isfromprevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createparentfolder", (boolean)this.createparentfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"adddate", (boolean)this.adddate));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addtime", (boolean)this.addtime));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyFormat", (boolean)this.SpecifyFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_format", (String)this.date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createMoveToDirectory", (boolean)this.createMoveToDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.includingSubFolders));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.zipFilename = XMLHandler.getTagValue((Node)entrynode, (String)"zipfilename");
            this.compressionrate = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"compressionrate"), (int)-1);
            this.ifzipfileexists = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"ifzipfileexists"), (int)-1);
            this.afterzip = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"afterzip"), (int)-1);
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.wildcardexclude = XMLHandler.getTagValue((Node)entrynode, (String)"wildcardexclude");
            this.sourcedirectory = XMLHandler.getTagValue((Node)entrynode, (String)"sourcedirectory");
            this.movetodirectory = XMLHandler.getTagValue((Node)entrynode, (String)"movetodirectory");
            this.addfiletoresult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addfiletoresult"));
            this.isfromprevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"isfromprevious"));
            this.createparentfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createparentfolder"));
            this.adddate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"adddate"));
            this.addtime = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addtime"));
            this.SpecifyFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"SpecifyFormat"));
            this.date_time_format = XMLHandler.getTagValue((Node)entrynode, (String)"date_time_format");
            this.createMoveToDirectory = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createMoveToDirectory"));
            this.includingSubFolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryZipFile.UnableLoadJobEntryXML", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.zipFilename = rep.getJobEntryAttributeString(id_jobentry, "zipfilename");
            this.compressionrate = (int)rep.getJobEntryAttributeInteger(id_jobentry, "compressionrate");
            this.ifzipfileexists = (int)rep.getJobEntryAttributeInteger(id_jobentry, "ifzipfileexists");
            this.afterzip = (int)rep.getJobEntryAttributeInteger(id_jobentry, "afterzip");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.wildcardexclude = rep.getJobEntryAttributeString(id_jobentry, "wildcardexclude");
            this.sourcedirectory = rep.getJobEntryAttributeString(id_jobentry, "sourcedirectory");
            this.movetodirectory = rep.getJobEntryAttributeString(id_jobentry, "movetodirectory");
            this.addfiletoresult = rep.getJobEntryAttributeBoolean(id_jobentry, "addfiletoresult");
            this.isfromprevious = rep.getJobEntryAttributeBoolean(id_jobentry, "isfromprevious");
            this.createparentfolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createparentfolder");
            this.adddate = rep.getJobEntryAttributeBoolean(id_jobentry, "adddate");
            this.addtime = rep.getJobEntryAttributeBoolean(id_jobentry, "addtime");
            this.SpecifyFormat = rep.getJobEntryAttributeBoolean(id_jobentry, "SpecifyFormat");
            this.date_time_format = rep.getJobEntryAttributeString(id_jobentry, "date_time_format");
            this.createMoveToDirectory = rep.getJobEntryAttributeBoolean(id_jobentry, "createMoveToDirectory");
            this.includingSubFolders = rep.getJobEntryAttributeBoolean(id_jobentry, "include_subfolders");
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryZipFile.UnableLoadJobEntryRep", (String[])new String[]{"" + id_jobentry}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "zipfilename", this.zipFilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "compressionrate", this.compressionrate);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "ifzipfileexists", this.ifzipfileexists);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "afterzip", this.afterzip);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcardexclude", this.wildcardexclude);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "sourcedirectory", this.sourcedirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "movetodirectory", this.movetodirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "addfiletoresult", this.addfiletoresult);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "isfromprevious", this.isfromprevious);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "createparentfolder", this.createparentfolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "addtime", this.addtime);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "adddate", this.adddate);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "SpecifyFormat", this.SpecifyFormat);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "date_time_format", this.date_time_format);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "createMoveToDirectory", this.createMoveToDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "include_subfolders", this.includingSubFolders);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryZipFile.UnableSaveJobEntryRep", (String[])new String[]{"" + id_job}), (Throwable)dbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean createParentFolder(String filename) {
        FileObject parentfolder = null;
        boolean result = false;
        parentfolder = KettleVFS.getFileObject((String)filename, (VariableSpace)this).getParent();
        if (!parentfolder.exists()) {
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryZipFile.CanNotFindFolder", (String[])new String[]{"" + parentfolder.getName()}));
            }
            parentfolder.createFolder();
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryZipFile.FolderCreated", (String[])new String[]{"" + parentfolder.getName()}));
            }
        } else if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryZipFile.FolderExists", (String[])new String[]{"" + parentfolder.getName()}));
        }
        result = true;
        Object var6_4 = null;
        if (parentfolder == null) return result;
        try {
            parentfolder.close();
            parentfolder = null;
            return result;
        }
        catch (Exception ex) {}
        return result;
        {
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryZipFile.CanNotCreateFolder", (String[])new String[]{"" + parentfolder.getName()}), e);
                Object var6_5 = null;
                if (parentfolder == null) return result;
                try {
                    parentfolder.close();
                    parentfolder = null;
                    return result;
                }
                catch (Exception ex) {}
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (parentfolder == null) throw throwable;
            try {
                parentfolder.close();
                parentfolder = null;
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean processRowFile(Job parentJob, Result result, String realZipfilename, String realWildcard, String realWildcardExclude, String realSourceDirectoryOrFile, String realMovetodirectory, boolean createparentfolder) {
        block99: {
            block101: {
                block98: {
                    block96: {
                        block102: {
                            block95: {
                                Fileexists = false;
                                tempFile = null;
                                fileZip = null;
                                resultat = false;
                                renameOk = false;
                                orginExist = false;
                                originFile = null;
                                zin = null;
                                buffer = null;
                                dest = null;
                                buff = null;
                                out = null;
                                entry = null;
                                localSourceFilename = realSourceDirectoryOrFile;
                                try {
                                    originFile = KettleVFS.getFileObject((String)realSourceDirectoryOrFile, (VariableSpace)this);
                                    localSourceFilename = KettleVFS.getFilename((FileObject)originFile);
                                    orginExist = originFile.exists();
                                    var25_23 = null;
                                    ** if (originFile == null) goto lbl-1000
                                }
                                catch (Throwable var24_30) {
                                    var25_24 = null;
                                    if (originFile != null) {
                                        try {
                                            originFile.close();
                                        }
                                        catch (IOException ex) {
                                            // empty catch block
                                        }
                                    }
                                    throw var24_30;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    try {
                                        originFile.close();
                                    }
                                    catch (IOException ex) {}
                                }
lbl-1000:
                                // 2 sources

                                {
                                    break block95;
                                    catch (Exception e) {
                                        var25_23 = null;
                                        if (originFile != null) {
                                            try {
                                                originFile.close();
                                            }
                                            catch (IOException ex) {}
                                        }
                                    }
                                }
                            }
                            localrealZipfilename = realZipfilename;
                            if (realZipfilename == null || !orginExist) break block101;
                            fileObject = null;
                            fileObject = KettleVFS.getFileObject((String)localrealZipfilename, (VariableSpace)this);
                            localrealZipfilename = KettleVFS.getFilename((FileObject)fileObject);
                            if (fileObject.exists()) {
                                Fileexists = true;
                                if (this.log.isDebug()) {
                                    this.logDebug(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Zip_FileExists1.Label", (String[])new String[0]) + localrealZipfilename + BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Zip_FileExists2.Label", (String[])new String[0]));
                                }
                            }
                            if (createparentfolder) {
                                this.createParentFolder(localrealZipfilename);
                            }
                            if (this.ifzipfileexists == 3 && Fileexists) {
                                resultat = false;
                                break block96;
                            }
                            if (this.ifzipfileexists == 2 && Fileexists) {
                                if (this.addfiletoresult) {
                                    resultFile = new ResultFile(0, fileObject, parentJob.getJobname(), this.toString());
                                    result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                                }
                                resultat = true;
                                break block96;
                            }
                            if (this.afterzip == 2 && realMovetodirectory == null) {
                                resultat = false;
                                this.logError(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.AfterZip_No_DestinationFolder_Defined.Label", (String[])new String[0]));
                                break block96;
                            }
                            fileList = null;
                            sourceFileOrFolder = KettleVFS.getFileObject((String)localSourceFilename);
                            isSourceDirectory = sourceFileOrFolder.getType().equals(FileType.FOLDER);
                            if (isSourceDirectory) {
                                pattern = Const.isEmpty((String)realWildcard) == false ? Pattern.compile(realWildcard) : null;
                                patternexclude = Const.isEmpty((String)realWildcardExclude) == false ? Pattern.compile(realWildcardExclude) : null;
                                fileList = this.includingSubFolders ? sourceFileOrFolder.findFiles(new FileSelector(){

                                    public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
                                        return true;
                                    }

                                    public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
                                        boolean include;
                                        if (fileInfo.getFile().getType().equals(FileType.FILE)) {
                                            String name;
                                            include = true;
                                            if (pattern != null) {
                                                name = fileInfo.getFile().getName().getPath();
                                                include = pattern.matcher(name).matches();
                                            }
                                            if (include && patternexclude != null) {
                                                name = fileInfo.getFile().getName().getPath();
                                                include = !pattern.matcher(name).matches();
                                            }
                                        } else {
                                            include = false;
                                        }
                                        return include;
                                    }
                                }) : sourceFileOrFolder.getChildren();
                            } else {
                                pattern = null;
                                patternexclude = null;
                                fileList = new FileObject[]{sourceFileOrFolder};
                            }
                            if (fileList.length == 0) {
                                resultat = false;
                                this.logError(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Log.FolderIsEmpty", (String[])new String[]{localSourceFilename}));
                                break block96;
                            }
                            if (!this.checkContainsFile(localSourceFilename, fileList, isSourceDirectory)) {
                                resultat = false;
                                this.logError(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Log.NoFilesInFolder", (String[])new String[]{localSourceFilename}));
                                break block96;
                            }
                            if (this.ifzipfileexists == 0 && Fileexists) {
                                if (localrealZipfilename.toLowerCase().endsWith(".zip")) {
                                    localrealZipfilename = localrealZipfilename.substring(0, localrealZipfilename.length() - 4);
                                }
                                localrealZipfilename = localrealZipfilename + "_" + StringUtil.getFormattedDateTimeNow((boolean)true) + ".zip";
                                if (this.log.isDebug()) {
                                    this.logDebug(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Zip_FileNameChange1.Label", (String[])new String[0]) + localrealZipfilename + BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Zip_FileNameChange1.Label", (String[])new String[0]));
                                }
                            } else if (this.ifzipfileexists == 1 && Fileexists) {
                                fileZip = this.getFile(localrealZipfilename);
                                tempFile = File.createTempFile(fileZip.getName(), null);
                                tempFile.delete();
                                renameOk = fileZip.renameTo(tempFile);
                                if (!renameOk) {
                                    this.logError(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Cant_Rename_Temp1.Label", (String[])new String[0]) + fileZip.getAbsolutePath() + BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Cant_Rename_Temp2.Label", (String[])new String[0]) + tempFile.getAbsolutePath() + BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Cant_Rename_Temp3.Label", (String[])new String[0]));
                                }
                                if (this.log.isDebug()) {
                                    this.logDebug(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Zip_FileAppend1.Label", (String[])new String[0]) + localrealZipfilename + BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Zip_FileAppend2.Label", (String[])new String[0]));
                                }
                            }
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Files_Found1.Label", (String[])new String[0]) + fileList.length + BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Files_Found2.Label", (String[])new String[0]) + localSourceFilename + BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Files_Found3.Label", (String[])new String[0]));
                            }
                            buffer = new byte[18024];
                            dest = KettleVFS.getOutputStream((String)localrealZipfilename, (boolean)false);
                            buff = new BufferedOutputStream(dest);
                            out = new ZipOutputStream(buff);
                            fileSet = new HashSet<String>();
                            if (renameOk) {
                                zin = new ZipInputStream(new FileInputStream(tempFile));
                                entry = zin.getNextEntry();
                                while (entry != null) {
                                    name = entry.getName();
                                    if (!fileSet.contains(name)) {
                                        out.putNextEntry(new ZipEntry(name));
                                        while ((len = zin.read(buffer)) > 0) {
                                            out.write(buffer, 0, len);
                                        }
                                        fileSet.add(name);
                                    }
                                    entry = zin.getNextEntry();
                                }
                                zin.close();
                            }
                            out.setMethod(8);
                            if (this.compressionrate == 0) {
                                out.setLevel(0);
                            } else if (this.compressionrate == 1) {
                                out.setLevel(-1);
                            }
                            if (this.compressionrate == 2) {
                                out.setLevel(9);
                            }
                            if (this.compressionrate == 3) {
                                out.setLevel(1);
                            }
                            zippedFiles = new FileObject[fileList.length];
                            fileNum = 0;
                            for (i = 0; i < fileList.length && !parentJob.isStopped(); ++i) {
                                getIt = true;
                                getItexclude = false;
                                if (isSourceDirectory) {
                                    filename = this.includingSubFolders != false ? fileList[i].getName().getPath() : fileList[i].getName().getBaseName();
                                    if (pattern != null) {
                                        matcher = pattern.matcher(filename);
                                        getIt = matcher.matches();
                                    }
                                    if (patternexclude != null) {
                                        matcherexclude = patternexclude.matcher(filename);
                                        getItexclude = matcherexclude.matches();
                                    }
                                }
                                targetFilename = KettleVFS.getFilename((FileObject)fileList[i]);
                                if (sourceFileOrFolder.getType().equals(FileType.FILE)) {
                                    targetFilename = localSourceFilename;
                                }
                                v0 = isTargetDirectory = (file = KettleVFS.getFileObject((String)targetFilename)).exists() != false && file.getType().equals(FileType.FOLDER) != false;
                                if (!getIt || getItexclude || isTargetDirectory || fileSet.contains(targetFilename)) continue;
                                if (this.log.isDebug()) {
                                    this.logDebug(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Add_FilesToZip1.Label", (String[])new String[0]) + fileList[i] + BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Add_FilesToZip2.Label", (String[])new String[0]) + localSourceFilename + BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Add_FilesToZip3.Label", (String[])new String[0]));
                                }
                                in = KettleVFS.getInputStream((FileObject)file);
                                fullName = fileList[i].getName().getPath();
                                basePath = sourceFileOrFolder.getName().getPath();
                                relativeName = isSourceDirectory ? (fullName.startsWith(basePath) ? fullName.substring(basePath.length() + 1) : fullName) : fileList[i].getName().getBaseName();
                                out.putNextEntry(new ZipEntry(relativeName));
                                while ((len = in.read(buffer)) > 0) {
                                    out.write(buffer, 0, len);
                                }
                                out.flush();
                                out.closeEntry();
                                in.close();
                                zippedFiles[fileNum] = fileList[i];
                                ++fileNum;
                            }
                            out.close();
                            buff.close();
                            dest.close();
                            if (this.log.isBasic()) {
                                this.logBasic(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Log.TotalZippedFiles", (String[])new String[]{"" + zippedFiles.length}));
                            }
                            if (tempFile != null) {
                                tempFile.delete();
                            }
                            if (this.afterzip != 1 && this.afterzip != 2) break block102;
                            for (i = 0; i < zippedFiles.length; ++i) {
                                block97: {
                                    if (zippedFiles[i] == null) continue;
                                    fileObjectd = zippedFiles[i];
                                    if (!isSourceDirectory) {
                                        fileObjectd = KettleVFS.getFileObject((String)localSourceFilename);
                                    }
                                    if (this.afterzip == 1) {
                                        deleted = fileObjectd.delete();
                                        if (!deleted) {
                                            resultat = false;
                                            this.logError(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Cant_Delete_File1.Label", (String[])new String[0]) + localSourceFilename + Const.FILE_SEPARATOR + zippedFiles[i] + BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Cant_Delete_File2.Label", (String[])new String[0]));
                                        }
                                        if (!this.log.isDebug()) continue;
                                        this.logDebug(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.File_Deleted1.Label", (String[])new String[0]) + localSourceFilename + Const.FILE_SEPARATOR + zippedFiles[i] + BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.File_Deleted2.Label", (String[])new String[0]));
                                        continue;
                                    }
                                    if (this.afterzip != 2) continue;
                                    fileObjectm = null;
                                    fileObjectm = KettleVFS.getFileObject((String)(realMovetodirectory + Const.FILE_SEPARATOR + fileObjectd.getName().getBaseName()));
                                    fileObjectd.moveTo(fileObjectm);
                                    var45_56 = null;
                                    try {
                                        if (fileObjectm != null) {
                                            fileObjectm.close();
                                        }
                                        break block97;
                                    }
                                    catch (Exception e) {}
                                    break block97;
                                    {
                                        catch (IOException e) {
                                            this.logError(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Cant_Move_File1.Label", (String[])new String[0]) + zippedFiles[i] + BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Cant_Move_File2.Label", (String[])new String[0]) + e.getMessage());
                                            resultat = false;
                                            var45_56 = null;
                                            try {
                                                if (fileObjectm != null) {
                                                    fileObjectm.close();
                                                }
                                                break block97;
                                            }
                                            catch (Exception e) {}
                                        }
                                    }
                                    catch (Throwable var44_58) {
                                        var45_56 = null;
                                        try {
                                            if (fileObjectm != null) {
                                                fileObjectm.close();
                                            }
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                        throw var44_58;
                                    }
                                }
                                if (!this.log.isDebug()) continue;
                                this.logDebug(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.File_Moved1.Label", (String[])new String[0]) + zippedFiles[i] + BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.File_Moved2.Label", (String[])new String[0]));
                            }
                        }
                        if (this.addfiletoresult) {
                            resultFile = new ResultFile(0, fileObject, parentJob.getJobname(), this.toString());
                            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                        }
                        resultat = true;
                    }
                    var48_59 = null;
                    if (fileObject == null) break block98;
                    try {
                        fileObject.close();
                        fileObject = null;
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (buff != null) {
                        buff.close();
                    }
                    if (dest != null) {
                        dest.close();
                    }
                    if (zin != null) {
                        zin.close();
                    }
                    if (entry != null) {
                        entry = null;
                    }
                    break block99;
                }
                catch (IOException ex) {}
                break block99;
                {
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Cant_CreateZipFile1.Label", (String[])new String[0]) + localrealZipfilename + BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Cant_CreateZipFile2.Label", (String[])new String[0]) + e.getMessage());
                        resultat = false;
                        var48_60 = null;
                        if (fileObject != null) {
                            try {
                                fileObject.close();
                                fileObject = null;
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                        }
                        try {
                            if (out != null) {
                                out.close();
                            }
                            if (buff != null) {
                                buff.close();
                            }
                            if (dest != null) {
                                dest.close();
                            }
                            if (zin != null) {
                                zin.close();
                            }
                            if (entry != null) {
                                entry = null;
                            }
                            break block99;
                        }
                        catch (IOException ex) {}
                        break block99;
                    }
                }
                catch (Throwable var47_65) {
                    var48_61 = null;
                    if (fileObject != null) {
                        try {
                            fileObject.close();
                            fileObject = null;
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    try {
                        if (out != null) {
                            out.close();
                        }
                        if (buff != null) {
                            buff.close();
                        }
                        if (dest != null) {
                            dest.close();
                        }
                        if (zin != null) {
                            zin.close();
                        }
                        if (entry != null) {
                            entry = null;
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    throw var47_65;
                }
            }
            resultat = true;
            if (localrealZipfilename == null) {
                this.logError(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.No_ZipFile_Defined.Label", (String[])new String[0]));
            }
            if (!orginExist) {
                this.logError(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.No_FolderCible_Defined.Label", (String[])new String[]{localSourceFilename}));
            }
        }
        return resultat;
    }

    private File getFile(String filename) {
        try {
            URI uri = new URI(filename);
            return new File(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(filename);
        }
    }

    private boolean checkContainsFile(String realSourceDirectoryOrFile, FileObject[] filelist, boolean isDirectory) throws FileSystemException {
        boolean retval = false;
        for (int i = 0; i < filelist.length; ++i) {
            FileObject file = filelist[i];
            if (!file.exists() || !file.getType().equals(FileType.FILE)) continue;
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        block36: {
            result = previousResult;
            rows = result.getRows();
            realZipfilename = null;
            realWildcard = null;
            realWildcardExclude = null;
            realTargetdirectory = null;
            realMovetodirectory = this.environmentSubstitute(this.movetodirectory);
            SanityControlOK = true;
            if (this.afterzip == 2) {
                if (Const.isEmpty((String)realMovetodirectory)) {
                    SanityControlOK = false;
                    this.logError(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.AfterZip_No_DestinationFolder_Defined.Label", (String[])new String[0]));
                } else {
                    moveToDirectory = null;
                    try {
                        block35: {
                            moveToDirectory = KettleVFS.getFileObject((String)realMovetodirectory, (VariableSpace)this);
                            if (moveToDirectory.exists()) {
                                if (moveToDirectory.getType() == FileType.FOLDER) {
                                    if (this.log.isDetailed()) {
                                        this.logDetailed(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Log.MoveToFolderExist", (String[])new String[]{realMovetodirectory}));
                                    }
                                } else {
                                    SanityControlOK = false;
                                    this.logError(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Log.MoveToFolderNotFolder", (String[])new String[]{realMovetodirectory}));
                                }
                                break block35;
                            }
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Log.MoveToFolderNotNotExist", (String[])new String[]{realMovetodirectory}));
                            }
                            if (this.createMoveToDirectory) {
                                moveToDirectory.createFolder();
                                if (this.log.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Log.MoveToFolderCreaterd", (String[])new String[]{realMovetodirectory}));
                                }
                                break block35;
                            }
                            SanityControlOK = false;
                            this.logError(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.Log.MoveToFolderNotNotExist", (String[])new String[]{realMovetodirectory}));
                        }
                        var14_14 = null;
                        ** if (moveToDirectory == null) goto lbl-1000
                    }
                    catch (Throwable var13_20) {
                        var14_15 = null;
                        if (moveToDirectory != null) {
                            realMovetodirectory = KettleVFS.getFilename((FileObject)moveToDirectory);
                            try {
                                moveToDirectory.close();
                                moveToDirectory = null;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        throw var13_20;
                    }
lbl-1000:
                    // 1 sources

                    {
                        realMovetodirectory = KettleVFS.getFilename((FileObject)moveToDirectory);
                        try {
                            moveToDirectory.close();
                            moveToDirectory = null;
                        }
                        catch (Exception e) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block36;
                        catch (Exception e) {
                            SanityControlOK = false;
                            this.logError(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.ErrorGettingMoveToFolder.Label", (String[])new String[]{realMovetodirectory}), e);
                            var14_14 = null;
                            if (moveToDirectory != null) {
                                realMovetodirectory = KettleVFS.getFilename((FileObject)moveToDirectory);
                                try {
                                    moveToDirectory.close();
                                    moveToDirectory = null;
                                }
                                catch (Exception e) {}
                            }
                        }
                    }
                }
            }
        }
        if (!SanityControlOK) {
            result.setNrErrors(1L);
            result.setResult(false);
            return result;
        }
        if (this.isfromprevious && this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(JobEntryZipFile.PKG, (String)"JobZipFiles.ArgFromPrevious.Found", (String[])new String[]{(rows != null ? rows.size() : 0) + ""}));
        }
        if (this.isfromprevious && rows != null) {
            try {
                for (iteration = 0; iteration < rows.size() && !this.parentJob.isStopped(); ++iteration) {
                    resultRow = (RowMetaAndData)rows.get(iteration);
                    realTargetdirectory = resultRow.getString(0, null);
                    if (!Const.isEmpty((String)realTargetdirectory)) {
                        if (!Const.isEmpty((String)resultRow.getString(1, null))) {
                            realWildcard = resultRow.getString(1, null);
                        }
                        if (!Const.isEmpty((String)resultRow.getString(2, null))) {
                            realWildcardExclude = resultRow.getString(2, null);
                        }
                        if (!Const.isEmpty((String)(realZipfilename = resultRow.getString(3, null)))) {
                            if (this.processRowFile(this.parentJob, result, realZipfilename, realWildcard, realWildcardExclude, realTargetdirectory, realMovetodirectory, this.createparentfolder)) continue;
                            result.setResult(false);
                            return result;
                        }
                        this.logError("destination zip filename is empty! Ignoring row...");
                        continue;
                    }
                    this.logError("Target directory is empty! Ignoring row...");
                }
            }
            catch (Exception e) {
                this.logError("Erreur during process!", e);
            }
        } else if (!this.isfromprevious) {
            if (!Const.isEmpty((String)this.sourcedirectory)) {
                realZipfilename = this.getFullFilename(this.environmentSubstitute(this.zipFilename), this.adddate, this.addtime, this.SpecifyFormat, this.date_time_format);
                realWildcard = this.environmentSubstitute(this.wildcard);
                realWildcardExclude = this.environmentSubstitute(this.wildcardexclude);
                realTargetdirectory = this.environmentSubstitute(this.sourcedirectory);
                result.setResult(this.processRowFile(this.parentJob, result, realZipfilename, realWildcard, realWildcardExclude, realTargetdirectory, realMovetodirectory, this.createparentfolder));
            } else {
                this.logError("Source folder/file is empty! Ignoring row...");
            }
        }
        return result;
    }

    public String getFullFilename(String filename, boolean add_date, boolean add_time, boolean specify_format, String datetime_folder) {
        String retval = "";
        if (Const.isEmpty((String)filename)) {
            return null;
        }
        String realfilename = this.environmentSubstitute(filename);
        int lenstring = realfilename.length();
        int lastindexOfDot = realfilename.lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        retval = realfilename.substring(0, lastindexOfDot);
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (specify_format && !Const.isEmpty((String)datetime_folder)) {
            daf.applyPattern(datetime_folder);
            String dt = daf.format(now);
            retval = retval + dt;
        } else {
            if (add_date) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                retval = retval + "_" + d;
            }
            if (add_time) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                retval = retval + "_" + t;
            }
        }
        retval = retval + realfilename.substring(lastindexOfDot, lenstring);
        return retval;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public void setZipFilename(String zipFilename) {
        this.zipFilename = zipFilename;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public void setWildcardExclude(String wildcardexclude) {
        this.wildcardexclude = wildcardexclude;
    }

    public void setSourceDirectory(String sourcedirectory) {
        this.sourcedirectory = sourcedirectory;
    }

    public void setMoveToDirectory(String movetodirectory) {
        this.movetodirectory = movetodirectory;
    }

    public String getSourceDirectory() {
        return this.sourcedirectory;
    }

    public String getMoveToDirectory() {
        return this.movetodirectory;
    }

    public String getZipFilename() {
        return this.zipFilename;
    }

    public boolean isCreateMoveToDirectory() {
        return this.createMoveToDirectory;
    }

    public void setCreateMoveToDirectory(boolean createMoveToDirectory) {
        this.createMoveToDirectory = createMoveToDirectory;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public String getWildcardExclude() {
        return this.wildcardexclude;
    }

    public void setAddFileToResult(boolean addfiletoresultin) {
        this.addfiletoresult = addfiletoresultin;
    }

    public boolean isAddFileToResult() {
        return this.addfiletoresult;
    }

    public void setcreateparentfolder(boolean createparentfolder) {
        this.createparentfolder = createparentfolder;
    }

    public void setDateInFilename(boolean adddate) {
        this.adddate = adddate;
    }

    public boolean isDateInFilename() {
        return this.adddate;
    }

    public void setTimeInFilename(boolean addtime) {
        this.addtime = addtime;
    }

    public boolean isTimeInFilename() {
        return this.addtime;
    }

    public boolean isSpecifyFormat() {
        return this.SpecifyFormat;
    }

    public void setSpecifyFormat(boolean SpecifyFormat) {
        this.SpecifyFormat = SpecifyFormat;
    }

    public String getDateTimeFormat() {
        return this.date_time_format;
    }

    public void setDateTimeFormat(String date_time_format) {
        this.date_time_format = date_time_format;
    }

    public boolean getcreateparentfolder() {
        return this.createparentfolder;
    }

    public void setDatafromprevious(boolean isfromprevious) {
        this.isfromprevious = isfromprevious;
    }

    public boolean getDatafromprevious() {
        return this.isfromprevious;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        ValidatorContext ctx1 = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx1, this.getVariables());
        AndValidator.putValidators(ctx1, JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileDoesNotExistValidator());
        if (3 == this.ifzipfileexists) {
            FileDoesNotExistValidator.putFailIfExists(ctx1, true);
        }
        JobEntryValidatorUtils.andValidator().validate(this, "zipFilename", remarks, ctx1);
        if (2 == this.afterzip) {
            JobEntryValidatorUtils.andValidator().validate(this, "moveToDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        }
        JobEntryValidatorUtils.andValidator().validate(this, "sourceDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }

    public boolean isIncludingSubFolders() {
        return this.includingSubFolders;
    }

    public void setIncludingSubFolders(boolean includesSubFolders) {
        this.includingSubFolders = includesSubFolders;
    }
}

