/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entry;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.changed.ChangedFlagInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleStepLoaderException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.gui.GUIPositionInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryCopy
implements Cloneable,
XMLInterface,
GUIPositionInterface,
ChangedFlagInterface {
    private static final String XML_TAG = "entry";
    private JobEntryInterface entry;
    private int nr;
    private boolean selected;
    private Point location;
    private boolean launchingInParallel;
    private boolean draw;
    private ObjectId id;
    private JobMeta parentJobMeta;

    public JobEntryCopy() {
        this.clear();
    }

    public JobEntryCopy(JobEntryInterface entry) {
        this.setEntry(entry);
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    ").append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        retval.append(this.entry.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"parallel", (boolean)this.launchingInParallel));
        retval.append("      ").append(XMLHandler.addTagValue((String)"draw", (boolean)this.draw));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr", (int)this.nr));
        retval.append("      ").append(XMLHandler.addTagValue((String)"xloc", (int)this.location.x));
        retval.append("      ").append(XMLHandler.addTagValue((String)"yloc", (int)this.location.y));
        retval.append("      ").append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return retval.toString();
    }

    public JobEntryCopy(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            String stype = XMLHandler.getTagValue((Node)entrynode, (String)"type");
            PluginRegistry registry = PluginRegistry.getInstance();
            PluginInterface jobPlugin = registry.findPluginWithId(JobEntryPluginType.class, stype);
            if (jobPlugin == null) {
                throw new KettleStepLoaderException("No valid step/plugin specified (jobPlugin=null) for " + stype);
            }
            this.entry = (JobEntryInterface)registry.loadClass(jobPlugin, JobEntryInterface.class);
            if (this.entry != null) {
                this.entry.setPluginId(jobPlugin.getIds()[0]);
                this.entry.loadXML(entrynode, databases, slaveServers, rep);
                this.setNr(Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"nr"), (int)0));
                this.setLaunchingInParallel("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"parallel")));
                this.setDrawn("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"draw")));
                int x = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"xloc"), (int)0);
                int y = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"yloc"), (int)0);
                this.setLocation(x, y);
            }
        }
        catch (Throwable e) {
            String message = "Unable to read Job Entry copy info from XML node : " + e.toString();
            throw new KettleXMLException(message, e);
        }
    }

    public void clear() {
        this.location = null;
        this.entry = null;
        this.nr = 0;
        this.launchingInParallel = false;
        this.setObjectId(null);
    }

    public Object clone() {
        JobEntryCopy ge = new JobEntryCopy();
        ge.replaceMeta(this);
        ge.setObjectId(null);
        return ge;
    }

    public void replaceMeta(JobEntryCopy jobEntryCopy) {
        this.entry = jobEntryCopy.entry;
        this.nr = jobEntryCopy.nr;
        this.selected = jobEntryCopy.selected;
        if (jobEntryCopy.location != null) {
            this.location = new Point(jobEntryCopy.location.x, jobEntryCopy.location.y);
        }
        this.launchingInParallel = jobEntryCopy.launchingInParallel;
        this.draw = jobEntryCopy.draw;
        this.id = jobEntryCopy.id;
    }

    public Object clone_deep() {
        JobEntryCopy ge = (JobEntryCopy)this.clone();
        ge.entry = (JobEntryInterface)this.entry.clone();
        return ge;
    }

    public void setObjectId(ObjectId id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        JobEntryCopy je = (JobEntryCopy)o;
        return je.entry.getName().equalsIgnoreCase(this.entry.getName()) && je.getNr() == this.getNr();
    }

    public int hashCode() {
        return this.entry.getName().hashCode() ^ Integer.valueOf(this.getNr()).hashCode();
    }

    public ObjectId getObjectId() {
        return this.id;
    }

    public void setEntry(JobEntryInterface je) {
        this.entry = je;
        if (this.entry != null && this.entry.getPluginId() == null) {
            this.entry.setPluginId(PluginRegistry.getInstance().getPluginId(JobEntryPluginType.class, (Object)this.entry));
        }
    }

    public JobEntryInterface getEntry() {
        return this.entry;
    }

    public String getTypeDesc() {
        PluginInterface plugin = PluginRegistry.getInstance().findPluginWithId(JobEntryPluginType.class, this.entry.getPluginId());
        return plugin.getDescription();
    }

    public void setLocation(int x, int y) {
        int ny;
        int nx = x >= 0 ? x : 0;
        Point loc = new Point(nx, ny = y >= 0 ? y : 0);
        if (!loc.equals(this.location)) {
            this.setChanged();
        }
        this.location = loc;
    }

    public void setLocation(Point loc) {
        if (loc != null && !loc.equals(this.location)) {
            this.setChanged();
        }
        this.location = loc;
    }

    public Point getLocation() {
        return this.location;
    }

    @Override
    public void setChanged() {
        this.setChanged(true);
    }

    @Override
    public void setChanged(boolean ch) {
        this.entry.setChanged(ch);
    }

    @Override
    public void clearChanged() {
        this.entry.setChanged(false);
    }

    @Override
    public boolean hasChanged() {
        return this.entry.hasChanged();
    }

    public int getNr() {
        return this.nr;
    }

    public void setNr(int n) {
        this.nr = n;
    }

    public void setLaunchingInParallel(boolean p) {
        this.launchingInParallel = p;
    }

    public boolean isDrawn() {
        return this.draw;
    }

    public void setDrawn() {
        this.setDrawn(true);
    }

    public void setDrawn(boolean d) {
        this.draw = d;
    }

    public boolean isLaunchingInParallel() {
        return this.launchingInParallel;
    }

    public void setSelected(boolean sel) {
        this.selected = sel;
    }

    public void flipSelected() {
        this.selected = !this.selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setDescription(String description) {
        this.entry.setDescription(description);
    }

    public String getDescription() {
        return this.entry.getDescription();
    }

    public boolean isStart() {
        return this.entry.isStart();
    }

    public boolean isDummy() {
        return this.entry.isDummy();
    }

    public boolean isTransformation() {
        return this.entry.isTransformation();
    }

    public boolean isJob() {
        return this.entry.isJob();
    }

    public boolean evaluates() {
        if (this.entry != null) {
            return this.entry.evaluates();
        }
        return false;
    }

    public boolean isUnconditional() {
        if (this.entry != null) {
            return this.entry.isUnconditional();
        }
        return true;
    }

    public boolean isEvaluation() {
        return this.entry.isEvaluation();
    }

    public boolean isMail() {
        return this.entry.isMail();
    }

    public boolean isSpecial() {
        return this.entry.isSpecial();
    }

    public String toString() {
        if (this.entry != null) {
            return this.entry.getName() + "." + this.getNr();
        }
        return "null." + this.getNr();
    }

    public String getName() {
        if (this.entry != null) {
            return this.entry.getName();
        }
        return "null";
    }

    public void setName(String name) {
        this.entry.setName(name);
    }

    public boolean resetErrorsBeforeExecution() {
        return this.entry.resetErrorsBeforeExecution();
    }

    public JobMeta getParentJobMeta() {
        return this.parentJobMeta;
    }

    public void setParentJobMeta(JobMeta parentJobMeta) {
        this.parentJobMeta = parentJobMeta;
    }
}

