/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.partition;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.resource.ResourceHolderInterface;
import org.pentaho.di.shared.SharedObjectInterface;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionSchema
extends ChangedFlag
implements Cloneable,
SharedObjectInterface,
ResourceHolderInterface,
RepositoryElementInterface,
XMLInterface {
    public static final String XML_TAG = "partitionschema";
    public static final RepositoryObjectType REPOSITORY_ELEMENT_TYPE = RepositoryObjectType.PARTITION_SCHEMA;
    private String name;
    private List<String> partitionIDs;
    private boolean shared;
    private ObjectId id;
    private boolean dynamicallyDefined;
    private String numberOfPartitionsPerSlave;
    private ObjectRevision objectRevision;
    private Date changedDate;

    public PartitionSchema() {
        this.partitionIDs = new ArrayList<String>();
        this.changedDate = new Date();
    }

    public PartitionSchema(String name, List<String> partitionIDs) {
        this.name = name;
        this.partitionIDs = partitionIDs;
        this.changedDate = new Date();
    }

    public Object clone() {
        PartitionSchema partitionSchema = new PartitionSchema();
        partitionSchema.replaceMeta(this);
        partitionSchema.setObjectId(null);
        return partitionSchema;
    }

    public void replaceMeta(PartitionSchema partitionSchema) {
        this.name = partitionSchema.name;
        this.partitionIDs = new ArrayList<String>();
        this.partitionIDs.addAll(partitionSchema.partitionIDs);
        this.dynamicallyDefined = partitionSchema.dynamicallyDefined;
        this.numberOfPartitionsPerSlave = partitionSchema.numberOfPartitionsPerSlave;
        this.setObjectId(partitionSchema.id);
        this.setChanged(true);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.name == null) {
            return false;
        }
        return this.name.equals(((PartitionSchema)obj).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getPartitionIDs() {
        return this.partitionIDs;
    }

    public void setPartitionIDs(List<String> partitionIDs) {
        this.partitionIDs = partitionIDs;
    }

    public String getXML() {
        StringBuffer xml = new StringBuffer(200);
        xml.append("        <").append(XML_TAG).append(">").append(Const.CR);
        xml.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.name));
        for (int i = 0; i < this.partitionIDs.size(); ++i) {
            xml.append("          <partition>");
            xml.append("            ").append(XMLHandler.addTagValue((String)"id", (String)this.partitionIDs.get(i)));
            xml.append("          </partition>");
        }
        xml.append("          ").append(XMLHandler.addTagValue((String)"dynamic", (boolean)this.dynamicallyDefined));
        xml.append("          ").append(XMLHandler.addTagValue((String)"partitions_per_slave", (String)this.numberOfPartitionsPerSlave));
        xml.append("        </").append(XML_TAG).append(">").append(Const.CR);
        return xml.toString();
    }

    public PartitionSchema(Node partitionSchemaNode) {
        this.changedDate = new Date();
        this.name = XMLHandler.getTagValue((Node)partitionSchemaNode, (String)"name");
        int nrIDs = XMLHandler.countNodes((Node)partitionSchemaNode, (String)"partition");
        this.partitionIDs = new ArrayList<String>();
        for (int i = 0; i < nrIDs; ++i) {
            Node partitionNode = XMLHandler.getSubNodeByNr((Node)partitionSchemaNode, (String)"partition", (int)i);
            this.partitionIDs.add(XMLHandler.getTagValue((Node)partitionNode, (String)"id"));
        }
        this.dynamicallyDefined = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)partitionSchemaNode, (String)"dynamic"));
        this.numberOfPartitionsPerSlave = XMLHandler.getTagValue((Node)partitionSchemaNode, (String)"partitions_per_slave");
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    @Override
    public ObjectId getObjectId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getHolderType() {
        return "PARTITION_SCHEMA";
    }

    @Override
    public String getTypeId() {
        return null;
    }

    public boolean isDynamicallyDefined() {
        return this.dynamicallyDefined;
    }

    public void setDynamicallyDefined(boolean dynamicallyDefined) {
        this.dynamicallyDefined = dynamicallyDefined;
    }

    public String getNumberOfPartitionsPerSlave() {
        return this.numberOfPartitionsPerSlave;
    }

    public void setNumberOfPartitionsPerSlave(String numberOfPartitionsPerSlave) {
        this.numberOfPartitionsPerSlave = numberOfPartitionsPerSlave;
    }

    public void expandPartitionsDynamically(int nrSlaves, VariableSpace space) {
        this.partitionIDs.clear();
        int nrPartitionsPerSlave = Const.toInt((String)space.environmentSubstitute(this.numberOfPartitionsPerSlave), (int)1);
        int totalNumberOfPartitions = nrSlaves * nrPartitionsPerSlave;
        for (int partitionNumber = 0; partitionNumber < totalNumberOfPartitions; ++partitionNumber) {
            this.partitionIDs.add("PDyn" + partitionNumber);
        }
        this.dynamicallyDefined = false;
        this.numberOfPartitionsPerSlave = null;
    }

    public void retainPartitionsForSlaveServer(int slaveCount, int slaveNumber) {
        ArrayList<String> ids = new ArrayList<String>();
        int partitionCount = this.partitionIDs.size();
        for (int i = 0; i < partitionCount; ++i) {
            if (slaveNumber != i % slaveCount) continue;
            ids.add(this.partitionIDs.get(i));
        }
        this.partitionIDs.clear();
        this.partitionIDs.addAll(ids);
    }

    public RepositoryDirectoryInterface getRepositoryDirectory() {
        return new RepositoryDirectory();
    }

    public void setRepositoryDirectory(RepositoryDirectoryInterface repositoryDirectory) {
    }

    public RepositoryObjectType getRepositoryElementType() {
        return REPOSITORY_ELEMENT_TYPE;
    }

    public void setObjectId(ObjectId id) {
        this.id = id;
    }

    public ObjectRevision getObjectRevision() {
        return this.objectRevision;
    }

    public void setObjectRevision(ObjectRevision objectRevision) {
        this.objectRevision = objectRevision;
    }

    public void setDescription(String description) {
    }

    public Date getChangedDate() {
        return this.changedDate;
    }

    public void setChangedDate(Date changedDate) {
        this.changedDate = changedDate;
    }
}

