/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.RepositoryElementReadListener;
import org.pentaho.di.repository.RepositoryImportFeedbackInterface;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryExportSaxParser
extends DefaultHandler2 {
    public static final String STRING_REPOSITORY = "repository";
    public static final String STRING_TRANSFORMATIONS = "transformations";
    public static final String STRING_TRANSFORMATION = "transformation";
    public static final String STRING_JOBS = "jobs";
    public static final String STRING_JOB = "job";
    private SAXParserFactory factory;
    private SAXParser saxParser;
    private RepositoryElementReadListener repositoryElementReadListener;
    private StringBuffer xml;
    private boolean add;
    private String filename;
    private boolean cdata;
    RepositoryImportFeedbackInterface feedback;

    public RepositoryExportSaxParser(String filename, RepositoryImportFeedbackInterface feedback) throws Exception {
        this.filename = filename;
        this.feedback = feedback;
        this.xml = new StringBuffer(50000);
        this.add = false;
        this.cdata = false;
    }

    public void parse(RepositoryElementReadListener repositoryElementReadListener) throws Exception {
        this.repositoryElementReadListener = repositoryElementReadListener;
        this.factory = SAXParserFactory.newInstance();
        this.saxParser = this.factory.newSAXParser();
        this.saxParser.parse(this.filename, (DefaultHandler)this);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.add = !STRING_REPOSITORY.equals(qName) && !STRING_TRANSFORMATIONS.equals(qName) && !STRING_JOBS.equals(qName);
        if (this.add) {
            if (STRING_TRANSFORMATION.equals(qName) || STRING_JOB.equals(qName)) {
                this.xml.setLength(0);
            }
            this.xml.append(XMLHandler.openTag((String)qName));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.add) {
            this.xml.append(XMLHandler.closeTag((String)qName));
        }
        if (STRING_TRANSFORMATION.equals(qName) && !this.repositoryElementReadListener.transformationElementRead(this.xml.toString(), this.feedback)) {
            this.saxParser.reset();
        }
        if (STRING_JOB.equals(qName) && !this.repositoryElementReadListener.jobElementRead(this.xml.toString(), this.feedback)) {
            this.saxParser.reset();
        }
    }

    public void startCDATA() throws SAXException {
        this.cdata = true;
    }

    public void endCDATA() throws SAXException {
        this.cdata = false;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.add) {
            String string = new String(ch, start, length);
            if (this.cdata) {
                this.xml.append(XMLHandler.buildCDATA((String)string));
            } else {
                XMLHandler.appendReplacedChars((StringBuffer)this.xml, (String)string);
            }
        }
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.repositoryElementReadListener.fatalXmlErrorEncountered(e);
    }
}

